/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms.providers;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.providers.AutoValue_JavaExplodeTransformProvider_Configuration;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Booleans;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class JavaExplodeTransformProvider
extends TypedSchemaTransformProvider<Configuration> {
    protected static final @UnknownKeyFor @NonNull @Initialized String INPUT_ROWS_TAG = "input";
    protected static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_ROWS_TAG = "output";

    @Override
    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized Configuration> configurationClass() {
        return Configuration.class;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
        return new ExplodeTransform(configuration);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:yaml:explode:v1";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList(INPUT_ROWS_TAG);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList(OUTPUT_ROWS_TAG);
    }

    protected static class ExplodeTransform
    extends SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized Configuration configuration;

        ExplodeTransform(@UnknownKeyFor @NonNull @Initialized Configuration configuration) {
            this.configuration = configuration;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            Schema inputSchema = input.get(JavaExplodeTransformProvider.INPUT_ROWS_TAG).getSchema();
            Schema.Builder outputSchemaBuilder = new Schema.Builder();
            for (Schema.Field field : inputSchema.getFields()) {
                if (this.configuration.getFields().contains(field.getName())) {
                    if (field.getType().getCollectionElementType() == null) {
                        throw new IllegalArgumentException(String.format("Exploded field %s must be an iterable type, got %s.", field.getName(), field.getType()));
                    }
                    outputSchemaBuilder = outputSchemaBuilder.addField(field.getName(), field.getType().getCollectionElementType());
                    continue;
                }
                outputSchemaBuilder = outputSchemaBuilder.addField(field);
            }
            Schema outputSchema = outputSchemaBuilder.build();
            PCollection result = (PCollection)((Object)input.get(JavaExplodeTransformProvider.INPUT_ROWS_TAG).apply("Explode", ParDo.of(ExplodeTransform.createDoFn(this.configuration.getFields(), this.configuration.getCrossProduct(), outputSchema))));
            result.setRowSchema(outputSchema);
            return PCollectionRowTuple.of(JavaExplodeTransformProvider.OUTPUT_ROWS_TAG, result);
        }

        private static @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Row> createDoFn(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fields, @UnknownKeyFor @NonNull @Initialized Boolean crossProductObj, final @UnknownKeyFor @NonNull @Initialized Schema outputSchema) {
            boolean crossProduct;
            if (crossProductObj == null) {
                if (fields.size() > 1) {
                    throw new IllegalArgumentException("boolean cross product parameter required to explode more than one field");
                }
                crossProduct = false;
            } else {
                crossProduct = crossProductObj;
            }
            final int numFields = outputSchema.getFields().size();
            final boolean[] toExplode = Booleans.toArray((Collection)IntStream.range(0, numFields).mapToObj(index -> fields.contains(outputSchema.getField(index).getName())).collect(Collectors.toList()));
            if (crossProduct) {
                return new DoFn<Row, Row>(){

                    @DoFn.ProcessElement
                    public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row inputRow, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> out) {
                        this.emitCrossProduct(inputRow, 0, new Object[numFields], out);
                    }

                    private void emitCrossProduct(@UnknownKeyFor @NonNull @Initialized Row inputRow, @UnknownKeyFor @NonNull @Initialized int index, @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] current, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> out) {
                        if (index == numFields) {
                            out.output(Row.withSchema(outputSchema).attachValues((List<Object>)ImmutableList.copyOf((Object[])current)));
                        } else if (toExplode[index]) {
                            for (Object value : inputRow.getIterable(index)) {
                                current[index] = value;
                                this.emitCrossProduct(inputRow, index + 1, current, out);
                            }
                        } else {
                            current[index] = inputRow.getValue(index);
                            this.emitCrossProduct(inputRow, index + 1, current, out);
                        }
                    }
                };
            }
            return new DoFn<Row, Row>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row inputRow, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> out) {
                    Iterator[] iterators = new Iterator[numFields];
                    for (int i = 0; i < numFields; ++i) {
                        if (!toExplode[i]) continue;
                        iterators[i] = inputRow.getIterable(i).iterator();
                    }
                    while (IntStream.range(0, numFields).anyMatch(index -> toExplode[index] && iterators[index].hasNext())) {
                        Row.Builder builder = Row.withSchema(outputSchema);
                        for (int i = 0; i < numFields; ++i) {
                            if (toExplode[i]) {
                                if (iterators[i].hasNext()) {
                                    builder.addValue(iterators[i].next());
                                    continue;
                                }
                                builder.addValue(null);
                                continue;
                            }
                            builder.addValue(inputRow.getValue(i));
                        }
                        out.output(builder.build());
                    }
                }
            };
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class Configuration {
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getFields();

        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Boolean getCrossProduct();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_JavaExplodeTransformProvider_Configuration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setFields(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setCrossProduct(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Configuration build();
        }
    }
}

