/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.mysqlbulkfile;

import java.io.File;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;

@Action(id="MYSQL_BULK_FILE", name="i18n::ActionMysqlBulkFile.Name", description="i18n::ActionMysqlBulkFile.Description", image="MysqlBulkFile.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.BulkLoading", keywords={"i18n::ActionMysqlBulkFile.keyword"}, documentationUrl="/workflow/actions/mysqlbulkfile.html", classLoaderGroup="mysql-db", isIncludeJdbcDrivers=true)
public class ActionMysqlBulkFile
extends ActionBase {
    private static final Class<?> PKG = ActionMysqlBulkFile.class;
    public static final String CONST_ACTION_MYSQL_BULK_FILE_FILE_EXISTS_1_LABEL = "ActionMysqlBulkFile.FileExists1.Label";
    public static final String CONST_ACTION_MYSQL_BULK_FILE_FILE_EXISTS_2_LABEL = "ActionMysqlBulkFile.FileExists2.Label";
    public static final String CONST_ACTION_MYSQL_BULK_FILE_ERROR_LABEL = "ActionMysqlBulkFile.Error.Label";
    @HopMetadataProperty(key="tablename")
    private String tableName = null;
    @HopMetadataProperty(key="schemaname")
    private String schemaName = null;
    @HopMetadataProperty(key="filename")
    private String fileName = null;
    @HopMetadataProperty(key="separator")
    private String separator = null;
    @HopMetadataProperty(key="enclosed")
    private String enclosed = null;
    @HopMetadataProperty(key="lineterminated")
    private String lineTerminated = null;
    @HopMetadataProperty(key="limitlines")
    private String limitLines = "0";
    @HopMetadataProperty(key="listcolumn")
    private String listColumn = null;
    @HopMetadataProperty(key="highpriority")
    private boolean highPriority = true;
    @HopMetadataProperty(key="optionenclosed")
    private boolean optionEnclosed = false;
    @HopMetadataProperty(key="outdumpvalue")
    public int outDumpValue;
    @HopMetadataProperty(key="iffileexists")
    public int ifFileExists = 2;
    @HopMetadataProperty(key="addfiletoresult")
    private boolean addFileToResult = false;
    @HopMetadataProperty(key="connection")
    private String connection = null;

    public ActionMysqlBulkFile(String n) {
        super(n, "");
    }

    public ActionMysqlBulkFile() {
        this("");
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    public Result execute(Result previousResult, int nr) {
        Object limitNbrLignes = "";
        String listOfColumn = "*";
        String strHighPriority = "";
        String outDumpText = "";
        Object optionEnclosed = "";
        Object fieldSeparator = "";
        Object linesTerminated = "";
        Result result = previousResult;
        result.setResult(false);
        if (this.fileName != null) {
            Object realFilename = this.getRealFilename();
            File file = new File((String)realFilename);
            if (file.exists() && this.ifFileExists == 2) {
                result.setResult(false);
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_MYSQL_BULK_FILE_FILE_EXISTS_1_LABEL, (String[])new String[0]) + (String)realFilename + BaseMessages.getString(PKG, (String)CONST_ACTION_MYSQL_BULK_FILE_FILE_EXISTS_2_LABEL, (String[])new String[0]));
            } else if (file.exists() && this.ifFileExists == 1) {
                result.setResult(true);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)CONST_ACTION_MYSQL_BULK_FILE_FILE_EXISTS_1_LABEL, (String[])new String[0]) + (String)realFilename + BaseMessages.getString(PKG, (String)CONST_ACTION_MYSQL_BULK_FILE_FILE_EXISTS_2_LABEL, (String[])new String[0]));
                }
            } else {
                if (file.exists() && this.ifFileExists == 0) {
                    String wildcard = ((String)realFilename).substring(((String)realFilename).length() - 4, ((String)realFilename).length());
                    realFilename = wildcard.substring(0, 1).equals(".") ? ((String)realFilename).substring(0, ((String)realFilename).length() - 4) + "_" + StringUtil.getFormattedDateTimeNow((boolean)true) + wildcard : (String)realFilename + "_" + StringUtil.getFormattedDateTimeNow((boolean)true);
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.FileNameChange1.Label", (String[])new String[0]) + (String)realFilename + BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.FileNameChange1.Label", (String[])new String[0]));
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)CONST_ACTION_MYSQL_BULK_FILE_FILE_EXISTS_1_LABEL, (String[])new String[0]) + (String)realFilename + BaseMessages.getString(PKG, (String)CONST_ACTION_MYSQL_BULK_FILE_FILE_EXISTS_2_LABEL, (String[])new String[0]));
                }
                if (this.connection != null) {
                    DatabaseMeta databaseMeta = null;
                    try {
                        databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)this.getMetadataProvider(), (String)this.connection);
                    }
                    catch (Exception e) {
                        this.logError("Unable to load database :" + this.connection, e);
                    }
                    try (Database db = new Database((ILoggingObject)this, (IVariables)this, databaseMeta);){
                        db.connect();
                        String realSchemaname = this.resolve(this.schemaName);
                        Object realTablename = this.resolve(this.tableName);
                        if (db.checkTableExists(realSchemaname, (String)realTablename)) {
                            if (this.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.TableExists1.Label", (String[])new String[0]) + (String)realTablename + BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.TableExists2.Label", (String[])new String[0]));
                            }
                            if (this.schemaName != null) {
                                realTablename = realSchemaname + "." + (String)realTablename;
                            }
                            if (Const.toInt((String)this.getRealLimitlines(), (int)0) > 0) {
                                limitNbrLignes = "LIMIT " + this.getRealLimitlines();
                            }
                            if (this.getRealListColumn() != null) {
                                listOfColumn = this.mysqlString(this.getRealListColumn());
                            }
                            if (this.getRealSeparator() != null && this.outDumpValue == 0) {
                                fieldSeparator = "FIELDS TERMINATED BY '" + Const.replace((String)this.getRealSeparator(), (String)"'", (String)"''") + "'";
                            }
                            if (this.getRealLineterminated() != null && this.outDumpValue == 0) {
                                linesTerminated = "LINES TERMINATED BY '" + Const.replace((String)this.getRealLineterminated(), (String)"'", (String)"''") + "'";
                            }
                            if (this.isHighPriority()) {
                                strHighPriority = "HIGH_PRIORITY";
                            }
                            if (this.getRealEnclosed() != null && this.outDumpValue == 0) {
                                if (this.isOptionEnclosed()) {
                                    optionEnclosed = "OPTIONALLY ";
                                }
                                optionEnclosed = (String)optionEnclosed + "ENCLOSED BY '" + Const.replace((String)this.getRealEnclosed(), (String)"'", (String)"''") + "'";
                            }
                            outDumpText = this.outDumpValue == 0 ? "INTO OUTFILE" : "INTO DUMPFILE";
                            String fileBulkFile = "SELECT " + strHighPriority + " " + listOfColumn + " " + outDumpText + " '" + (String)realFilename + "' " + (String)fieldSeparator + " " + (String)optionEnclosed + " " + (String)linesTerminated + " FROM " + (String)realTablename + " " + (String)limitNbrLignes + " LOCK IN SHARE MODE";
                            try {
                                if (this.isDetailed()) {
                                    this.logDetailed(fileBulkFile);
                                }
                                PreparedStatement ps = db.prepareSql(fileBulkFile);
                                ps.execute();
                                if (this.isAddFileToResult()) {
                                    ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)realFilename), this.parentWorkflow.getWorkflowName(), this.toString());
                                    result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                                }
                                result.setResult(true);
                            }
                            catch (SQLException je) {
                                result.setNrErrors(1L);
                                this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_MYSQL_BULK_FILE_ERROR_LABEL, (String[])new String[0]) + " " + je.getMessage());
                            }
                            catch (HopFileException e) {
                                this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_MYSQL_BULK_FILE_ERROR_LABEL, (String[])new String[0]) + e.getMessage());
                                result.setNrErrors(1L);
                            }
                        } else {
                            result.setNrErrors(1L);
                            if (this.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.TableNotExists1.Label", (String[])new String[0]) + (String)realTablename + BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.TableNotExists2.Label", (String[])new String[0]));
                            }
                        }
                    }
                    catch (HopDatabaseException dbe) {
                        result.setNrErrors(1L);
                        this.logError(BaseMessages.getString(PKG, (String)CONST_ACTION_MYSQL_BULK_FILE_ERROR_LABEL, (String[])new String[0]) + " " + dbe.getMessage());
                    }
                } else {
                    result.setNrErrors(1L);
                    this.logError(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.NoDatabase.Label", (String[])new String[0]));
                }
            }
        } else {
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.NoFileName.Label", (String[])new String[0]));
        }
        return result;
    }

    public String getRealFilename() {
        String realFile = this.resolve(this.getFileName());
        return realFile.replace('\\', '/');
    }

    public String getRealLineterminated() {
        return this.resolve(this.getLineTerminated());
    }

    public String getRealSeparator() {
        return this.resolve(this.getSeparator());
    }

    public String getRealEnclosed() {
        return this.resolve(this.getEnclosed());
    }

    public String getRealLimitlines() {
        return this.resolve(this.getLimitLines());
    }

    public String getRealListColumn() {
        return this.resolve(this.getListColumn());
    }

    private String mysqlString(String listcolumns) {
        Object returnString = "";
        String[] split = listcolumns.split(",");
        for (int i = 0; i < split.length; ++i) {
            returnString = ((String)returnString).equals("") ? "`" + Const.trim((String)split[i]) + "`" : (String)returnString + ", `" + Const.trim((String)split[i]) + "`";
        }
        return returnString;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (this.connection != null) {
            DatabaseMeta databaseMeta = null;
            try {
                databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)this.getMetadataProvider(), (String)this.connection);
            }
            catch (Exception e) {
                this.logError("Unable to load database :" + this.connection, e);
            }
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(databaseMeta.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(databaseMeta.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "tablename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public String getSeparator() {
        return this.separator;
    }

    @Generated
    public String getEnclosed() {
        return this.enclosed;
    }

    @Generated
    public String getLineTerminated() {
        return this.lineTerminated;
    }

    @Generated
    public String getLimitLines() {
        return this.limitLines;
    }

    @Generated
    public String getListColumn() {
        return this.listColumn;
    }

    @Generated
    public boolean isHighPriority() {
        return this.highPriority;
    }

    @Generated
    public boolean isOptionEnclosed() {
        return this.optionEnclosed;
    }

    @Generated
    public int getOutDumpValue() {
        return this.outDumpValue;
    }

    @Generated
    public int getIfFileExists() {
        return this.ifFileExists;
    }

    @Generated
    public boolean isAddFileToResult() {
        return this.addFileToResult;
    }

    @Generated
    public String getConnection() {
        return this.connection;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Generated
    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Generated
    public void setEnclosed(String enclosed) {
        this.enclosed = enclosed;
    }

    @Generated
    public void setLineTerminated(String lineTerminated) {
        this.lineTerminated = lineTerminated;
    }

    @Generated
    public void setLimitLines(String limitLines) {
        this.limitLines = limitLines;
    }

    @Generated
    public void setListColumn(String listColumn) {
        this.listColumn = listColumn;
    }

    @Generated
    public void setHighPriority(boolean highPriority) {
        this.highPriority = highPriority;
    }

    @Generated
    public void setOptionEnclosed(boolean optionEnclosed) {
        this.optionEnclosed = optionEnclosed;
    }

    @Generated
    public void setOutDumpValue(int outDumpValue) {
        this.outDumpValue = outDumpValue;
    }

    @Generated
    public void setIfFileExists(int ifFileExists) {
        this.ifFileExists = ifFileExists;
    }

    @Generated
    public void setAddFileToResult(boolean addFileToResult) {
        this.addFileToResult = addFileToResult;
    }

    @Generated
    public void setConnection(String connection) {
        this.connection = connection;
    }
}

