/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mapping;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.ActionTransformType;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.ISubPipelineAwareMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.TransformWithMappingMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.input.MappingInputMeta;
import org.apache.hop.pipeline.transforms.mapping.IOMappings;
import org.apache.hop.pipeline.transforms.mapping.MappingIODefinition;
import org.apache.hop.pipeline.transforms.mapping.MappingParameters;
import org.apache.hop.pipeline.transforms.mapping.MappingValueRename;
import org.apache.hop.pipeline.transforms.mapping.SimpleMapping;
import org.apache.hop.pipeline.transforms.mapping.SimpleMappingData;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;

@Transform(id="SimpleMapping", name="i18n::BaseTransform.TypeLongDesc.SimpleMapping", description="i18n::BaseTransform.TypeTooltipDesc.SimpleMapping", image="MAP.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Mapping", keywords={"i18n::SimpleMappingMeta.keyword"}, documentationUrl="/pipeline/transforms/simple-mapping.html", actionTransformTypes={ActionTransformType.HOP_FILE, ActionTransformType.HOP_PIPELINE})
public class SimpleMappingMeta
extends TransformWithMappingMeta<SimpleMapping, SimpleMappingData>
implements ISubPipelineAwareMeta {
    private static final Class<?> PKG = SimpleMappingMeta.class;
    @HopMetadataProperty(key="runConfiguration")
    private String runConfigurationName;
    @HopMetadataProperty(key="mappings")
    private IOMappings ioMappings;

    public SimpleMappingMeta() {
        this.ioMappings = new IOMappings();
    }

    public SimpleMappingMeta(SimpleMappingMeta m) {
        super((TransformWithMappingMeta)m);
        this.runConfigurationName = m.runConfigurationName;
        this.ioMappings = new IOMappings(m.ioMappings);
    }

    public SimpleMappingMeta clone() {
        return new SimpleMappingMeta(this);
    }

    public void setDefault() {
        MappingIODefinition inputDefinition = new MappingIODefinition(null, null);
        inputDefinition.setMainDataPath(true);
        inputDefinition.setRenamingOnOutput(true);
        this.ioMappings.setInputMapping(inputDefinition);
        MappingIODefinition outputDefinition = new MappingIODefinition(null, null);
        outputDefinition.setMainDataPath(true);
        this.ioMappings.setOutputMapping(outputDefinition);
    }

    public void getFields(IRowMeta row, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        IValueMeta valueMeta;
        PipelineMeta mappingPipelineMeta;
        try {
            mappingPipelineMeta = SimpleMappingMeta.loadMappingMeta((TransformWithMappingMeta)this, (IHopMetadataProvider)metadataProvider, (IVariables)variables);
        }
        catch (HopException e) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"SimpleMappingMeta.Exception.UnableToLoadMappingPipeline", (String[])new String[0]), (Throwable)e);
        }
        IRowMeta inputRowMeta = row.clone();
        if (!inputRowMeta.isEmpty()) {
            for (MappingValueRename valueRename : this.ioMappings.getInputMapping().getValueRenames()) {
                IValueMeta valueMeta2 = inputRowMeta.searchValueMeta(valueRename.getSourceValueName());
                if (valueMeta2 == null) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"SimpleMappingMeta.Exception.UnableToFindField", (String[])new String[]{valueRename.getSourceValueName()}));
                }
                valueMeta2.setName(valueRename.getTargetValueName());
            }
        }
        TransformMeta mappingInputTransform = mappingPipelineMeta.findMappingInputTransform(null);
        TransformMeta mappingOutputTransform = mappingPipelineMeta.findMappingOutputTransform(null);
        MappingInputMeta mappingInputMeta = (MappingInputMeta)mappingInputTransform.getTransform();
        mappingInputMeta.setInputRowMeta(inputRowMeta);
        IRowMeta mappingOutputRowMeta = mappingPipelineMeta.getTransformFields(variables, mappingOutputTransform);
        if (this.ioMappings.getInputMapping().isRenamingOnOutput()) {
            for (MappingValueRename rename : this.ioMappings.getInputMapping().getValueRenames()) {
                valueMeta = mappingOutputRowMeta.searchValueMeta(rename.getTargetValueName());
                if (valueMeta == null) continue;
                valueMeta.setName(rename.getSourceValueName());
            }
        }
        for (MappingValueRename rename : this.ioMappings.getOutputMapping().getValueRenames()) {
            valueMeta = mappingOutputRowMeta.searchValueMeta(rename.getSourceValueName());
            if (valueMeta == null) continue;
            valueMeta.setName(rename.getTargetValueName());
        }
        row.clear();
        row.addRowMeta(mappingOutputRowMeta);
    }

    public String[] getInfoTransforms() {
        return null;
    }

    public String[] getTargetTransforms() {
        return null;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"SimpleMappingMeta.CheckResult.NotReceivingAnyFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SimpleMappingMeta.CheckResult.TransformReceivingFields", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SimpleMappingMeta.CheckResult.TransformReceivingFieldsFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SimpleMappingMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public MappingParameters getMappingParameters() {
        return this.ioMappings.getMappingParameters();
    }

    public void setMappingParameters(MappingParameters mappingParameters) {
        this.ioMappings.setMappingParameters(mappingParameters);
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, TransformMeta transformMeta) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        String realFilename = variables.resolve(this.filename);
        ResourceReference reference = new ResourceReference((IResourceHolder)transformMeta);
        references.add(reference);
        if (StringUtils.isNotEmpty((String)realFilename)) {
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.ACTIONFILE));
        }
        return references;
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, true, false, false, false, false);
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }

    public boolean excludeFromRowLayoutVerification() {
        return false;
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
    }

    public PipelineMeta.PipelineType[] getSupportedPipelineTypes() {
        return new PipelineMeta.PipelineType[]{PipelineMeta.PipelineType.Normal};
    }

    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"SimpleMappingMeta.ReferencedObject.Description", (String[])new String[0])};
    }

    private boolean isMapppingDefined() {
        return StringUtils.isNotEmpty((String)this.filename);
    }

    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.isMapppingDefined()};
    }

    public IHasFilename loadReferencedObject(int index, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return SimpleMappingMeta.loadMappingMeta((TransformWithMappingMeta)this, (IHopMetadataProvider)metadataProvider, (IVariables)variables);
    }

    public MappingIODefinition getInputMapping() {
        return this.ioMappings.getInputMapping();
    }

    public void setInputMapping(MappingIODefinition inputMapping) {
        this.ioMappings.setInputMapping(inputMapping);
    }

    public MappingIODefinition getOutputMapping() {
        return this.ioMappings.getOutputMapping();
    }

    public void setOutputMapping(MappingIODefinition outputMapping) {
        this.ioMappings.setOutputMapping(outputMapping);
    }

    public String getRunConfigurationName() {
        return this.runConfigurationName;
    }

    public void setRunConfigurationName(String runConfigurationName) {
        this.runConfigurationName = runConfigurationName;
    }

    public IOMappings getIoMappings() {
        return this.ioMappings;
    }

    public void setIoMappings(IOMappings ioMappings) {
        this.ioMappings = ioMappings;
    }
}

