/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.estimator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.estimator.SizeEstimator;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

@Internal
public class BytesThroughputEstimator<@UnknownKeyFor T> {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 6014227751984587954L;
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_SAMPLE_RATE = 50;
    private final @UnknownKeyFor @NonNull @Initialized SizeEstimator<T> sizeEstimator;
    private final @UnknownKeyFor @NonNull @Initialized int sampleRate;
    private @UnknownKeyFor @NonNull @Initialized long elementCount;
    private @UnknownKeyFor @NonNull @Initialized BigDecimal currentElementSizeEstimate;
    private final @UnknownKeyFor @NonNull @Initialized Instant startTimestamp;
    private @UnknownKeyFor @NonNull @Initialized Instant lastElementTimestamp;
    private @UnknownKeyFor @NonNull @Initialized BigDecimal totalThroughputEstimate;

    public BytesThroughputEstimator(@UnknownKeyFor @NonNull @Initialized SizeEstimator<T> sizeEstimator, @Nullable @UnknownKeyFor @Initialized Instant lastRunTimestamp) {
        this(sizeEstimator, 50, lastRunTimestamp != null ? lastRunTimestamp : Instant.now());
    }

    @VisibleForTesting
    public BytesThroughputEstimator(@UnknownKeyFor @NonNull @Initialized SizeEstimator<T> sizeEstimator, @UnknownKeyFor @NonNull @Initialized int sampleRate, @UnknownKeyFor @NonNull @Initialized Instant startTimestamp) {
        this.sizeEstimator = sizeEstimator;
        this.sampleRate = sampleRate;
        this.startTimestamp = startTimestamp;
        this.elementCount = 0L;
        this.currentElementSizeEstimate = BigDecimal.ZERO;
        this.lastElementTimestamp = this.startTimestamp;
        this.totalThroughputEstimate = BigDecimal.ZERO;
    }

    public void update(@UnknownKeyFor @NonNull @Initialized Instant timeOfRecords, T element) {
        if (this.elementCount % (long)this.sampleRate == 0L) {
            this.currentElementSizeEstimate = BigDecimal.valueOf(this.sizeEstimator.sizeOf(element));
        }
        this.lastElementTimestamp = timeOfRecords;
        ++this.elementCount;
        this.totalThroughputEstimate = this.totalThroughputEstimate.add(this.currentElementSizeEstimate);
    }

    public @UnknownKeyFor @NonNull @Initialized BigDecimal get() {
        if (this.elementCount == 0L) {
            return BigDecimal.ZERO;
        }
        BigDecimal processingTimeMillis = BigDecimal.valueOf(new Duration((ReadableInstant)this.startTimestamp, (ReadableInstant)this.lastElementTimestamp).getMillis()).max(BigDecimal.ONE);
        return this.totalThroughputEstimate.divide(processingTimeMillis, 3, RoundingMode.DOWN).multiply(BigDecimal.valueOf(1000L));
    }
}

