/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.spanner.Mutation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Objects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class MutationGroup
implements Serializable,
Iterable<Mutation> {
    private final @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized Mutation> mutations;

    public static @UnknownKeyFor @NonNull @Initialized MutationGroup create(@UnknownKeyFor @NonNull @Initialized Mutation primary, Mutation ... other) {
        return MutationGroup.create(primary, Arrays.asList(other));
    }

    public static @UnknownKeyFor @NonNull @Initialized MutationGroup create(@UnknownKeyFor @NonNull @Initialized Mutation primary, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Mutation> other) {
        return new MutationGroup((ImmutableList<Mutation>)ImmutableList.builder().add((Object)primary).addAll(other).build());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Mutation> iterator() {
        return this.mutations.iterator();
    }

    public @UnknownKeyFor @NonNull @Initialized long size() {
        return this.mutations.size();
    }

    private MutationGroup(@UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized Mutation> mutations) {
        this.mutations = mutations;
    }

    public @UnknownKeyFor @NonNull @Initialized Mutation primary() {
        return (Mutation)this.mutations.get(0);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Mutation> attached() {
        return this.mutations.subList(1, this.mutations.size());
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutationGroup mutations1 = (MutationGroup)o;
        return Objects.equal(this.mutations, mutations1.mutations);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mutations});
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder sb = new StringBuilder("MutationGroup(");
        sb.append(this.mutations);
        sb.append(")");
        return sb.toString();
    }
}

