/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams;

import org.apache.beam.sdk.io.gcp.spanner.changestreams.SpannerChangestreamsReadSchemaTransformProvider;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_SpannerChangestreamsReadSchemaTransformProvider_SpannerChangestreamsReadConfiguration
extends SpannerChangestreamsReadSchemaTransformProvider.SpannerChangestreamsReadConfiguration {
    private final String databaseId;
    private final String projectId;
    private final String instanceId;
    private final String table;
    private final String startAtTimestamp;
    private final @Nullable String endAtTimestamp;
    private final String changeStreamName;

    private AutoValue_SpannerChangestreamsReadSchemaTransformProvider_SpannerChangestreamsReadConfiguration(String databaseId, String projectId, String instanceId, String table, String startAtTimestamp, @Nullable String endAtTimestamp, String changeStreamName) {
        this.databaseId = databaseId;
        this.projectId = projectId;
        this.instanceId = instanceId;
        this.table = table;
        this.startAtTimestamp = startAtTimestamp;
        this.endAtTimestamp = endAtTimestamp;
        this.changeStreamName = changeStreamName;
    }

    @Override
    @SchemaFieldDescription(value="Specifies the Cloud Spanner database.")
    public String getDatabaseId() {
        return this.databaseId;
    }

    @Override
    @SchemaFieldDescription(value="Specifies the Cloud Spanner project.")
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    @SchemaFieldDescription(value="Specifies the Cloud Spanner instance.")
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    @SchemaFieldDescription(value="Specifies the Cloud Spanner table.")
    public String getTable() {
        return this.table;
    }

    @Override
    @SchemaFieldDescription(value="Specifies the time that the change stream should be read from.")
    public String getStartAtTimestamp() {
        return this.startAtTimestamp;
    }

    @Override
    @SchemaFieldDescription(value="Specifies the end time of the change stream.")
    public @Nullable String getEndAtTimestamp() {
        return this.endAtTimestamp;
    }

    @Override
    @SchemaFieldDescription(value="Specifies the change stream name.")
    public String getChangeStreamName() {
        return this.changeStreamName;
    }

    public String toString() {
        return "SpannerChangestreamsReadConfiguration{databaseId=" + this.databaseId + ", projectId=" + this.projectId + ", instanceId=" + this.instanceId + ", table=" + this.table + ", startAtTimestamp=" + this.startAtTimestamp + ", endAtTimestamp=" + this.endAtTimestamp + ", changeStreamName=" + this.changeStreamName + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SpannerChangestreamsReadSchemaTransformProvider.SpannerChangestreamsReadConfiguration) {
            SpannerChangestreamsReadSchemaTransformProvider.SpannerChangestreamsReadConfiguration that = (SpannerChangestreamsReadSchemaTransformProvider.SpannerChangestreamsReadConfiguration)o;
            return this.databaseId.equals(that.getDatabaseId()) && this.projectId.equals(that.getProjectId()) && this.instanceId.equals(that.getInstanceId()) && this.table.equals(that.getTable()) && this.startAtTimestamp.equals(that.getStartAtTimestamp()) && (this.endAtTimestamp == null ? that.getEndAtTimestamp() == null : this.endAtTimestamp.equals(that.getEndAtTimestamp())) && this.changeStreamName.equals(that.getChangeStreamName());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.databaseId.hashCode();
        h$ *= 1000003;
        h$ ^= this.projectId.hashCode();
        h$ *= 1000003;
        h$ ^= this.instanceId.hashCode();
        h$ *= 1000003;
        h$ ^= this.table.hashCode();
        h$ *= 1000003;
        h$ ^= this.startAtTimestamp.hashCode();
        h$ *= 1000003;
        h$ ^= this.endAtTimestamp == null ? 0 : this.endAtTimestamp.hashCode();
        h$ *= 1000003;
        return h$ ^= this.changeStreamName.hashCode();
    }

    static final class Builder
    extends SpannerChangestreamsReadSchemaTransformProvider.SpannerChangestreamsReadConfiguration.Builder {
        private String databaseId;
        private String projectId;
        private String instanceId;
        private String table;
        private String startAtTimestamp;
        private @Nullable String endAtTimestamp;
        private String changeStreamName;

        Builder() {
        }

        @Override
        public SpannerChangestreamsReadSchemaTransformProvider.SpannerChangestreamsReadConfiguration.Builder setDatabaseId(String databaseId) {
            if (databaseId == null) {
                throw new NullPointerException("Null databaseId");
            }
            this.databaseId = databaseId;
            return this;
        }

        @Override
        public SpannerChangestreamsReadSchemaTransformProvider.SpannerChangestreamsReadConfiguration.Builder setProjectId(String projectId) {
            if (projectId == null) {
                throw new NullPointerException("Null projectId");
            }
            this.projectId = projectId;
            return this;
        }

        @Override
        public SpannerChangestreamsReadSchemaTransformProvider.SpannerChangestreamsReadConfiguration.Builder setInstanceId(String instanceId) {
            if (instanceId == null) {
                throw new NullPointerException("Null instanceId");
            }
            this.instanceId = instanceId;
            return this;
        }

        @Override
        public SpannerChangestreamsReadSchemaTransformProvider.SpannerChangestreamsReadConfiguration.Builder setTable(String table) {
            if (table == null) {
                throw new NullPointerException("Null table");
            }
            this.table = table;
            return this;
        }

        @Override
        public SpannerChangestreamsReadSchemaTransformProvider.SpannerChangestreamsReadConfiguration.Builder setStartAtTimestamp(String startAtTimestamp) {
            if (startAtTimestamp == null) {
                throw new NullPointerException("Null startAtTimestamp");
            }
            this.startAtTimestamp = startAtTimestamp;
            return this;
        }

        @Override
        public SpannerChangestreamsReadSchemaTransformProvider.SpannerChangestreamsReadConfiguration.Builder setEndAtTimestamp(String endAtTimestamp) {
            this.endAtTimestamp = endAtTimestamp;
            return this;
        }

        @Override
        public SpannerChangestreamsReadSchemaTransformProvider.SpannerChangestreamsReadConfiguration.Builder setChangeStreamName(String changeStreamName) {
            if (changeStreamName == null) {
                throw new NullPointerException("Null changeStreamName");
            }
            this.changeStreamName = changeStreamName;
            return this;
        }

        @Override
        public SpannerChangestreamsReadSchemaTransformProvider.SpannerChangestreamsReadConfiguration build() {
            if (this.databaseId == null || this.projectId == null || this.instanceId == null || this.table == null || this.startAtTimestamp == null || this.changeStreamName == null) {
                StringBuilder missing = new StringBuilder();
                if (this.databaseId == null) {
                    missing.append(" databaseId");
                }
                if (this.projectId == null) {
                    missing.append(" projectId");
                }
                if (this.instanceId == null) {
                    missing.append(" instanceId");
                }
                if (this.table == null) {
                    missing.append(" table");
                }
                if (this.startAtTimestamp == null) {
                    missing.append(" startAtTimestamp");
                }
                if (this.changeStreamName == null) {
                    missing.append(" changeStreamName");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SpannerChangestreamsReadSchemaTransformProvider_SpannerChangestreamsReadConfiguration(this.databaseId, this.projectId, this.instanceId, this.table, this.startAtTimestamp, this.endAtTimestamp, this.changeStreamName);
        }
    }
}

