/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.estimator;

import com.google.cloud.Timestamp;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.estimator.SizeEstimator;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.estimator.ThroughputEstimator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BytesThroughputEstimator<@UnknownKeyFor T>
implements ThroughputEstimator<T> {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -3597929310338724800L;
    private static final @UnknownKeyFor @NonNull @Initialized BigDecimal MAX_DOUBLE = BigDecimal.valueOf(Double.MAX_VALUE);
    private final @UnknownKeyFor @NonNull @Initialized Deque<@UnknownKeyFor @NonNull @Initialized ThroughputEntry> deque = new ArrayDeque<ThroughputEntry>();
    private final @UnknownKeyFor @NonNull @Initialized int windowSizeSeconds;
    private final @UnknownKeyFor @NonNull @Initialized SizeEstimator<T> sizeEstimator;

    public BytesThroughputEstimator(@UnknownKeyFor @NonNull @Initialized int windowSizeSeconds, @UnknownKeyFor @NonNull @Initialized SizeEstimator<T> sizeEstimator) {
        this.windowSizeSeconds = windowSizeSeconds;
        this.sizeEstimator = sizeEstimator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(@UnknownKeyFor @NonNull @Initialized Timestamp timeOfRecords, T element) {
        long bytes = this.sizeEstimator.sizeOf(element);
        Deque<ThroughputEntry> deque = this.deque;
        synchronized (deque) {
            if (this.deque.isEmpty() || timeOfRecords.getSeconds() > this.deque.getLast().getSeconds()) {
                this.deque.addLast(new ThroughputEntry(timeOfRecords, bytes));
            } else {
                this.deque.getLast().addBytes(bytes);
            }
            this.cleanQueue(this.deque.getLast().getTimestamp());
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized double get() {
        return this.getFrom(Timestamp.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized double getFrom(@UnknownKeyFor @NonNull @Initialized Timestamp time) {
        Deque<ThroughputEntry> deque = this.deque;
        synchronized (deque) {
            this.cleanQueue(time);
            if (this.deque.size() == 0) {
                return 0.0;
            }
            BigDecimal throughput = BigDecimal.ZERO;
            for (ThroughputEntry entry : this.deque) {
                throughput = throughput.add(entry.getBytes());
            }
            return throughput.max(BigDecimal.ZERO).divide(BigDecimal.valueOf(this.windowSizeSeconds), MathContext.DECIMAL128).min(MAX_DOUBLE).doubleValue();
        }
    }

    private void cleanQueue(@UnknownKeyFor @NonNull @Initialized Timestamp time) {
        ThroughputEntry entry;
        while (this.deque.size() > 0 && ((entry = this.deque.getFirst()) == null || entry.getSeconds() < time.getSeconds() - (long)this.windowSizeSeconds)) {
            this.deque.removeFirst();
        }
    }

    private static class ThroughputEntry
    implements Serializable {
        private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 3752325891215855332L;
        private final @UnknownKeyFor @NonNull @Initialized Timestamp timestamp;
        private @UnknownKeyFor @NonNull @Initialized BigDecimal bytes;

        public ThroughputEntry(@UnknownKeyFor @NonNull @Initialized Timestamp timestamp, @UnknownKeyFor @NonNull @Initialized long bytes) {
            this.timestamp = timestamp;
            this.bytes = BigDecimal.valueOf(bytes);
        }

        public @UnknownKeyFor @NonNull @Initialized Timestamp getTimestamp() {
            return this.timestamp;
        }

        public @UnknownKeyFor @NonNull @Initialized long getSeconds() {
            return this.timestamp.getSeconds();
        }

        public @UnknownKeyFor @NonNull @Initialized BigDecimal getBytes() {
            return this.bytes;
        }

        public void addBytes(@UnknownKeyFor @NonNull @Initialized long bytesToAdd) {
            this.bytes = this.bytes.add(BigDecimal.valueOf(bytesToAdd));
        }
    }
}

