/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@DefaultCoder(value=AvroCoder.class)
public class ChildPartition
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -650413326832931368L;
    private @UnknownKeyFor @NonNull @Initialized String token;
    private @UnknownKeyFor @NonNull @Initialized HashSet<@UnknownKeyFor @NonNull @Initialized String> parentTokens;

    private ChildPartition() {
    }

    public ChildPartition(@UnknownKeyFor @NonNull @Initialized String token, @UnknownKeyFor @NonNull @Initialized HashSet<@UnknownKeyFor @NonNull @Initialized String> parentTokens) {
        this.token = token;
        this.parentTokens = parentTokens;
    }

    public ChildPartition(@UnknownKeyFor @NonNull @Initialized String token, @UnknownKeyFor @NonNull @Initialized String parentToken) {
        this(token, Sets.newHashSet((Object[])new String[]{parentToken}));
    }

    public @UnknownKeyFor @NonNull @Initialized String getToken() {
        return this.token;
    }

    public @UnknownKeyFor @NonNull @Initialized HashSet<@UnknownKeyFor @NonNull @Initialized String> getParentTokens() {
        return this.parentTokens;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChildPartition)) {
            return false;
        }
        ChildPartition that = (ChildPartition)o;
        return Objects.equals(this.token, that.token) && Objects.equals(this.parentTokens, that.parentTokens);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.token, this.parentTokens);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "ChildPartition{childToken='" + this.token + '\'' + ", parentTokens=" + this.parentTokens + '}';
    }
}

