/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.testing;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.model.Clustering;
import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.JobStatistics4;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.FileReader;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.gcp.util.BackOffAdapter;
import org.apache.beam.sdk.extensions.gcp.util.Transport;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.io.gcp.testing.FakeBigQueryServices;
import org.apache.beam.sdk.io.gcp.testing.FakeDatasetService;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.HashBasedTable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Table;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@Internal
public class FakeJobService
implements BigQueryServices.JobService,
Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized JsonFactory JSON_FACTORY = Transport.getJsonFactory();
    private static final @UnknownKeyFor @NonNull @Initialized int GET_JOBS_TRANSITION_INTERVAL = 2;
    private @UnknownKeyFor @NonNull @Initialized int numFailuresExpected;
    private @UnknownKeyFor @NonNull @Initialized int numFailures = 0;
    private final @UnknownKeyFor @NonNull @Initialized FakeDatasetService datasetService = new FakeDatasetService();
    private static @UnknownKeyFor @NonNull @Initialized Table<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JobInfo> allJobs;
    private static @UnknownKeyFor @NonNull @Initialized int numExtractJobCalls;
    private static @UnknownKeyFor @NonNull @Initialized Table<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId>> filesForLoadJobs;
    private static @UnknownKeyFor @NonNull @Initialized Table<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JobStatistics> dryRunQueryResults;

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
    }

    public FakeJobService() {
        this(0);
    }

    public FakeJobService(@UnknownKeyFor @NonNull @Initialized int numFailures) {
        this.numFailuresExpected = numFailures;
    }

    public void setNumFailuresExpected(@UnknownKeyFor @NonNull @Initialized int numFailuresExpected) {
        this.numFailuresExpected = numFailuresExpected;
    }

    public static void setUp() {
        allJobs = HashBasedTable.create();
        numExtractJobCalls = 0;
        filesForLoadJobs = HashBasedTable.create();
        dryRunQueryResults = HashBasedTable.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startLoadJob(@UnknownKeyFor @NonNull @Initialized JobReference jobRef, @UnknownKeyFor @NonNull @Initialized JobConfigurationLoad loadConfig) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Class<FakeJobService> clazz = FakeJobService.class;
        synchronized (FakeJobService.class) {
            this.verifyUniqueJobId(jobRef.getJobId());
            Job job = new Job();
            job.setJobReference(jobRef);
            job.setConfiguration(new JobConfiguration().setLoad(loadConfig));
            job.setKind(" bigquery#job");
            job.setStatus(new JobStatus().setState("PENDING"));
            if (loadConfig.getSourceUris().size() > 0) {
                ImmutableList.Builder sourceFiles = ImmutableList.builder();
                ImmutableList.Builder loadFiles = ImmutableList.builder();
                for (String filename : loadConfig.getSourceUris()) {
                    sourceFiles.add((Object)FileSystems.matchNewResource((String)filename, (boolean)false));
                    loadFiles.add((Object)FileSystems.matchNewResource((String)(filename + ThreadLocalRandom.current().nextInt()), (boolean)false));
                }
                FileSystems.copy((List)sourceFiles.build(), (List)loadFiles.build(), (MoveOptions[])new MoveOptions[0]);
                filesForLoadJobs.put((Object)jobRef.getProjectId(), (Object)jobRef.getJobId(), (Object)loadFiles.build());
            }
            allJobs.put((Object)jobRef.getProjectId(), (Object)jobRef.getJobId(), (Object)new JobInfo(job));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void startLoadJob(@UnknownKeyFor @NonNull @Initialized JobReference jobRef, @UnknownKeyFor @NonNull @Initialized JobConfigurationLoad loadConfig, @UnknownKeyFor @NonNull @Initialized AbstractInputStreamContent streamContent) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startExtractJob(@UnknownKeyFor @NonNull @Initialized JobReference jobRef, @UnknownKeyFor @NonNull @Initialized JobConfigurationExtract extractConfig) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkArgument((boolean)"AVRO".equals(extractConfig.getDestinationFormat()), (Object)"Only extract to AVRO is supported");
        Class<FakeJobService> clazz = FakeJobService.class;
        synchronized (FakeJobService.class) {
            this.verifyUniqueJobId(jobRef.getJobId());
            ++numExtractJobCalls;
            Job job = new Job();
            job.setJobReference(jobRef);
            job.setConfiguration(new JobConfiguration().setExtract(extractConfig));
            job.setKind(" bigquery#job");
            job.setStatus(new JobStatus().setState("PENDING"));
            allJobs.put((Object)jobRef.getProjectId(), (Object)jobRef.getJobId(), (Object)new JobInfo(job));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @UnknownKeyFor @NonNull @Initialized int getNumExtractJobCalls() {
        Class<FakeJobService> clazz = FakeJobService.class;
        synchronized (FakeJobService.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return numExtractJobCalls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startQueryJob(@UnknownKeyFor @NonNull @Initialized JobReference jobRef, @UnknownKeyFor @NonNull @Initialized JobConfigurationQuery query) {
        Class<FakeJobService> clazz = FakeJobService.class;
        synchronized (FakeJobService.class) {
            Job job = new Job();
            job.setJobReference(jobRef);
            job.setConfiguration(new JobConfiguration().setQuery(query));
            job.setKind(" bigquery#job");
            job.setStatus(new JobStatus().setState("PENDING"));
            allJobs.put((Object)jobRef.getProjectId(), (Object)jobRef.getJobId(), (Object)new JobInfo(job));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startCopyJob(@UnknownKeyFor @NonNull @Initialized JobReference jobRef, @UnknownKeyFor @NonNull @Initialized JobConfigurationTableCopy copyConfig) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Class<FakeJobService> clazz = FakeJobService.class;
        synchronized (FakeJobService.class) {
            this.verifyUniqueJobId(jobRef.getJobId());
            Job job = new Job();
            job.setJobReference(jobRef);
            job.setConfiguration(new JobConfiguration().setCopy(copyConfig));
            job.setKind(" bigquery#job");
            job.setStatus(new JobStatus().setState("PENDING"));
            allJobs.put((Object)jobRef.getProjectId(), (Object)jobRef.getJobId(), (Object)new JobInfo(job));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Job pollJob(@UnknownKeyFor @NonNull @Initialized JobReference jobRef, @UnknownKeyFor @NonNull @Initialized int maxAttempts) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
        BackOff backoff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)FluentBackoff.DEFAULT.withMaxRetries(maxAttempts).withInitialBackoff(Duration.millis((long)10L)).withMaxBackoff(Duration.standardSeconds((long)1L)).backoff());
        Sleeper sleeper = Sleeper.DEFAULT;
        try {
            do {
                JobStatus status;
                Job job;
                if ((job = this.getJob(jobRef)) == null || (status = job.getStatus()) == null || !"DONE".equals(status.getState()) && !"FAILED".equals(status.getState())) continue;
                return job;
            } while (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff));
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expectDryRunQuery(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String query, @UnknownKeyFor @NonNull @Initialized JobStatistics result) {
        Class<FakeJobService> clazz = FakeJobService.class;
        synchronized (FakeJobService.class) {
            dryRunQueryResults.put((Object)projectId, (Object)query, (Object)result);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized JobStatistics dryRunQuery(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized JobConfigurationQuery query, @UnknownKeyFor @NonNull @Initialized String location) {
        Class<FakeJobService> clazz = FakeJobService.class;
        synchronized (FakeJobService.class) {
            JobStatistics result = (JobStatistics)dryRunQueryResults.get((Object)projectId, (Object)query.getQuery());
            if (result != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return result;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Job> getAllJobs() {
        Class<FakeJobService> clazz = FakeJobService.class;
        synchronized (FakeJobService.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return allJobs.values().stream().map(j -> j.job).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized Job getJob(@UnknownKeyFor @NonNull @Initialized JobReference jobRef) {
        try {
            Class<FakeJobService> clazz = FakeJobService.class;
            synchronized (FakeJobService.class) {
                JobInfo job;
                block13: {
                    job = (JobInfo)allJobs.get((Object)jobRef.getProjectId(), (Object)jobRef.getJobId());
                    if (job == null) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return null;
                    }
                    try {
                        ++job.getJobCount;
                        if (!"FAILED".equals(job.job.getStatus().getState())) {
                            if (this.numFailures < this.numFailuresExpected) {
                                ++this.numFailures;
                                throw new Exception("Failure number " + this.numFailures);
                            }
                            if (job.getJobCount == 3) {
                                job.job.getStatus().setState("RUNNING");
                            } else if (job.getJobCount == 5) {
                                job.job.setStatus(this.runJob(job.job));
                            }
                        }
                    }
                    catch (Exception e) {
                        job.job.getStatus().setState("FAILED").setErrorResult(new ErrorProto().setMessage(String.format("Job %s failed: %s", job.job.getConfiguration(), e.toString())));
                        List sourceFiles = (List)filesForLoadJobs.get((Object)jobRef.getProjectId(), (Object)jobRef.getJobId());
                        if (sourceFiles == null) break block13;
                        FileSystems.delete((Collection)sourceFiles, (MoveOptions[])new MoveOptions[0]);
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return (Job)JSON_FACTORY.fromString(JSON_FACTORY.toString((Object)job.job), Job.class);
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    private void verifyUniqueJobId(@UnknownKeyFor @NonNull @Initialized String jobId) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (allJobs.containsColumn((Object)jobId)) {
            throw new IOException("Duplicate job id " + jobId);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized JobStatus runJob(@UnknownKeyFor @NonNull @Initialized Job job) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        if (job.getConfiguration().getLoad() != null) {
            return this.runLoadJob(job.getJobReference(), job.getConfiguration().getLoad());
        }
        if (job.getConfiguration().getCopy() != null) {
            return this.runCopyJob(job.getConfiguration().getCopy());
        }
        if (job.getConfiguration().getExtract() != null) {
            return this.runExtractJob(job, job.getConfiguration().getExtract());
        }
        if (job.getConfiguration().getQuery() != null) {
            return this.runQueryJob(job.getConfiguration().getQuery());
        }
        return new JobStatus().setState("DONE");
    }

    private @UnknownKeyFor @NonNull @Initialized boolean validateDispositions(@UnknownKeyFor @NonNull @Initialized com.google.api.services.bigquery.model.Table table,  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition,  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.WriteDisposition writeDisposition) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        List<TableRow> allRows;
        if (table == null) {
            if (createDisposition == BigQueryIO.Write.CreateDisposition.CREATE_NEVER) {
                return false;
            }
        } else if (writeDisposition == BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE) {
            this.datasetService.deleteTable(table.getTableReference());
        } else if (writeDisposition == BigQueryIO.Write.WriteDisposition.WRITE_EMPTY && !(allRows = this.datasetService.getAllRows(table.getTableReference().getProjectId(), table.getTableReference().getDatasetId(), table.getTableReference().getTableId())).isEmpty()) {
            return false;
        }
        return true;
    }

    private @UnknownKeyFor @NonNull @Initialized JobStatus runLoadJob(@UnknownKeyFor @NonNull @Initialized JobReference jobRef, @UnknownKeyFor @NonNull @Initialized JobConfigurationLoad load) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        TableReference destination = load.getDestinationTable();
        TableSchema schema = load.getSchema();
        List sourceFiles = (List)filesForLoadJobs.get((Object)jobRef.getProjectId(), (Object)jobRef.getJobId());
        BigQueryIO.Write.WriteDisposition writeDisposition = BigQueryIO.Write.WriteDisposition.valueOf(load.getWriteDisposition());
        BigQueryIO.Write.CreateDisposition createDisposition = BigQueryIO.Write.CreateDisposition.valueOf(load.getCreateDisposition());
        com.google.api.services.bigquery.model.Table existingTable = this.datasetService.getTable(destination);
        if (schema == null) {
            schema = existingTable.getSchema();
        }
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"No schema specified");
        if (!this.validateDispositions(existingTable, createDisposition, writeDisposition)) {
            return new JobStatus().setState("FAILED").setErrorResult(new ErrorProto());
        }
        if (existingTable == null) {
            TableReference strippedDestination = destination.clone().setTableId(BigQueryHelpers.stripPartitionDecorator(destination.getTableId()));
            existingTable = new com.google.api.services.bigquery.model.Table().setTableReference(strippedDestination).setSchema(schema);
            if (load.getTimePartitioning() != null) {
                existingTable = existingTable.setTimePartitioning(load.getTimePartitioning());
            }
            if (load.getClustering() != null) {
                existingTable = existingTable.setClustering(load.getClustering());
            }
            this.datasetService.createTable(existingTable);
        }
        ArrayList rows = Lists.newArrayList();
        for (ResourceId filename : sourceFiles) {
            if (load.getSourceFormat().equals("NEWLINE_DELIMITED_JSON")) {
                rows.addAll(this.readJsonTableRows(filename.toString()));
                continue;
            }
            if (!load.getSourceFormat().equals("AVRO")) continue;
            rows.addAll(this.readAvroTableRows(filename.toString(), schema));
        }
        this.datasetService.insertAll(destination, rows, null);
        FileSystems.delete((Collection)sourceFiles, (MoveOptions[])new MoveOptions[0]);
        return new JobStatus().setState("DONE");
    }

    private @UnknownKeyFor @NonNull @Initialized JobStatus runCopyJob(@UnknownKeyFor @NonNull @Initialized JobConfigurationTableCopy copy) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        List sources = copy.getSourceTables();
        TableReference destination = copy.getDestinationTable();
        BigQueryIO.Write.WriteDisposition writeDisposition = BigQueryIO.Write.WriteDisposition.valueOf(copy.getWriteDisposition());
        BigQueryIO.Write.CreateDisposition createDisposition = BigQueryIO.Write.CreateDisposition.valueOf(copy.getCreateDisposition());
        com.google.api.services.bigquery.model.Table existingTable = this.datasetService.getTable(destination);
        if (!this.validateDispositions(existingTable, createDisposition, writeDisposition)) {
            return new JobStatus().setState("FAILED").setErrorResult(new ErrorProto());
        }
        TimePartitioning partitioning = null;
        Clustering clustering = null;
        TableSchema schema = null;
        boolean first = true;
        ArrayList allRows = Lists.newArrayList();
        for (TableReference source : sources) {
            com.google.api.services.bigquery.model.Table table = (com.google.api.services.bigquery.model.Table)Preconditions.checkNotNull((Object)this.datasetService.getTable(source));
            if (!first) {
                if (!Objects.equals(partitioning, table.getTimePartitioning())) {
                    return new JobStatus().setState("FAILED").setErrorResult(new ErrorProto());
                }
                if (!Objects.equals(clustering, table.getClustering())) {
                    return new JobStatus().setState("FAILED").setErrorResult(new ErrorProto());
                }
                if (!Objects.equals(schema, table.getSchema())) {
                    return new JobStatus().setState("FAILED").setErrorResult(new ErrorProto());
                }
            }
            partitioning = table.getTimePartitioning();
            clustering = table.getClustering();
            schema = table.getSchema();
            first = false;
            allRows.addAll(this.datasetService.getAllRows(source.getProjectId(), source.getDatasetId(), source.getTableId()));
        }
        this.datasetService.createTable(new com.google.api.services.bigquery.model.Table().setTableReference(destination).setSchema(schema).setTimePartitioning(partitioning).setClustering(clustering).setEncryptionConfiguration(copy.getDestinationEncryptionConfiguration()));
        this.datasetService.insertAll(destination, allRows, null);
        return new JobStatus().setState("DONE");
    }

    private @UnknownKeyFor @NonNull @Initialized JobStatus runExtractJob(@UnknownKeyFor @NonNull @Initialized Job job, @UnknownKeyFor @NonNull @Initialized JobConfigurationExtract extract) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        TableReference sourceTable = extract.getSourceTable();
        List<TableRow> rows = this.datasetService.getAllRows(sourceTable.getProjectId(), sourceTable.getDatasetId(), sourceTable.getTableId());
        TableSchema schema = this.datasetService.getTable(sourceTable).getSchema();
        ArrayList destinationFileCounts = Lists.newArrayList();
        for (String destination : extract.getDestinationUris()) {
            destinationFileCounts.add(this.writeRows(sourceTable.getTableId(), rows, schema, destination));
        }
        job.setStatistics(new JobStatistics().setExtract(new JobStatistics4().setDestinationUriFileCounts((List)destinationFileCounts)));
        return new JobStatus().setState("DONE");
    }

    private @UnknownKeyFor @NonNull @Initialized JobStatus runQueryJob(@UnknownKeyFor @NonNull @Initialized JobConfigurationQuery query) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        KV<com.google.api.services.bigquery.model.Table, List<TableRow>> result = FakeBigQueryServices.decodeQueryResult(query.getQuery());
        this.datasetService.createTable(((com.google.api.services.bigquery.model.Table)result.getKey()).setTableReference(query.getDestinationTable()));
        this.datasetService.insertAll(query.getDestinationTable(), (List)result.getValue(), null);
        return new JobStatus().setState("DONE");
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> readJsonTableRows(@UnknownKeyFor @NonNull @Initialized String filename) throws @UnknownKeyFor @NonNull @Initialized IOException {
        TableRowJsonCoder coder = TableRowJsonCoder.of();
        ArrayList tableRows = Lists.newArrayList();
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(filename, new String[0]), StandardCharsets.UTF_8);){
            String line;
            while ((line = reader.readLine()) != null) {
                TableRow tableRow = (TableRow)coder.decode(new ByteArrayInputStream(line.getBytes(StandardCharsets.UTF_8)), Coder.Context.OUTER);
                tableRows.add(tableRow);
            }
        }
        return tableRows;
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> readAvroTableRows(@UnknownKeyFor @NonNull @Initialized String filename, @UnknownKeyFor @NonNull @Initialized TableSchema tableSchema) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList tableRows = Lists.newArrayList();
        FileReader dfr = DataFileReader.openReader((File)new File(filename), (DatumReader)new GenericDatumReader());
        while (dfr.hasNext()) {
            GenericRecord record = (GenericRecord)dfr.next(null);
            tableRows.add(BigQueryUtils.convertGenericRecordToTableRow(record, tableSchema));
        }
        return tableRows;
    }

    private @UnknownKeyFor @NonNull @Initialized long writeRows(@UnknownKeyFor @NonNull @Initialized String tableId, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> rows, @UnknownKeyFor @NonNull @Initialized TableSchema schema, @UnknownKeyFor @NonNull @Initialized String destinationPattern) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Schema avroSchema = BigQueryUtils.toGenericAvroSchema(tableId, schema.getFields());
        ArrayList rowsToWrite = Lists.newArrayList();
        int shard = 0;
        for (TableRow row : rows) {
            rowsToWrite.add(row);
            if (rowsToWrite.size() != 5) continue;
            this.writeRowsHelper(rowsToWrite, avroSchema, destinationPattern, shard++);
            rowsToWrite.clear();
        }
        if (!rowsToWrite.isEmpty()) {
            this.writeRowsHelper(rowsToWrite, avroSchema, destinationPattern, shard++);
        }
        return shard;
    }

    private void writeRowsHelper(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> rows, @UnknownKeyFor @NonNull @Initialized Schema avroSchema, @UnknownKeyFor @NonNull @Initialized String destinationPattern, @UnknownKeyFor @NonNull @Initialized int shard) {
        String filename = destinationPattern.replace("*", String.format("%012d", shard));
        try (WritableByteChannel channel = FileSystems.create((ResourceId)FileSystems.matchNewResource((String)filename, (boolean)false), (String)"application/octet-stream");
             DataFileWriter tableRowWriter = new DataFileWriter((DatumWriter)new GenericDatumWriter(avroSchema)).create(avroSchema, Channels.newOutputStream(channel));){
            for (Map map : rows) {
                GenericRecordBuilder genericRecordBuilder = new GenericRecordBuilder(avroSchema);
                for (Map.Entry field : map.entrySet()) {
                    genericRecordBuilder.set((String)field.getKey(), field.getValue());
                }
                tableRowWriter.append((Object)genericRecordBuilder.build());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Could not create destination for extract job %s", filename), e);
        }
    }

    private static class JobInfo {
        @UnknownKeyFor @NonNull @Initialized Job job;
        @UnknownKeyFor @NonNull @Initialized int getJobCount = 0;

        JobInfo(@UnknownKeyFor @NonNull @Initialized Job job) {
            this.job = job;
        }
    }
}

