/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.core.ApiFunction;
import com.google.api.services.bigquery.model.ExportDataStatistics;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.JobStatistics2;
import com.google.api.services.bigquery.model.JobStatistics3;
import com.google.api.services.bigquery.model.JobStatistics4;
import com.google.api.services.bigquery.model.JobStatistics5;
import com.google.api.services.bigquery.model.QueryParameter;
import com.google.api.services.bigquery.model.ScriptStackFrame;
import com.google.auto.value.AutoValue;
import com.google.cloud.StringEnumType;
import com.google.cloud.StringEnumValue;
import com.google.cloud.bigquery.AutoValue_JobStatistics_QueryStatistics_ExportDataStats;
import com.google.cloud.bigquery.BiEngineStats;
import com.google.cloud.bigquery.DmlStats;
import com.google.cloud.bigquery.MetadataCacheStats;
import com.google.cloud.bigquery.QueryStage;
import com.google.cloud.bigquery.RoutineId;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.SearchStats;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TimelineSample;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class JobStatistics
implements Serializable {
    private static final long serialVersionUID = 1433024714741660400L;
    private final Long creationTime;
    private final Long endTime;
    private final Long startTime;
    private final Long numChildJobs;
    private final String parentJobId;
    private final ScriptStatistics scriptStatistics;
    private final List<ReservationUsage> reservationUsage;
    private final TransactionInfo transactionInfo;
    private final SessionInfo sessionInfo;
    private final Long totalSlotMs;

    protected JobStatistics(Builder builder) {
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.startTime = builder.startTime;
        this.numChildJobs = builder.numChildJobs;
        this.parentJobId = builder.parentJobId;
        this.scriptStatistics = builder.scriptStatistics;
        this.reservationUsage = builder.reservationUsage;
        this.transactionInfo = builder.transactionInfo;
        this.sessionInfo = builder.sessionInfo;
        this.totalSlotMs = builder.totalSlotMs;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getNumChildJobs() {
        return this.numChildJobs;
    }

    public String getParentJobId() {
        return this.parentJobId;
    }

    public ScriptStatistics getScriptStatistics() {
        return this.scriptStatistics;
    }

    public List<ReservationUsage> getReservationUsage() {
        return this.reservationUsage;
    }

    public TransactionInfo getTransactionInfo() {
        return this.transactionInfo;
    }

    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public Long getTotalSlotMs() {
        return this.totalSlotMs;
    }

    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("creationTime", (Object)this.creationTime).add("endTime", (Object)this.endTime).add("startTime", (Object)this.startTime).add("numChildJobs", (Object)this.numChildJobs).add("parentJobId", (Object)this.parentJobId).add("scriptStatistics", (Object)this.scriptStatistics).add("reservationUsage", this.reservationUsage).add("transactionInfo", (Object)this.transactionInfo).add("sessionInfo", (Object)this.sessionInfo).add("totalSlotMs", (Object)this.totalSlotMs);
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    final int baseHashCode() {
        return Objects.hash(this.creationTime, this.endTime, this.startTime, this.numChildJobs, this.parentJobId, this.scriptStatistics, this.reservationUsage, this.transactionInfo, this.sessionInfo, this.totalSlotMs);
    }

    final boolean baseEquals(JobStatistics jobStatistics) {
        return Objects.equals(this.toPb(), jobStatistics.toPb());
    }

    com.google.api.services.bigquery.model.JobStatistics toPb() {
        com.google.api.services.bigquery.model.JobStatistics statistics = new com.google.api.services.bigquery.model.JobStatistics();
        statistics.setCreationTime(this.creationTime);
        statistics.setEndTime(this.endTime);
        statistics.setStartTime(this.startTime);
        statistics.setNumChildJobs(this.numChildJobs);
        statistics.setParentJobId(this.parentJobId);
        statistics.setTotalSlotMs(this.totalSlotMs);
        if (this.scriptStatistics != null) {
            statistics.setScriptStatistics(this.scriptStatistics.toPb());
        }
        if (this.reservationUsage != null) {
            statistics.setReservationUsage(Lists.transform(this.reservationUsage, ReservationUsage.TO_PB_FUNCTION));
        }
        if (this.transactionInfo != null) {
            statistics.setTransactionInfo(this.transactionInfo.toPb());
        }
        if (this.sessionInfo != null) {
            statistics.setSessionInfo(this.sessionInfo.toPb());
        }
        return statistics;
    }

    static <T extends JobStatistics> T fromPb(Job jobPb) {
        JobConfiguration jobConfigPb = jobPb.getConfiguration();
        com.google.api.services.bigquery.model.JobStatistics statisticPb = jobPb.getStatistics();
        if (jobConfigPb.getLoad() != null) {
            return (T)LoadStatistics.fromPb(statisticPb);
        }
        if (jobConfigPb.getExtract() != null) {
            return (T)ExtractStatistics.fromPb(statisticPb);
        }
        if (jobConfigPb.getQuery() != null) {
            return (T)QueryStatistics.fromPb(statisticPb);
        }
        if (jobConfigPb.getCopy() != null) {
            return (T)CopyStatistics.fromPb(statisticPb);
        }
        throw new IllegalArgumentException("unknown job configuration: " + jobConfigPb);
    }

    static abstract class Builder<T extends JobStatistics, B extends Builder<T, B>> {
        private Long creationTime;
        private Long endTime;
        private Long startTime;
        private Long numChildJobs;
        private String parentJobId;
        private ScriptStatistics scriptStatistics;
        private List<ReservationUsage> reservationUsage;
        private TransactionInfo transactionInfo;
        private SessionInfo sessionInfo;
        private Long totalSlotMs;

        protected Builder() {
        }

        protected Builder(com.google.api.services.bigquery.model.JobStatistics statisticsPb) {
            this.creationTime = statisticsPb.getCreationTime();
            this.endTime = statisticsPb.getEndTime();
            this.startTime = statisticsPb.getStartTime();
            this.numChildJobs = statisticsPb.getNumChildJobs();
            this.parentJobId = statisticsPb.getParentJobId();
            if (statisticsPb.getTotalSlotMs() != null) {
                this.totalSlotMs = statisticsPb.getTotalSlotMs();
            }
            if (statisticsPb.getScriptStatistics() != null) {
                this.scriptStatistics = ScriptStatistics.fromPb(statisticsPb.getScriptStatistics());
            }
            if (this.reservationUsage != null) {
                this.reservationUsage = Lists.transform((List)statisticsPb.getReservationUsage(), ReservationUsage.FROM_PB_FUNCTION);
            }
            if (statisticsPb.getTransactionInfo() != null) {
                this.transactionInfo = TransactionInfo.fromPb(statisticsPb.getTransactionInfo());
            }
            if (statisticsPb.getSessionInfo() != null) {
                this.sessionInfo = SessionInfo.fromPb(statisticsPb.getSessionInfo());
            }
        }

        protected B self() {
            return (B)this;
        }

        B setCreationTimestamp(Long creationTime) {
            this.creationTime = creationTime;
            return this.self();
        }

        B setEndTime(Long endTime) {
            this.endTime = endTime;
            return this.self();
        }

        B setStartTime(Long startTime) {
            this.startTime = startTime;
            return this.self();
        }

        B setTotalSlotMs(Long totalSlotMs) {
            this.totalSlotMs = totalSlotMs;
            return this.self();
        }

        abstract T build();
    }

    public static class ScriptStatistics {
        private static final long serialVersionUID = 1328768324537448161L;
        private final String evaluationKind;
        private final List<ScriptStackFrame> stackFrames;

        private ScriptStatistics(Builder builder) {
            this.evaluationKind = builder.evaluationKind;
            this.stackFrames = builder.stackFrames;
        }

        static Builder newBuilder() {
            return new Builder();
        }

        public String getEvaluationKind() {
            return this.evaluationKind;
        }

        public List<ScriptStackFrame> getStackFrames() {
            return this.stackFrames;
        }

        MoreObjects.ToStringHelper toStringHelper() {
            return MoreObjects.toStringHelper((Object)this).add("evaluationKind", (Object)this.evaluationKind).add("stackFrames", this.stackFrames);
        }

        public String toString() {
            return this.toStringHelper().toString();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(ScriptStatistics.class) && Objects.equals(this.toPb(), ((ScriptStatistics)obj).toPb());
        }

        public int hashCode() {
            return Objects.hash(this.evaluationKind, this.stackFrames);
        }

        com.google.api.services.bigquery.model.ScriptStatistics toPb() {
            com.google.api.services.bigquery.model.ScriptStatistics scriptStatistics = new com.google.api.services.bigquery.model.ScriptStatistics();
            scriptStatistics.setEvaluationKind(this.evaluationKind);
            scriptStatistics.setStackFrames(Lists.transform(this.stackFrames, ScriptStackFrame.TO_PB_FUNCTION));
            return scriptStatistics;
        }

        static ScriptStatistics fromPb(com.google.api.services.bigquery.model.ScriptStatistics scriptStatistics) {
            Builder builder = ScriptStatistics.newBuilder();
            if (scriptStatistics.getEvaluationKind() != null) {
                builder.setEvaluationKind(scriptStatistics.getEvaluationKind());
            }
            if (scriptStatistics.getStackFrames() != null) {
                builder.setStackFrames(Lists.transform((List)scriptStatistics.getStackFrames(), ScriptStackFrame.FROM_PB_FUNCTION));
            }
            return builder.build();
        }

        static class Builder {
            private String evaluationKind;
            private List<ScriptStackFrame> stackFrames;

            private Builder() {
            }

            Builder setEvaluationKind(String evaluationKind) {
                this.evaluationKind = evaluationKind;
                return this;
            }

            Builder setStackFrames(List<ScriptStackFrame> stackFrames) {
                this.stackFrames = stackFrames;
                return this;
            }

            ScriptStatistics build() {
                return new ScriptStatistics(this);
            }
        }

        public static class ScriptStackFrame {
            static final Function<com.google.api.services.bigquery.model.ScriptStackFrame, ScriptStackFrame> FROM_PB_FUNCTION = new Function<com.google.api.services.bigquery.model.ScriptStackFrame, ScriptStackFrame>(){

                @NullableDecl
                public ScriptStackFrame apply(@NullableDecl com.google.api.services.bigquery.model.ScriptStackFrame stackFrame) {
                    return ScriptStackFrame.fromPb(stackFrame);
                }
            };
            static final Function<ScriptStackFrame, com.google.api.services.bigquery.model.ScriptStackFrame> TO_PB_FUNCTION = new Function<ScriptStackFrame, com.google.api.services.bigquery.model.ScriptStackFrame>(){

                @NullableDecl
                public com.google.api.services.bigquery.model.ScriptStackFrame apply(@NullableDecl ScriptStackFrame scriptStackFrame) {
                    return scriptStackFrame.toPb();
                }
            };
            private final Integer endColumn;
            private final Integer endLine;
            private final String procedureId;
            private final Integer startColumn;
            private final Integer startLine;
            private final String text;

            private ScriptStackFrame(Builder builder) {
                this.endColumn = builder.endColumn;
                this.endLine = builder.endLine;
                this.procedureId = builder.procedureId;
                this.startColumn = builder.startColumn;
                this.startLine = builder.startLine;
                this.text = builder.text;
            }

            public Integer getEndColumn() {
                return this.endColumn;
            }

            public Integer getEndLine() {
                return this.endLine;
            }

            public String getProcedureId() {
                return this.procedureId;
            }

            public Integer getStartColumn() {
                return this.startColumn;
            }

            public Integer getStartLine() {
                return this.startLine;
            }

            public String getText() {
                return this.text;
            }

            MoreObjects.ToStringHelper toStringHelper() {
                return MoreObjects.toStringHelper((Object)this).add("endColumn", (Object)this.endColumn).add("endLine", (Object)this.endLine).add("procedureId", (Object)this.procedureId).add("startColumn", (Object)this.startColumn).add("startLine", (Object)this.startLine).add("text", (Object)this.text);
            }

            public String toString() {
                return this.toStringHelper().toString();
            }

            public boolean equals(Object obj) {
                return obj == this || obj != null && obj.getClass().equals(ScriptStackFrame.class) && Objects.equals(this.toPb(), ((ScriptStackFrame)obj).toPb());
            }

            public int hashCode() {
                return Objects.hash(this.endColumn, this.endLine, this.procedureId, this.startColumn, this.startLine, this.text);
            }

            com.google.api.services.bigquery.model.ScriptStackFrame toPb() {
                com.google.api.services.bigquery.model.ScriptStackFrame stackFrame = new com.google.api.services.bigquery.model.ScriptStackFrame();
                stackFrame.setEndColumn(this.endColumn);
                stackFrame.setEndLine(this.endLine);
                stackFrame.setProcedureId(this.procedureId);
                stackFrame.setStartColumn(this.startColumn);
                stackFrame.setStartLine(this.startLine);
                stackFrame.setText(this.text);
                return stackFrame;
            }

            static Builder newBuilder() {
                return new Builder();
            }

            static ScriptStackFrame fromPb(com.google.api.services.bigquery.model.ScriptStackFrame stackFrame) {
                Builder builder = ScriptStackFrame.newBuilder();
                if (stackFrame.getEndColumn() != null) {
                    builder.setEndColumn(stackFrame.getEndColumn());
                }
                if (stackFrame.getEndLine() != null) {
                    builder.setEndLine(stackFrame.getEndLine());
                }
                if (stackFrame.getProcedureId() != null) {
                    builder.setProcedureId(stackFrame.getProcedureId());
                }
                if (stackFrame.getStartColumn() != null) {
                    builder.setStartColumn(stackFrame.getStartColumn());
                }
                if (stackFrame.getStartLine() != null) {
                    builder.setStartLine(stackFrame.getStartLine());
                }
                if (stackFrame.getText() != null) {
                    builder.setText(stackFrame.getText());
                }
                return builder.build();
            }

            static class Builder {
                private Integer endColumn;
                private Integer endLine;
                private String procedureId;
                private Integer startColumn;
                private Integer startLine;
                private String text;

                Builder() {
                }

                Builder setEndColumn(Integer endColumn) {
                    this.endColumn = endColumn;
                    return this;
                }

                Builder setEndLine(Integer endLine) {
                    this.endLine = endLine;
                    return this;
                }

                Builder setProcedureId(String procedureId) {
                    this.procedureId = procedureId;
                    return this;
                }

                Builder setStartColumn(Integer startColumn) {
                    this.startColumn = startColumn;
                    return this;
                }

                Builder setStartLine(Integer startLine) {
                    this.startLine = startLine;
                    return this;
                }

                Builder setText(String text) {
                    this.text = text;
                    return this;
                }

                ScriptStackFrame build() {
                    return new ScriptStackFrame(this);
                }
            }
        }
    }

    public static class TransactionInfo {
        private final String transactionId;

        private TransactionInfo(Builder builder) {
            this.transactionId = builder.transactionId;
        }

        public String getTransactionId() {
            return this.transactionId;
        }

        static Builder newbuilder() {
            return new Builder();
        }

        MoreObjects.ToStringHelper toStringHelper() {
            return MoreObjects.toStringHelper((Object)this).add("transactionId", (Object)this.transactionId);
        }

        public String toString() {
            return this.toStringHelper().toString();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(TransactionInfo.class) && Objects.equals(this.toPb(), ((TransactionInfo)obj).toPb());
        }

        public int hashCode() {
            return Objects.hash(this.transactionId);
        }

        com.google.api.services.bigquery.model.TransactionInfo toPb() {
            com.google.api.services.bigquery.model.TransactionInfo transactionInfo = new com.google.api.services.bigquery.model.TransactionInfo();
            transactionInfo.setTransactionId(this.transactionId);
            return transactionInfo;
        }

        static TransactionInfo fromPb(com.google.api.services.bigquery.model.TransactionInfo transactionInfo) {
            Builder builder = TransactionInfo.newbuilder();
            builder.setTransactionId(transactionInfo.getTransactionId());
            return builder.build();
        }

        public static class Builder {
            private String transactionId;

            private Builder() {
            }

            Builder setTransactionId(String transactionId) {
                this.transactionId = transactionId;
                return this;
            }

            TransactionInfo build() {
                return new TransactionInfo(this);
            }
        }
    }

    public static class SessionInfo {
        private final String sessionId;

        private SessionInfo(Builder builder) {
            this.sessionId = builder.sessionId;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        static Builder newBuilder() {
            return new Builder();
        }

        MoreObjects.ToStringHelper toStringHelper() {
            return MoreObjects.toStringHelper((Object)this).add("sessionId", (Object)this.sessionId);
        }

        public String toString() {
            return this.toStringHelper().toString();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(SessionInfo.class) && Objects.equals(this.toPb(), ((SessionInfo)obj).toPb());
        }

        public int hashCode() {
            return Objects.hash(this.sessionId);
        }

        com.google.api.services.bigquery.model.SessionInfo toPb() {
            com.google.api.services.bigquery.model.SessionInfo sessionInfo = new com.google.api.services.bigquery.model.SessionInfo();
            sessionInfo.setSessionId(this.sessionId);
            return sessionInfo;
        }

        static SessionInfo fromPb(com.google.api.services.bigquery.model.SessionInfo sessionInfo) {
            Builder builder = SessionInfo.newBuilder();
            builder.setSessionId(sessionInfo.getSessionId());
            return builder.build();
        }

        public static class Builder {
            private String sessionId;

            private Builder() {
            }

            Builder setSessionId(String sessionId) {
                this.sessionId = sessionId;
                return this;
            }

            SessionInfo build() {
                return new SessionInfo(this);
            }
        }
    }

    public static class ReservationUsage {
        static final Function<JobStatistics.ReservationUsage, ReservationUsage> FROM_PB_FUNCTION = new Function<JobStatistics.ReservationUsage, ReservationUsage>(){

            public ReservationUsage apply(JobStatistics.ReservationUsage usage) {
                return ReservationUsage.fromPb(usage);
            }
        };
        static final Function<ReservationUsage, JobStatistics.ReservationUsage> TO_PB_FUNCTION = new Function<ReservationUsage, JobStatistics.ReservationUsage>(){

            public JobStatistics.ReservationUsage apply(ReservationUsage usage) {
                return usage.toPb();
            }
        };
        private final String name;
        private final Long slotMs;

        private ReservationUsage(Builder builder) {
            this.name = builder.name;
            this.slotMs = builder.slotMs;
        }

        public String getName() {
            return this.name;
        }

        public Long getSlotMs() {
            return this.slotMs;
        }

        static Builder newBuilder() {
            return new Builder();
        }

        MoreObjects.ToStringHelper toStringHelper() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("slotMs", (Object)this.slotMs);
        }

        public String toString() {
            return this.toStringHelper().toString();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(ReservationUsage.class) && Objects.equals(this.toPb(), ((ReservationUsage)obj).toPb());
        }

        public int hashCode() {
            return Objects.hash(this.name, this.slotMs);
        }

        JobStatistics.ReservationUsage toPb() {
            JobStatistics.ReservationUsage usage = new JobStatistics.ReservationUsage();
            usage.setName(this.name);
            usage.setSlotMs(this.slotMs);
            return usage;
        }

        static ReservationUsage fromPb(JobStatistics.ReservationUsage usage) {
            Builder builder = ReservationUsage.newBuilder();
            builder.setName(usage.getName());
            builder.setSlotMs(usage.getSlotMs());
            return builder.build();
        }

        public static class Builder {
            private String name;
            private Long slotMs;

            private Builder() {
            }

            Builder setName(String name) {
                this.name = name;
                return this;
            }

            Builder setSlotMs(Long slotMs) {
                this.slotMs = slotMs;
                return this;
            }

            ReservationUsage build() {
                return new ReservationUsage(this);
            }
        }
    }

    public static class LoadStatistics
    extends JobStatistics {
        private static final long serialVersionUID = -707369246536309215L;
        private final Long inputBytes;
        private final Long inputFiles;
        private final Long outputBytes;
        private final Long outputRows;
        private final Long badRecords;

        private LoadStatistics(Builder builder) {
            super(builder);
            this.inputBytes = builder.inputBytes;
            this.inputFiles = builder.inputFiles;
            this.outputBytes = builder.outputBytes;
            this.outputRows = builder.outputRows;
            this.badRecords = builder.badRecords;
        }

        public Long getInputBytes() {
            return this.inputBytes;
        }

        public Long getInputFiles() {
            return this.inputFiles;
        }

        public Long getOutputBytes() {
            return this.outputBytes;
        }

        public Long getOutputRows() {
            return this.outputRows;
        }

        public Long getBadRecords() {
            return this.badRecords;
        }

        @Override
        MoreObjects.ToStringHelper toStringHelper() {
            return super.toStringHelper().add("inputBytes", (Object)this.inputBytes).add("inputFiles", (Object)this.inputFiles).add("outputBytes", (Object)this.outputBytes).add("outputRows", (Object)this.outputRows).add("badRecords", (Object)this.badRecords);
        }

        public final boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(LoadStatistics.class) && this.baseEquals((LoadStatistics)obj);
        }

        public final int hashCode() {
            return Objects.hash(this.baseHashCode(), this.inputBytes, this.inputFiles, this.outputBytes, this.outputRows, this.badRecords);
        }

        @Override
        com.google.api.services.bigquery.model.JobStatistics toPb() {
            JobStatistics3 loadStatisticsPb = new JobStatistics3();
            loadStatisticsPb.setInputFileBytes(this.inputBytes);
            loadStatisticsPb.setInputFiles(this.inputFiles);
            loadStatisticsPb.setOutputBytes(this.outputBytes);
            loadStatisticsPb.setOutputRows(this.outputRows);
            loadStatisticsPb.setBadRecords(this.badRecords);
            return super.toPb().setLoad(loadStatisticsPb);
        }

        static Builder newBuilder() {
            return new Builder();
        }

        static LoadStatistics fromPb(com.google.api.services.bigquery.model.JobStatistics statisticPb) {
            return new Builder(statisticPb).build();
        }

        static final class Builder
        extends com.google.cloud.bigquery.JobStatistics$Builder<LoadStatistics, Builder> {
            private Long inputBytes;
            private Long inputFiles;
            private Long outputBytes;
            private Long outputRows;
            private Long badRecords;

            private Builder() {
            }

            private Builder(com.google.api.services.bigquery.model.JobStatistics statisticsPb) {
                super(statisticsPb);
                if (statisticsPb.getLoad() != null) {
                    this.inputBytes = statisticsPb.getLoad().getInputFileBytes();
                    this.inputFiles = statisticsPb.getLoad().getInputFiles();
                    this.outputBytes = statisticsPb.getLoad().getOutputBytes();
                    this.outputRows = statisticsPb.getLoad().getOutputRows();
                    this.badRecords = statisticsPb.getLoad().getBadRecords();
                }
            }

            Builder setInputBytes(Long inputBytes) {
                this.inputBytes = inputBytes;
                return (Builder)this.self();
            }

            Builder setInputFiles(Long inputFiles) {
                this.inputFiles = inputFiles;
                return (Builder)this.self();
            }

            Builder setOutputBytes(Long outputBytes) {
                this.outputBytes = outputBytes;
                return (Builder)this.self();
            }

            Builder setOutputRows(Long outputRows) {
                this.outputRows = outputRows;
                return (Builder)this.self();
            }

            Builder setBadRecords(Long badRecords) {
                this.badRecords = badRecords;
                return (Builder)this.self();
            }

            @Override
            LoadStatistics build() {
                return new LoadStatistics(this);
            }
        }
    }

    public static class ExtractStatistics
    extends JobStatistics {
        private static final long serialVersionUID = -1566598819212767373L;
        private final List<Long> destinationUriFileCounts;
        private final Long inputBytes;

        private ExtractStatistics(Builder builder) {
            super(builder);
            this.destinationUriFileCounts = builder.destinationUriFileCounts;
            this.inputBytes = builder.inputBytes;
        }

        public List<Long> getDestinationUriFileCounts() {
            return this.destinationUriFileCounts;
        }

        public Long getInputBytes() {
            return this.inputBytes;
        }

        @Override
        MoreObjects.ToStringHelper toStringHelper() {
            return super.toStringHelper().add("destinationUriFileCounts", this.destinationUriFileCounts);
        }

        public final boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(ExtractStatistics.class) && this.baseEquals((ExtractStatistics)obj);
        }

        public final int hashCode() {
            return Objects.hash(this.baseHashCode(), this.destinationUriFileCounts);
        }

        @Override
        com.google.api.services.bigquery.model.JobStatistics toPb() {
            JobStatistics4 extractStatisticsPb = new JobStatistics4();
            extractStatisticsPb.setDestinationUriFileCounts(this.destinationUriFileCounts);
            extractStatisticsPb.setInputBytes(this.inputBytes);
            return super.toPb().setExtract(extractStatisticsPb);
        }

        static Builder newBuilder() {
            return new Builder();
        }

        static ExtractStatistics fromPb(com.google.api.services.bigquery.model.JobStatistics statisticPb) {
            return new Builder(statisticPb).build();
        }

        static final class Builder
        extends com.google.cloud.bigquery.JobStatistics$Builder<ExtractStatistics, Builder> {
            private List<Long> destinationUriFileCounts;
            private Long inputBytes;

            private Builder() {
            }

            private Builder(com.google.api.services.bigquery.model.JobStatistics statisticsPb) {
                super(statisticsPb);
                if (statisticsPb.getExtract() != null) {
                    this.destinationUriFileCounts = statisticsPb.getExtract().getDestinationUriFileCounts();
                    this.inputBytes = statisticsPb.getExtract().getInputBytes();
                }
            }

            Builder setDestinationUriFileCounts(List<Long> destinationUriFileCounts) {
                this.destinationUriFileCounts = destinationUriFileCounts;
                return (Builder)this.self();
            }

            Builder setInputBytes(Long inputBytes) {
                this.inputBytes = inputBytes;
                return (Builder)this.self();
            }

            @Override
            ExtractStatistics build() {
                return new ExtractStatistics(this);
            }
        }
    }

    public static class QueryStatistics
    extends JobStatistics {
        private static final long serialVersionUID = 7539354109226732354L;
        private final BiEngineStats biEngineStats;
        private final Integer billingTier;
        private final Boolean cacheHit;
        private final String ddlOperationPerformed;
        private final TableId ddlTargetTable;
        private final RoutineId ddlTargetRoutine;
        private final Long estimatedBytesProcessed;
        private final Long numDmlAffectedRows;
        private final DmlStats dmlStats;
        private final ExportDataStats exportDataStats;
        private final List<TableId> referencedTables;
        private final StatementType statementType;
        private final Long totalBytesBilled;
        private final Long totalBytesProcessed;
        private final Long totalPartitionsProcessed;
        private final List<QueryStage> queryPlan;
        private final List<TimelineSample> timeline;
        private final Schema schema;
        private final SearchStats searchStats;
        private final MetadataCacheStats metadataCacheStats;
        private final List<QueryParameter> queryParameters;

        private QueryStatistics(Builder builder) {
            super(builder);
            this.biEngineStats = builder.biEngineStats;
            this.billingTier = builder.billingTier;
            this.cacheHit = builder.cacheHit;
            this.ddlOperationPerformed = builder.ddlOperationPerformed;
            this.ddlTargetTable = builder.ddlTargetTable;
            this.ddlTargetRoutine = builder.ddlTargetRoutine;
            this.estimatedBytesProcessed = builder.estimatedBytesProcessed;
            this.numDmlAffectedRows = builder.numDmlAffectedRows;
            this.dmlStats = builder.dmlStats;
            this.exportDataStats = builder.exportDataStats;
            this.referencedTables = builder.referencedTables;
            this.statementType = builder.statementType;
            this.totalBytesBilled = builder.totalBytesBilled;
            this.totalBytesProcessed = builder.totalBytesProcessed;
            this.totalPartitionsProcessed = builder.totalPartitionsProcessed;
            this.queryPlan = builder.queryPlan;
            this.timeline = builder.timeline;
            this.schema = builder.schema;
            this.searchStats = builder.searchStats;
            this.metadataCacheStats = builder.metadataCacheStats;
            this.queryParameters = builder.queryParameters;
        }

        public BiEngineStats getBiEngineStats() {
            return this.biEngineStats;
        }

        public Integer getBillingTier() {
            return this.billingTier;
        }

        public Boolean getCacheHit() {
            return this.cacheHit;
        }

        public String getDdlOperationPerformed() {
            return this.ddlOperationPerformed;
        }

        public TableId getDdlTargetTable() {
            return this.ddlTargetTable;
        }

        public RoutineId getDdlTargetRoutine() {
            return this.ddlTargetRoutine;
        }

        public Long getEstimatedBytesProcessed() {
            return this.estimatedBytesProcessed;
        }

        public Long getNumDmlAffectedRows() {
            return this.numDmlAffectedRows;
        }

        public DmlStats getDmlStats() {
            return this.dmlStats;
        }

        public ExportDataStats getExportDataStats() {
            return this.exportDataStats;
        }

        public List<TableId> getReferencedTables() {
            return this.referencedTables;
        }

        public StatementType getStatementType() {
            return this.statementType;
        }

        public Long getTotalBytesBilled() {
            return this.totalBytesBilled;
        }

        public Long getTotalBytesProcessed() {
            return this.totalBytesProcessed;
        }

        public Long getTotalPartitionsProcessed() {
            return this.totalPartitionsProcessed;
        }

        public List<QueryStage> getQueryPlan() {
            return this.queryPlan;
        }

        public List<TimelineSample> getTimeline() {
            return this.timeline;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public SearchStats getSearchStats() {
            return this.searchStats;
        }

        public MetadataCacheStats getMetadataCacheStats() {
            return this.metadataCacheStats;
        }

        public List<QueryParameter> getQueryParameters() {
            return this.queryParameters;
        }

        @Override
        MoreObjects.ToStringHelper toStringHelper() {
            return super.toStringHelper().add("biEngineStats", (Object)this.biEngineStats).add("billingTier", (Object)this.billingTier).add("cacheHit", (Object)this.cacheHit).add("totalBytesBilled", (Object)this.totalBytesBilled).add("totalBytesProcessed", (Object)this.totalBytesProcessed).add("queryPlan", this.queryPlan).add("timeline", this.timeline).add("schema", (Object)this.schema).add("searchStats", (Object)this.searchStats).add("metadataCacheStats", (Object)this.metadataCacheStats).add("queryParameters", this.queryParameters);
        }

        public final boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(QueryStatistics.class) && this.baseEquals((QueryStatistics)obj);
        }

        public final int hashCode() {
            return Objects.hash(this.baseHashCode(), this.biEngineStats, this.billingTier, this.cacheHit, this.totalBytesBilled, this.totalBytesProcessed, this.queryPlan, this.schema, this.searchStats, this.metadataCacheStats, this.queryParameters);
        }

        @Override
        com.google.api.services.bigquery.model.JobStatistics toPb() {
            JobStatistics2 queryStatisticsPb = new JobStatistics2();
            if (this.biEngineStats != null) {
                queryStatisticsPb.setBiEngineStatistics(this.biEngineStats.toPb());
            }
            queryStatisticsPb.setBillingTier(this.billingTier);
            queryStatisticsPb.setCacheHit(this.cacheHit);
            queryStatisticsPb.setDdlOperationPerformed(this.ddlOperationPerformed);
            queryStatisticsPb.setEstimatedBytesProcessed(this.estimatedBytesProcessed);
            queryStatisticsPb.setTotalBytesBilled(this.totalBytesBilled);
            queryStatisticsPb.setTotalBytesProcessed(this.totalBytesProcessed);
            queryStatisticsPb.setTotalPartitionsProcessed(this.totalPartitionsProcessed);
            if (this.ddlTargetTable != null) {
                queryStatisticsPb.setDdlTargetTable(this.ddlTargetTable.toPb());
            }
            if (this.ddlTargetRoutine != null) {
                queryStatisticsPb.setDdlTargetRoutine(this.ddlTargetRoutine.toPb());
            }
            if (this.dmlStats != null) {
                queryStatisticsPb.setDmlStats(this.dmlStats.toPb());
            }
            if (this.exportDataStats != null) {
                queryStatisticsPb.setExportDataStatistics(this.exportDataStats.toPb());
            }
            if (this.referencedTables != null) {
                queryStatisticsPb.setReferencedTables(Lists.transform(this.referencedTables, TableId.TO_PB_FUNCTION));
            }
            if (this.statementType != null) {
                queryStatisticsPb.setStatementType(this.statementType.toString());
            }
            if (this.queryPlan != null) {
                queryStatisticsPb.setQueryPlan(Lists.transform(this.queryPlan, QueryStage.TO_PB_FUNCTION));
            }
            if (this.timeline != null) {
                queryStatisticsPb.setTimeline(Lists.transform(this.timeline, TimelineSample.TO_PB_FUNCTION));
            }
            if (this.schema != null) {
                queryStatisticsPb.setSchema(this.schema.toPb());
            }
            if (this.searchStats != null) {
                queryStatisticsPb.setSearchStatistics(this.searchStats.toPb());
            }
            if (this.metadataCacheStats != null) {
                queryStatisticsPb.setMetadataCacheStatistics(this.metadataCacheStats.toPb());
            }
            if (this.queryParameters != null) {
                queryStatisticsPb.setUndeclaredQueryParameters(this.queryParameters);
            }
            return super.toPb().setQuery(queryStatisticsPb);
        }

        static Builder newBuilder() {
            return new Builder();
        }

        static QueryStatistics fromPb(com.google.api.services.bigquery.model.JobStatistics statisticPb) {
            return new Builder(statisticPb).build();
        }

        static final class Builder
        extends com.google.cloud.bigquery.JobStatistics$Builder<QueryStatistics, Builder> {
            private BiEngineStats biEngineStats;
            private Integer billingTier;
            private Boolean cacheHit;
            private String ddlOperationPerformed;
            private TableId ddlTargetTable;
            private RoutineId ddlTargetRoutine;
            private Long estimatedBytesProcessed;
            private Long numDmlAffectedRows;
            private DmlStats dmlStats;
            private ExportDataStats exportDataStats;
            private List<TableId> referencedTables;
            private StatementType statementType;
            private Long totalBytesBilled;
            private Long totalBytesProcessed;
            private Long totalPartitionsProcessed;
            private List<QueryStage> queryPlan;
            private List<TimelineSample> timeline;
            private Schema schema;
            private List<QueryParameter> queryParameters;
            private SearchStats searchStats;
            private MetadataCacheStats metadataCacheStats;

            private Builder() {
            }

            private Builder(com.google.api.services.bigquery.model.JobStatistics statisticsPb) {
                super(statisticsPb);
                if (statisticsPb.getQuery() != null) {
                    if (statisticsPb.getQuery().getBiEngineStatistics() != null) {
                        this.biEngineStats = BiEngineStats.fromPb(statisticsPb.getQuery().getBiEngineStatistics());
                    }
                    this.billingTier = statisticsPb.getQuery().getBillingTier();
                    this.cacheHit = statisticsPb.getQuery().getCacheHit();
                    this.ddlOperationPerformed = statisticsPb.getQuery().getDdlOperationPerformed();
                    if (statisticsPb.getQuery().getDdlTargetTable() != null) {
                        this.ddlTargetTable = TableId.fromPb(statisticsPb.getQuery().getDdlTargetTable());
                    }
                    if (statisticsPb.getQuery().getDdlTargetRoutine() != null) {
                        this.ddlTargetRoutine = RoutineId.fromPb(statisticsPb.getQuery().getDdlTargetRoutine());
                    }
                    this.estimatedBytesProcessed = statisticsPb.getQuery().getEstimatedBytesProcessed();
                    this.numDmlAffectedRows = statisticsPb.getQuery().getNumDmlAffectedRows();
                    this.totalBytesBilled = statisticsPb.getQuery().getTotalBytesBilled();
                    this.totalBytesProcessed = statisticsPb.getQuery().getTotalBytesProcessed();
                    this.totalPartitionsProcessed = statisticsPb.getQuery().getTotalPartitionsProcessed();
                    if (statisticsPb.getQuery().getStatementType() != null) {
                        this.statementType = StatementType.valueOf(statisticsPb.getQuery().getStatementType());
                    }
                    if (statisticsPb.getQuery().getReferencedTables() != null) {
                        this.referencedTables = Lists.transform((List)statisticsPb.getQuery().getReferencedTables(), TableId.FROM_PB_FUNCTION);
                    }
                    if (statisticsPb.getQuery().getQueryPlan() != null) {
                        this.queryPlan = Lists.transform((List)statisticsPb.getQuery().getQueryPlan(), QueryStage.FROM_PB_FUNCTION);
                    }
                    if (statisticsPb.getQuery().getTimeline() != null) {
                        this.timeline = Lists.transform((List)statisticsPb.getQuery().getTimeline(), TimelineSample.FROM_PB_FUNCTION);
                    }
                    if (statisticsPb.getQuery().getSchema() != null) {
                        this.schema = Schema.fromPb(statisticsPb.getQuery().getSchema());
                    }
                    if (statisticsPb.getQuery().getSearchStatistics() != null) {
                        this.searchStats = SearchStats.fromPb(statisticsPb.getQuery().getSearchStatistics());
                    }
                    if (statisticsPb.getQuery().getMetadataCacheStatistics() != null) {
                        this.metadataCacheStats = MetadataCacheStats.fromPb(statisticsPb.getQuery().getMetadataCacheStatistics());
                    }
                    if (statisticsPb.getQuery().getDmlStats() != null) {
                        this.dmlStats = DmlStats.fromPb(statisticsPb.getQuery().getDmlStats());
                    }
                    if (statisticsPb.getQuery().getExportDataStatistics() != null) {
                        this.exportDataStats = ExportDataStats.fromPb(statisticsPb.getQuery().getExportDataStatistics());
                    }
                }
            }

            Builder setBiEngineStats(BiEngineStats biEngineStats) {
                this.biEngineStats = biEngineStats;
                return (Builder)this.self();
            }

            Builder setBillingTier(Integer billingTier) {
                this.billingTier = billingTier;
                return (Builder)this.self();
            }

            Builder setCacheHit(Boolean cacheHit) {
                this.cacheHit = cacheHit;
                return (Builder)this.self();
            }

            Builder setDDLOperationPerformed(String ddlOperationPerformed) {
                this.ddlOperationPerformed = ddlOperationPerformed;
                return (Builder)this.self();
            }

            Builder setDDLTargetTable(TableId ddlTargetTable) {
                this.ddlTargetTable = ddlTargetTable;
                return (Builder)this.self();
            }

            Builder setDDLTargetRoutine(RoutineId ddlTargetRoutine) {
                this.ddlTargetRoutine = ddlTargetRoutine;
                return (Builder)this.self();
            }

            Builder setEstimatedBytesProcessed(Long estimatedBytesProcessed) {
                this.estimatedBytesProcessed = estimatedBytesProcessed;
                return (Builder)this.self();
            }

            Builder setNumDmlAffectedRows(Long numDmlAffectedRows) {
                this.numDmlAffectedRows = numDmlAffectedRows;
                return (Builder)this.self();
            }

            Builder setDmlStats(DmlStats dmlStats) {
                this.dmlStats = dmlStats;
                return (Builder)this.self();
            }

            Builder setExportDataStats(ExportDataStats exportDataStats) {
                this.exportDataStats = exportDataStats;
                return (Builder)this.self();
            }

            Builder setReferenceTables(List<TableId> referencedTables) {
                this.referencedTables = referencedTables;
                return (Builder)this.self();
            }

            Builder setStatementType(StatementType statementType) {
                this.statementType = statementType;
                return (Builder)this.self();
            }

            Builder setStatementType(String strStatementType) {
                this.statementType = StatementType.valueOf(strStatementType);
                return (Builder)this.self();
            }

            Builder setTotalBytesBilled(Long totalBytesBilled) {
                this.totalBytesBilled = totalBytesBilled;
                return (Builder)this.self();
            }

            Builder setTotalBytesProcessed(Long totalBytesProcessed) {
                this.totalBytesProcessed = totalBytesProcessed;
                return (Builder)this.self();
            }

            Builder setTotalPartitionsProcessed(Long totalPartitionsProcessed) {
                this.totalPartitionsProcessed = totalPartitionsProcessed;
                return (Builder)this.self();
            }

            Builder setQueryPlan(List<QueryStage> queryPlan) {
                this.queryPlan = queryPlan;
                return (Builder)this.self();
            }

            Builder setTimeline(List<TimelineSample> timeline) {
                this.timeline = timeline;
                return (Builder)this.self();
            }

            Builder setSchema(Schema schema) {
                this.schema = schema;
                return (Builder)this.self();
            }

            Builder setSearchStats(SearchStats searchStats) {
                this.searchStats = searchStats;
                return (Builder)this.self();
            }

            Builder setMetadataCacheStats(MetadataCacheStats metadataCacheStats) {
                this.metadataCacheStats = metadataCacheStats;
                return (Builder)this.self();
            }

            Builder setQueryParameters(List<QueryParameter> queryParameters) {
                this.queryParameters = queryParameters;
                return (Builder)this.self();
            }

            @Override
            QueryStatistics build() {
                return new QueryStatistics(this);
            }
        }

        @AutoValue
        public static abstract class ExportDataStats
        implements Serializable {
            private static final long serialVersionUID = 1L;

            @Nullable
            public abstract Long getFileCount();

            @Nullable
            public abstract Long getRowCount();

            public abstract Builder toBuilder();

            public static Builder newBuilder() {
                return new AutoValue_JobStatistics_QueryStatistics_ExportDataStats.Builder();
            }

            static ExportDataStats fromPb(ExportDataStatistics exportDataStatisticsPb) {
                Builder builder = ExportDataStats.newBuilder();
                if (exportDataStatisticsPb.getFileCount() != null) {
                    builder.setFileCount(exportDataStatisticsPb.getFileCount());
                }
                if (exportDataStatisticsPb.getRowCount() != null) {
                    builder.setRowCount(exportDataStatisticsPb.getRowCount());
                }
                return builder.build();
            }

            ExportDataStatistics toPb() {
                ExportDataStatistics exportDataStatisticsPb = new ExportDataStatistics();
                if (this.getFileCount() != null) {
                    exportDataStatisticsPb.setFileCount(this.getFileCount());
                }
                if (this.getRowCount() != null) {
                    exportDataStatisticsPb.setRowCount(this.getRowCount());
                }
                return exportDataStatisticsPb;
            }

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract Builder setFileCount(Long var1);

                public abstract Builder setRowCount(Long var1);

                public abstract ExportDataStats build();
            }
        }

        public static final class StatementType
        extends StringEnumValue {
            private static final long serialVersionUID = 818920627219751204L;
            private static final ApiFunction<String, StatementType> CONSTRUCTOR = new ApiFunction<String, StatementType>(){

                public StatementType apply(String constant) {
                    return new StatementType(constant);
                }
            };
            private static final StringEnumType<StatementType> type = new StringEnumType(StatementType.class, CONSTRUCTOR);
            public static final StatementType SELECT = (StatementType)((Object)type.createAndRegister("SELECT"));
            public static final StatementType UPDATE = (StatementType)((Object)type.createAndRegister("UPDATE"));
            public static final StatementType INSERT = (StatementType)((Object)type.createAndRegister("INSERT"));
            public static final StatementType DELETE = (StatementType)((Object)type.createAndRegister("DELETE"));
            public static final StatementType CREATE_TABLE = (StatementType)((Object)type.createAndRegister("CREATE_TABLE"));
            public static final StatementType CREATE_TABLE_AS_SELECT = (StatementType)((Object)type.createAndRegister("CREATE_TABLE_AS_SELECT"));
            public static final StatementType CREATE_VIEW = (StatementType)((Object)type.createAndRegister("CREATE_VIEW"));
            public static final StatementType CREATE_MODEL = (StatementType)((Object)type.createAndRegister("CREATE_MODEL"));
            public static final StatementType CREATE_FUNCTION = (StatementType)((Object)type.createAndRegister("CREATE_FUNCTION"));
            public static final StatementType CREATE_PROCEDURE = (StatementType)((Object)type.createAndRegister("CREATE_PROCEDURE"));
            public static final StatementType ALTER_TABLE = (StatementType)((Object)type.createAndRegister("ALTER_TABLE"));
            public static final StatementType ALTER_VIEW = (StatementType)((Object)type.createAndRegister("ALTER_VIEW"));
            public static final StatementType DROP_TABLE = (StatementType)((Object)type.createAndRegister("DROP_TABLE"));
            public static final StatementType DROP_VIEW = (StatementType)((Object)type.createAndRegister("DROP_VIEW"));
            public static final StatementType DROP_FUNCTION = (StatementType)((Object)type.createAndRegister("DROP_FUNCTION"));
            public static final StatementType DROP_PROCEDURE = (StatementType)((Object)type.createAndRegister("DROP_PROCEDURE"));
            public static final StatementType MERGE = (StatementType)((Object)type.createAndRegister("MERGE"));
            public static final StatementType CREATE_MATERIALIZED_VIEW = (StatementType)((Object)type.createAndRegister("CREATE_MATERIALIZED_VIEW"));
            public static final StatementType CREATE_TABLE_FUNCTION = (StatementType)((Object)type.createAndRegister("CREATE_TABLE_FUNCTION"));
            public static final StatementType CREATE_ROW_ACCESS_POLICY = (StatementType)((Object)type.createAndRegister("CREATE_ROW_ACCESS_POLICY"));
            public static final StatementType CREATE_SCHEMA = (StatementType)((Object)type.createAndRegister("CREATE_SCHEMA"));
            public static final StatementType CREATE_SNAPSHOT_TABLE = (StatementType)((Object)type.createAndRegister("CREATE_SNAPSHOT_TABLE"));
            public static final StatementType CREATE_SEARCH_INDEX = (StatementType)((Object)type.createAndRegister("CREATE_SEARCH_INDEX"));
            public static final StatementType DROP_EXTERNAL_TABLE = (StatementType)((Object)type.createAndRegister("DROP_EXTERNAL_TABLE"));
            public static final StatementType DROP_MODEL = (StatementType)((Object)type.createAndRegister("DROP_MODEL"));
            public static final StatementType DROP_MATERIALIZED_VIEW = (StatementType)((Object)type.createAndRegister("DROP_MATERIALIZED_VIEW"));
            public static final StatementType DROP_TABLE_FUNCTION = (StatementType)((Object)type.createAndRegister("DROP_TABLE_FUNCTION"));
            public static final StatementType DROP_SEARCH_INDEX = (StatementType)((Object)type.createAndRegister("DROP_SEARCH_INDEX"));
            public static final StatementType DROP_SCHEMA = (StatementType)((Object)type.createAndRegister("DROP_SCHEMA"));
            public static final StatementType DROP_SNAPSHOT_TABLE = (StatementType)((Object)type.createAndRegister("DROP_SNAPSHOT_TABLE"));
            public static final StatementType DROP_ROW_ACCESS_POLICY = (StatementType)((Object)type.createAndRegister("DROP_ROW_ACCESS_POLICY"));
            public static final StatementType ALTER_MATERIALIZED_VIEW = (StatementType)((Object)type.createAndRegister("ALTER_MATERIALIZED_VIEW"));
            public static final StatementType ALTER_SCHEMA = (StatementType)((Object)type.createAndRegister("ALTER_SCHEMA"));
            public static final StatementType SCRIPT = (StatementType)((Object)type.createAndRegister("SCRIPT"));
            public static final StatementType TRUNCATE_TABLE = (StatementType)((Object)type.createAndRegister("TRUNCATE_TABLE"));
            public static final StatementType CREATE_EXTERNAL_TABLE = (StatementType)((Object)type.createAndRegister("CREATE_EXTERNAL_TABLE"));
            public static final StatementType EXPORT_DATA = (StatementType)((Object)type.createAndRegister("EXPORT_DATA"));
            public static final StatementType EXPORT_MODEL = (StatementType)((Object)type.createAndRegister("EXPORT_MODEL"));
            public static final StatementType LOAD_DATA = (StatementType)((Object)type.createAndRegister("LOAD_DATA"));
            public static final StatementType CALL = (StatementType)((Object)type.createAndRegister("CALL"));

            private StatementType(String constant) {
                super(constant);
            }

            public static StatementType valueOfStrict(String constant) {
                return (StatementType)((Object)type.valueOfStrict(constant));
            }

            public static StatementType valueOf(String constant) {
                return (StatementType)((Object)type.valueOf(constant));
            }

            public static StatementType[] values() {
                return (StatementType[])type.values();
            }
        }
    }

    public static class CopyStatistics
    extends JobStatistics {
        private static final long serialVersionUID = 8218325588441660939L;
        private final Long copiedLogicalBytes;
        private final Long copiedRows;

        private CopyStatistics(Builder builder) {
            super(builder);
            this.copiedLogicalBytes = builder.copiedLogicalBytes;
            this.copiedRows = builder.copiedRows;
        }

        public Long getCopiedLogicalBytes() {
            return this.copiedLogicalBytes;
        }

        public Long getCopiedRows() {
            return this.copiedRows;
        }

        @Override
        MoreObjects.ToStringHelper toStringHelper() {
            return super.toStringHelper().add("copiedLogicalBytes", (Object)this.copiedLogicalBytes).add("copiedRows", (Object)this.copiedRows);
        }

        public final boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(CopyStatistics.class) && this.baseEquals((CopyStatistics)obj);
        }

        public final int hashCode() {
            return Objects.hash(this.baseHashCode(), this.copiedLogicalBytes, this.copiedRows);
        }

        @Override
        com.google.api.services.bigquery.model.JobStatistics toPb() {
            JobStatistics5 copyStatisticsPb = new JobStatistics5();
            copyStatisticsPb.setCopiedLogicalBytes(this.copiedLogicalBytes);
            copyStatisticsPb.setCopiedRows(this.copiedRows);
            return super.toPb().setCopy(copyStatisticsPb);
        }

        static Builder newBuilder() {
            return new Builder();
        }

        static CopyStatistics fromPb(com.google.api.services.bigquery.model.JobStatistics statisticPb) {
            return new Builder(statisticPb).build();
        }

        static final class Builder
        extends com.google.cloud.bigquery.JobStatistics$Builder<CopyStatistics, Builder> {
            private Long copiedLogicalBytes;
            private Long copiedRows;

            private Builder() {
            }

            private Builder(com.google.api.services.bigquery.model.JobStatistics statisticsPb) {
                super(statisticsPb);
                if (statisticsPb.getCopy() != null) {
                    this.copiedLogicalBytes = statisticsPb.getCopy().getCopiedLogicalBytes();
                    this.copiedRows = statisticsPb.getCopy().getCopiedRows();
                }
            }

            Builder setCopiedLogicalBytes(long copiedLogicalBytes) {
                this.copiedLogicalBytes = copiedLogicalBytes;
                return (Builder)this.self();
            }

            Builder setCopiedRows(long copiedRows) {
                this.copiedRows = copiedRows;
                return (Builder)this.self();
            }

            @Override
            CopyStatistics build() {
                return new CopyStatistics(this);
            }
        }
    }
}

