/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.analyticquery;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.analyticquery.AnalyticQueryMeta;
import org.apache.hop.pipeline.transforms.analyticquery.GroupField;
import org.apache.hop.pipeline.transforms.analyticquery.QueryField;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageDialogWithToggle;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AnalyticQueryDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = AnalyticQueryDialog.class;
    public static final String STRING_SORT_WARNING_PARAMETER = "AnalyticQuerySortWarning";
    private TableView wGroup;
    private TableView wAgg;
    private final AnalyticQueryMeta input;
    private ColumnInfo[] ciKey;
    private ColumnInfo[] ciReturn;
    private final List<String> inputFields = new ArrayList<String>();

    public AnalyticQueryDialog(Shell parent, IVariables variables, AnalyticQueryMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlGroup = new Label((Composite)this.shell, 0);
        wlGroup.setText(BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.Group.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlGroup);
        FormData fdlGroup = new FormData();
        fdlGroup.left = new FormAttachment(0, 0);
        fdlGroup.top = new FormAttachment((Control)this.wlTransformName, margin);
        wlGroup.setLayoutData((Object)fdlGroup);
        int nrGroupColumns = 1;
        this.ciKey = new ColumnInfo[nrGroupColumns];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.ColumnInfo.GroupField", (String[])new String[0]), 2, new String[]{""}, false);
        this.wGroup = new TableView(this.variables, (Composite)this.shell, 68354, this.ciKey, 0, lsMod, this.props);
        Button wGet = new Button((Composite)this.shell, 8);
        wGet.setText(BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.GetFields.Button", (String[])new String[0]));
        FormData fdGet = new FormData();
        fdGet.top = new FormAttachment((Control)wlGroup, margin);
        fdGet.right = new FormAttachment(100, 0);
        wGet.setLayoutData((Object)fdGet);
        FormData fdGroup = new FormData();
        fdGroup.left = new FormAttachment(0, 0);
        fdGroup.top = new FormAttachment((Control)wlGroup, margin);
        fdGroup.right = new FormAttachment((Control)wGet, -margin);
        fdGroup.bottom = new FormAttachment(45, 0);
        this.wGroup.setLayoutData((Object)fdGroup);
        Label wlAgg = new Label((Composite)this.shell, 0);
        wlAgg.setText(BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.Aggregates.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAgg);
        FormData fdlAgg = new FormData();
        fdlAgg.left = new FormAttachment(0, 0);
        fdlAgg.top = new FormAttachment((Control)this.wGroup, margin);
        wlAgg.setLayoutData((Object)fdlAgg);
        int nrQueryCols = 4;
        this.ciReturn = new ColumnInfo[nrQueryCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.ColumnInfo.Name", (String[])new String[0]), 1, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.ColumnInfo.Subject", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.ColumnInfo.Type", (String[])new String[0]), 2, QueryField.AggregateType.getDescriptions());
        this.ciReturn[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.ColumnInfo.Value", (String[])new String[0]), 1, false);
        this.ciReturn[3].setToolTip(BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.ColumnInfo.Value.Tooltip", (String[])new String[0]));
        this.wAgg = new TableView(this.variables, (Composite)this.shell, 68354, this.ciReturn, 0, lsMod, this.props);
        Button wGetAgg = new Button((Composite)this.shell, 8);
        wGetAgg.setText(BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.GetLookupFields.Button", (String[])new String[0]));
        FormData fdGetAgg = new FormData();
        fdGetAgg.top = new FormAttachment((Control)wlAgg, margin);
        fdGetAgg.right = new FormAttachment(100, 0);
        wGetAgg.setLayoutData((Object)fdGetAgg);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        FormData fdAgg = new FormData();
        fdAgg.left = new FormAttachment(0, 0);
        fdAgg.top = new FormAttachment((Control)wlAgg, margin);
        fdAgg.right = new FormAttachment((Control)wGetAgg, -margin);
        fdAgg.bottom = new FormAttachment((Control)this.wOk, -margin);
        this.wAgg.setLayoutData((Object)fdAgg);
        this.wOk.addListener(13, e -> this.ok());
        wGet.addListener(13, e -> this.get());
        wGetAgg.addListener(13, e -> this.getAgg());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.ciKey[0].setComboValues(fieldNames);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    public void getData() {
        TableItem tableItem;
        for (GroupField groupField : this.input.getGroupFields()) {
            tableItem = new TableItem(this.wGroup.table, 0);
            tableItem.setText(1, Const.NVL((String)groupField.getFieldName(), (String)""));
        }
        this.wGroup.optimizeTableView();
        for (QueryField queryField : this.input.getQueryFields()) {
            tableItem = new TableItem(this.wAgg.table, 0);
            int column = 1;
            tableItem.setText(column++, Const.NVL((String)queryField.getAggregateField(), (String)""));
            tableItem.setText(column++, Const.NVL((String)queryField.getSubjectField(), (String)""));
            tableItem.setText(column++, queryField.getAggregateType().getDescription());
            tableItem.setText(column++, Integer.toString(queryField.getValueField()));
        }
        this.wAgg.optimizeTableView();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.getGroupFields().clear();
        this.input.getQueryFields().clear();
        for (TableItem tableItem : this.wGroup.getNonEmptyItems()) {
            this.input.getGroupFields().add(new GroupField(tableItem.getText(1)));
        }
        for (TableItem tableItem : this.wAgg.getNonEmptyItems()) {
            int column = 1;
            String field = tableItem.getText(column++);
            String subject = tableItem.getText(column++);
            String aggType = tableItem.getText(column++);
            QueryField.AggregateType aggregateType = QueryField.AggregateType.findTypeWithDescription(aggType);
            int value = Const.toInt((String)tableItem.getText(column++), (int)0);
            this.input.getQueryFields().add(new QueryField(field, subject, aggregateType, value));
        }
        this.transformName = this.wTransformName.getText();
        if ("Y".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y"))) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.GroupByWarningDialog.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.GroupByWarningDialog.DialogMessage", (String[])new String[]{Const.CR}) + Const.CR, 8, new String[]{BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.GroupByWarningDialog.Option1", (String[])new String[0])}, BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.GroupByWarningDialog.Option2", (String[])new String[0]), "N".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y")));
            md.open();
            this.props.setCustomParameter(STRING_SORT_WARNING_PARAMETER, md.getToggleState() ? "N" : "Y");
        }
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wGroup, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getAgg() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wAgg, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AnalyticQueryDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

