/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.factory.primitive;

import org.eclipse.collections.api.block.function.primitive.IntToIntFunction;

public final class IntToIntFunctions {
    private static final IntToIntFunction INCREMENT = new IncrementIntToIntFunction();
    private static final IntToIntFunction DECREMENT = new DecrementIntToIntFunction();

    private IntToIntFunctions() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static IntToIntFunction increment() {
        return INCREMENT;
    }

    public static IntToIntFunction decrement() {
        return DECREMENT;
    }

    public static IntToIntFunction add(int intToAdd) {
        return new AddIntToIntFunction(intToAdd);
    }

    public static IntToIntFunction subtract(int intToSubtract) {
        return new SubtractIntToIntFunction(intToSubtract);
    }

    private static final class SubtractIntToIntFunction
    implements IntToIntFunction {
        private static final long serialVersionUID = 1L;
        private final int intToSubtract;

        private SubtractIntToIntFunction(int intToSubtract) {
            this.intToSubtract = intToSubtract;
        }

        public int valueOf(int intParameter) {
            return intParameter - this.intToSubtract;
        }
    }

    private static final class AddIntToIntFunction
    implements IntToIntFunction {
        private static final long serialVersionUID = 1L;
        private final int intToAdd;

        private AddIntToIntFunction(int intToAdd) {
            this.intToAdd = intToAdd;
        }

        public int valueOf(int intParameter) {
            return intParameter + this.intToAdd;
        }
    }

    private static class DecrementIntToIntFunction
    implements IntToIntFunction {
        private static final long serialVersionUID = 1L;

        private DecrementIntToIntFunction() {
        }

        public int valueOf(int intParameter) {
            return intParameter - 1;
        }
    }

    private static class IncrementIntToIntFunction
    implements IntToIntFunction {
        private static final long serialVersionUID = 1L;

        private IncrementIntToIntFunction() {
        }

        public int valueOf(int intParameter) {
            return intParameter + 1;
        }
    }
}

