/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeinfo;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.typeinfo.NumericTypeInfo;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Preconditions;

@Public
public class FractionalTypeInfo<T>
extends NumericTypeInfo<T> {
    private static final long serialVersionUID = 554334260950199994L;
    private static final HashSet<Class<?>> fractionalTypes = new HashSet<Class>(Arrays.asList(Double.class, Float.class));

    protected FractionalTypeInfo(Class<T> clazz, Class<?>[] possibleCastTargetTypes, TypeSerializer<T> serializer, Class<? extends TypeComparator<T>> comparatorClass) {
        super(clazz, possibleCastTargetTypes, serializer, comparatorClass);
        Preconditions.checkArgument(fractionalTypes.contains(clazz), "The given class %s is not a fractional type.", clazz.getSimpleName());
    }
}

