/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CollectionSerializer;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.typeutils.AvroUtils;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractionUtils;

@Internal
public class Serializers {
    public static void recursivelyRegisterType(TypeInformation<?> typeInfo, SerializerConfig config, Set<Class<?>> alreadySeen) {
        if (typeInfo instanceof GenericTypeInfo) {
            GenericTypeInfo genericTypeInfo = (GenericTypeInfo)typeInfo;
            Serializers.recursivelyRegisterType(genericTypeInfo.getTypeClass(), config, alreadySeen);
        } else if (typeInfo instanceof CompositeType) {
            ArrayList genericTypesInComposite = new ArrayList();
            Serializers.getContainedGenericTypes((CompositeType)typeInfo, genericTypesInComposite);
            for (GenericTypeInfo genericTypeInfo : genericTypesInComposite) {
                Serializers.recursivelyRegisterType(genericTypeInfo.getTypeClass(), config, alreadySeen);
            }
        } else if (typeInfo instanceof ObjectArrayTypeInfo) {
            ObjectArrayTypeInfo objectArrayTypeInfo = (ObjectArrayTypeInfo)typeInfo;
            Serializers.recursivelyRegisterType(objectArrayTypeInfo.getComponentInfo(), config, alreadySeen);
        }
    }

    public static void recursivelyRegisterType(Class<?> type, SerializerConfig config, Set<Class<?>> alreadySeen) {
        if (type == null || type.isPrimitive() || type == Object.class) {
            return;
        }
        if (!alreadySeen.add(type)) {
            return;
        }
        if (type.isArray()) {
            Serializers.recursivelyRegisterType(type.getComponentType(), config, alreadySeen);
        } else {
            Field[] fields;
            config.registerKryoType(type);
            AvroUtils.getAvroUtils().addAvroSerializersIfRequired(config, type);
            for (Field field : fields = type.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                Type fieldType = field.getGenericType();
                Serializers.recursivelyRegisterGenericType(fieldType, config, alreadySeen);
            }
        }
    }

    private static void recursivelyRegisterGenericType(Type fieldType, SerializerConfig config, Set<Class<?>> alreadySeen) {
        if (fieldType instanceof ParameterizedType) {
            ParameterizedType parameterizedFieldType = (ParameterizedType)fieldType;
            for (Type t : parameterizedFieldType.getActualTypeArguments()) {
                if (!TypeExtractionUtils.isClassType(t)) continue;
                Serializers.recursivelyRegisterType(TypeExtractionUtils.typeToClass(t), config, alreadySeen);
            }
            Serializers.recursivelyRegisterGenericType(parameterizedFieldType.getRawType(), config, alreadySeen);
        } else if (fieldType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)fieldType;
            Serializers.recursivelyRegisterGenericType(genericArrayType.getGenericComponentType(), config, alreadySeen);
        } else if (fieldType instanceof Class) {
            Class clazz = (Class)fieldType;
            Serializers.recursivelyRegisterType(clazz, config, alreadySeen);
        }
    }

    private static void getContainedGenericTypes(CompositeType<?> typeInfo, List<GenericTypeInfo<?>> target) {
        for (int i = 0; i < typeInfo.getArity(); ++i) {
            TypeInformation type = typeInfo.getTypeAt(i);
            if (type instanceof CompositeType) {
                Serializers.getContainedGenericTypes((CompositeType)type, target);
                continue;
            }
            if (!(type instanceof GenericTypeInfo) || target.contains(type)) continue;
            target.add((GenericTypeInfo)type);
        }
    }

    public static class SpecificInstanceCollectionSerializer<T extends Collection>
    extends CollectionSerializer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Class<T> type;

        public SpecificInstanceCollectionSerializer(Class<T> type) {
            this.type = type;
        }

        protected Collection create(Kryo kryo, Input input, Class<Collection> type) {
            return (Collection)kryo.newInstance(this.type);
        }

        protected Collection createCopy(Kryo kryo, Collection original) {
            return (Collection)kryo.newInstance(this.type);
        }
    }

    public static class SpecificInstanceCollectionSerializerForArrayList
    extends SpecificInstanceCollectionSerializer<ArrayList> {
        private static final long serialVersionUID = 1L;

        public SpecificInstanceCollectionSerializerForArrayList() {
            super(ArrayList.class);
        }
    }

    public static class DummyAvroKryoSerializerClass<T>
    extends Serializer<T> {
        public void write(Kryo kryo, Output output, Object o) {
            throw new UnsupportedOperationException("Could not find required Avro dependency.");
        }

        public T read(Kryo kryo, Input input, Class<T> aClass) {
            throw new UnsupportedOperationException("Could not find required Avro dependency.");
        }
    }

    public static class DummyAvroRegisteredClass {
    }
}

