/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.util;

import java.io.PrintWriter;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.monetdb.util.Exporter;

public final class SQLExporter
extends Exporter {
    private int outputMode;
    private Stack<String> lastSchema;
    public static final short TYPE_OUTPUT = 1;
    public static final short VALUE_INSERT = 0;
    public static final short VALUE_COPY = 1;
    public static final short VALUE_TABLE = 2;
    private static final short AS_IS = 0;
    private static final short QUOTE = 1;

    public SQLExporter(PrintWriter printWriter) {
        super(printWriter);
    }

    @Override
    public void dumpSchema(DatabaseMetaData databaseMetaData, String string, String string2, String string3) throws SQLException {
        Iterator iterator;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        assert (databaseMetaData != null);
        assert (string != null);
        assert (string2 != null);
        assert (string3 != null);
        String string4 = SQLExporter.dq(string2) + "." + SQLExporter.dq(string3);
        if (this.useSchema) {
            this.changeSchema(string2);
        }
        if (string.endsWith("VIEW")) {
            String string5 = SQLExporter.fetchSysTablesQueryValue(databaseMetaData.getConnection(), string2, string3);
            if (string5 != null) {
                this.out.println(string5);
            } else {
                this.out.println("-- unknown " + string + " " + string4 + ": no SQL view definition found!");
            }
            return;
        }
        this.out.println("CREATE " + string + " " + string4 + " (");
        ResultSet resultSet = databaseMetaData.getColumns(null, string2, string3, null);
        int n6 = resultSet.findColumn("COLUMN_NAME");
        int n7 = resultSet.findColumn("TYPE_NAME");
        int n8 = resultSet.findColumn("DATA_TYPE");
        int n9 = resultSet.findColumn("COLUMN_SIZE");
        int n10 = resultSet.findColumn("DECIMAL_DIGITS");
        int n11 = resultSet.findColumn("NULLABLE");
        int n12 = resultSet.findColumn("COLUMN_DEF");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n13 = resultSetMetaData.getColumnDisplaySize(n6);
        int n14 = resultSetMetaData.getColumnDisplaySize(n7);
        if (n14 < 13) {
            n14 = 13;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        int n15 = 0;
        while (resultSet.next()) {
            if (n15 > 0) {
                this.out.println(",");
            }
            String string6 = SQLExporter.dq(resultSet.getString(n6));
            this.out.print("\t" + string6 + SQLExporter.repeat(' ', n13 - string6.length() + 3));
            int n16 = resultSet.getInt(n10);
            string6 = resultSet.getString(n7).toUpperCase();
            if (string6.equals("INT")) {
                string6 = "INTEGER";
            } else if (string6.equals("SEC_INTERVAL")) {
                string6 = "INTERVAL SECOND";
            } else if (string6.equals("DAY_INTERVAL")) {
                string6 = "INTERVAL DAY";
            } else if (string6.equals("MONTH_INTERVAL")) {
                string6 = "INTERVAL MONTH";
            } else if (string6.equals("TIMETZ")) {
                string6 = "TIME";
                n16 = 1;
            } else if (string6.equals("TIMESTAMPTZ")) {
                string6 = "TIMESTAMP";
                n16 = 1;
            }
            stringBuilder.append(string6);
            int n17 = resultSet.getInt(n8);
            int n18 = resultSet.getInt(n9);
            switch (n17) {
                case -1: 
                case 1: 
                case 6: 
                case 12: 
                case 2004: 
                case 2005: {
                    if (n18 <= 0) break;
                    stringBuilder.append('(').append(n18).append(')');
                    break;
                }
                case 92: 
                case 93: 
                case 2013: 
                case 2014: {
                    if (n18 > 1) {
                        stringBuilder.append('(').append(n18 - 1).append(')');
                    }
                    if (n16 != 1) break;
                    stringBuilder.append(" WITH TIME ZONE");
                    break;
                }
                case 2: 
                case 3: {
                    stringBuilder.append('(').append(n18);
                    if (n16 != 0) {
                        stringBuilder.append(',').append(n16);
                    }
                    stringBuilder.append(')');
                }
            }
            n5 = resultSet.getInt(n11) == 0 ? 1 : 0;
            String string7 = resultSet.getString(n12);
            int n19 = n4 = string7 != null && !string7.isEmpty() ? 1 : 0;
            if (n5 != 0 || n4 != 0) {
                n3 = n14 - stringBuilder.length();
                if (n3 > 0) {
                    stringBuilder.append(SQLExporter.repeat(' ', n3));
                }
                if (n5 != 0) {
                    stringBuilder.append(" NOT NULL");
                }
                if (n4 != 0) {
                    stringBuilder.append(" DEFAULT ").append(string7);
                }
            }
            this.out.print(stringBuilder.toString());
            stringBuilder.setLength(0);
            ++n15;
        }
        resultSet.close();
        resultSet = databaseMetaData.getPrimaryKeys(null, string2, string3);
        int n20 = resultSet.findColumn("KEY_SEQ");
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        n15 = 1;
        while (resultSet.next()) {
            treeMap.put(resultSet.getInt(n20), n15);
            ++n15;
        }
        if (treeMap.size() > 0) {
            resultSet.absolute(1);
            this.out.println(",");
            this.out.print("\tCONSTRAINT " + SQLExporter.dq(resultSet.getString("PK_NAME")) + " PRIMARY KEY (");
            n6 = resultSet.findColumn("COLUMN_NAME");
            Iterator iterator2 = treeMap.entrySet().iterator();
            n15 = 0;
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                resultSet.absolute((Integer)entry.getValue());
                if (n15 > 0) {
                    this.out.print(", ");
                }
                this.out.print(SQLExporter.dq(resultSet.getString(n6)));
                ++n15;
            }
            this.out.print(")");
        }
        resultSet.close();
        resultSet = databaseMetaData.getIndexInfo(null, string2, string3, true, true);
        int n21 = resultSet.findColumn("INDEX_NAME");
        n6 = resultSet.findColumn("COLUMN_NAME");
        while (resultSet.next()) {
            String string8 = resultSet.getString(n21);
            if (string8 == null || string8.endsWith("_pkey")) continue;
            this.out.println(",");
            this.out.print("\tCONSTRAINT " + SQLExporter.dq(string8));
            if (string8.endsWith("_nndunique")) {
                this.out.print(" UNIQUE NULLS NOT DISTINCT (");
            } else {
                this.out.print(" UNIQUE (");
            }
            this.out.print(SQLExporter.dq(resultSet.getString(n6)));
            while (true) {
                boolean bl = resultSet.next();
                n5 = bl ? 1 : 0;
                if (!bl || !string8.equals(resultSet.getString(n21))) break;
                this.out.print(", " + SQLExporter.dq(resultSet.getString(n6)));
            }
            if (n5 != 0) {
                resultSet.previous();
            }
            this.out.print(")");
        }
        resultSet.close();
        resultSet = databaseMetaData.getImportedKeys(null, string2, string3);
        int n22 = resultSet.findColumn("FK_NAME");
        n5 = resultSet.findColumn("FKCOLUMN_NAME");
        int n23 = resultSet.findColumn("PKCOLUMN_NAME");
        n20 = resultSet.findColumn("KEY_SEQ");
        n4 = resultSet.findColumn("PKTABLE_SCHEM");
        n3 = resultSet.findColumn("PKTABLE_NAME");
        int n24 = resultSet.findColumn("UPDATE_RULE");
        int n25 = resultSet.findColumn("DELETE_RULE");
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(8);
        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>(6);
        LinkedHashSet<String> linkedHashSet3 = new LinkedHashSet<String>(6);
        while (resultSet.next()) {
            this.out.println(",");
            this.out.print("\tCONSTRAINT " + SQLExporter.dq(resultSet.getString(n22)) + " FOREIGN KEY (");
            linkedHashSet.add(resultSet.getString(n22));
            linkedHashSet2.clear();
            linkedHashSet2.add(resultSet.getString(n5));
            linkedHashSet3.clear();
            linkedHashSet3.add(resultSet.getString(n23));
            short s = resultSet.getShort(n24);
            n2 = resultSet.getShort(n25);
            while (true) {
                boolean bl = resultSet.next();
                n = bl ? 1 : 0;
                if (!bl || resultSet.getInt(n20) == 1) break;
                linkedHashSet2.add(resultSet.getString(n5));
                linkedHashSet3.add(resultSet.getString(n23));
            }
            if (n != 0) {
                resultSet.previous();
            }
            iterator = linkedHashSet2.iterator();
            n15 = 0;
            while (iterator.hasNext()) {
                if (n15 > 0) {
                    this.out.print(", ");
                }
                this.out.print(SQLExporter.dq((String)iterator.next()));
                ++n15;
            }
            this.out.print(") REFERENCES " + SQLExporter.dq(resultSet.getString(n4)) + "." + SQLExporter.dq(resultSet.getString(n3)) + " (");
            iterator = linkedHashSet3.iterator();
            n15 = 0;
            while (iterator.hasNext()) {
                if (n15 > 0) {
                    this.out.print(", ");
                }
                this.out.print(SQLExporter.dq((String)iterator.next()));
                ++n15;
            }
            this.out.print(")");
            switch (s) {
                case 0: {
                    this.out.print(" ON UPDATE ");
                    this.out.print("CASCADE");
                    break;
                }
                case 3: {
                    this.out.print(" ON UPDATE ");
                    this.out.print("NO ACTION");
                    break;
                }
                case 1: {
                    this.out.print(" ON UPDATE ");
                    this.out.print("RESTRICT");
                    break;
                }
                case 2: {
                    this.out.print(" ON UPDATE ");
                    this.out.print("SET NULL");
                    break;
                }
                case 4: {
                    this.out.print(" ON UPDATE ");
                    this.out.print("SET DEFAULT");
                }
            }
            switch (n2) {
                case 0: {
                    this.out.print(" ON DELETE ");
                    this.out.print("CASCADE");
                    break;
                }
                case 3: {
                    this.out.print(" ON DELETE ");
                    this.out.print("NO ACTION");
                    break;
                }
                case 1: {
                    this.out.print(" ON DELETE ");
                    this.out.print("RESTRICT");
                    break;
                }
                case 2: {
                    this.out.print(" ON DELETE ");
                    this.out.print("SET NULL");
                    break;
                }
                case 4: {
                    this.out.print(" ON DELETE ");
                    this.out.print("SET DEFAULT");
                }
            }
        }
        resultSet.close();
        this.out.println();
        if (string.equals("REMOTE TABLE")) {
            String string9 = SQLExporter.fetchSysTablesQueryValue(databaseMetaData.getConnection(), string2, string3);
            this.out.println(") ON '" + (string9 != null ? string9 : "!!missing mapi:monetdb:// spec") + "';");
        } else {
            this.out.println(");");
        }
        resultSet = databaseMetaData.getIndexInfo(null, string2, string3, false, true);
        n21 = resultSet.findColumn("INDEX_NAME");
        n6 = resultSet.findColumn("COLUMN_NAME");
        int n26 = resultSet.findColumn("TABLE_NAME");
        n2 = resultSet.findColumn("TABLE_SCHEM");
        n = resultSet.findColumn("NON_UNIQUE");
        while (resultSet.next()) {
            boolean bl;
            if (!resultSet.getBoolean(n) || (iterator = resultSet.getString(n21)) == null || linkedHashSet.contains(iterator)) continue;
            this.out.print("CREATE INDEX " + SQLExporter.dq((String)((Object)iterator)) + " ON " + SQLExporter.dq(resultSet.getString(n2)) + "." + SQLExporter.dq(resultSet.getString(n26)) + " (" + SQLExporter.dq(resultSet.getString(n6)));
            while ((bl = resultSet.next()) && ((String)((Object)iterator)).equals(resultSet.getString(n21))) {
                this.out.print(", " + SQLExporter.dq(resultSet.getString(n6)));
            }
            if (bl) {
                resultSet.previous();
            }
            this.out.println(");");
        }
        resultSet.close();
    }

    @Override
    public void dumpResultSet(ResultSet resultSet) throws SQLException {
        switch (this.outputMode) {
            case 0: {
                this.resultSetToSQL(resultSet);
                break;
            }
            case 1: {
                this.resultSetToSQLDump(resultSet);
                break;
            }
            case 2: {
                this.resultSetToTable(resultSet);
            }
        }
    }

    @Override
    public void setProperty(int n, int n2) throws Exception {
        block0 : switch (n) {
            case 1: {
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.outputMode = n2;
                        break block0;
                    }
                }
                throw new Exception("Illegal value " + n2 + " for TYPE_OUTPUT");
            }
            default: {
                throw new Exception("Illegal type " + n);
            }
        }
    }

    @Override
    public int getProperty(int n) throws Exception {
        switch (n) {
            case 1: {
                return this.outputMode;
            }
        }
        throw new Exception("Illegal type " + n);
    }

    private void resultSetToSQL(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        short[] sArray = new short[n + 1];
        block4: for (int i = 1; i <= n; ++i) {
            switch (resultSetMetaData.getColumnType(i)) {
                case -1: 
                case 1: 
                case 12: 
                case 91: 
                case 92: 
                case 93: 
                case 2004: 
                case 2005: 
                case 2013: 
                case 2014: {
                    sArray[i] = 1;
                    continue block4;
                }
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: {
                    sArray[i] = 0;
                    continue block4;
                }
                default: {
                    sArray[i] = 1;
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append("INSERT INTO ");
        String string = resultSetMetaData.getSchemaName(1);
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(SQLExporter.dq(string)).append(".");
        }
        stringBuilder.append(SQLExporter.dq(resultSetMetaData.getTableName(1))).append(" VALUES (");
        int n2 = stringBuilder.length();
        while (resultSet.next()) {
            for (int i = 1; i <= n; ++i) {
                String string2 = resultSet.getString(i);
                if (i > 1) {
                    stringBuilder.append(", ");
                }
                if (string2 == null || resultSet.wasNull()) {
                    stringBuilder.append("NULL");
                    continue;
                }
                stringBuilder.append(sArray[i] == 1 ? SQLExporter.sq(string2) : string2);
            }
            stringBuilder.append(");");
            this.out.println(stringBuilder.toString());
            stringBuilder.setLength(n2);
        }
    }

    public void resultSetToSQLDump(ResultSet resultSet) {
    }

    public void resultSetToTable(ResultSet resultSet) throws SQLException {
        int n;
        int n2;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        int[] nArray = new int[n3 + 1];
        boolean[] blArray = new boolean[n3 + 1];
        for (int i = 1; i < nArray.length; ++i) {
            n2 = resultSetMetaData.getColumnDisplaySize(i);
            int n4 = n2 > (n = resultSetMetaData.getColumnLabel(i).length()) ? n2 : n;
            nArray[i] = n4 > 4 ? n4 : 4;
            blArray[i] = resultSetMetaData.isSigned(i);
        }
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append('+');
        for (n2 = 1; n2 < nArray.length; ++n2) {
            stringBuilder.append(SQLExporter.repeat('-', nArray[n2] + 1)).append("-+");
        }
        String string = stringBuilder.toString();
        stringBuilder.setLength(0);
        stringBuilder.append('|');
        for (n = 1; n < nArray.length; ++n) {
            String string2 = resultSetMetaData.getColumnLabel(n);
            stringBuilder.append(' ').append(string2);
            stringBuilder.append(SQLExporter.repeat(' ', nArray[n] - string2.length()));
            stringBuilder.append(" |");
        }
        this.out.println(string);
        this.out.println(stringBuilder.toString());
        this.out.println(string.replace('-', '='));
        long l = 0L;
        while (resultSet.next()) {
            stringBuilder.setLength(0);
            stringBuilder.append('|');
            for (int i = 1; i < nArray.length; ++i) {
                int n5;
                String string3 = resultSet.getString(i);
                if (string3 == null || resultSet.wasNull()) {
                    string3 = "NULL";
                }
                if ((n5 = nArray[i] - string3.length()) <= 0) {
                    if (n5 == 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(string3);
                } else {
                    stringBuilder.append(' ');
                    if (blArray[i]) {
                        stringBuilder.append(SQLExporter.repeat(' ', n5));
                        stringBuilder.append(string3);
                    } else {
                        stringBuilder.append(string3);
                        stringBuilder.append(SQLExporter.repeat(' ', n5));
                    }
                }
                stringBuilder.append(" |");
            }
            this.out.println(stringBuilder.toString());
            ++l;
        }
        this.out.println(string);
        this.out.print(l);
        this.out.println(l != 1L ? " rows" : " row");
    }

    private void changeSchema(String string) {
        if (this.lastSchema == null) {
            this.lastSchema = new Stack();
            this.lastSchema.push(null);
        }
        if (!string.equals(this.lastSchema.peek())) {
            if (!this.lastSchema.contains(string)) {
                if (!(string.equals("sys") || string.equals("tmp") || string.equals("json") || string.equals("profiler") || string.equals("wlc") || string.equals("wlr") || string.equals("logging") || string.equals("bam"))) {
                    this.out.print("CREATE SCHEMA ");
                    this.out.print(SQLExporter.dq(string));
                    this.out.println(";\n");
                }
                this.lastSchema.push(string);
            }
            this.out.print("SET SCHEMA ");
            this.out.print(SQLExporter.dq(string));
            this.out.println(";\n");
        }
    }
}

