/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.GrpcCall;
import com.squareup.wire.GrpcHttpUrlKt;
import com.squareup.wire.GrpcMethod;
import com.squareup.wire.GrpcStreamingCall;
import com.squareup.wire.Service;
import com.squareup.wire.internal.RealGrpcCall;
import com.squareup.wire.internal.RealGrpcStreamingCall;
import java.lang.reflect.Constructor;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001+B#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u0010\u001a\u0002H\u0011\"\n\b\u0000\u0010\u0011\u0018\u0001*\u00020\u0012H\u0086\b\u00a2\u0006\u0002\u0010\u0013J#\u0010\u0010\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0015\u00a2\u0006\u0002\u0010\u0016J$\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018\"\b\b\u0000\u0010\u0011*\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0015H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ=\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!0 2\n\u0010\"\u001a\u00060#j\u0002`$H\u0000\u00a2\u0006\u0002\b%J:\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u0002H(0&\"\b\b\u0000\u0010'*\u00020\u0001\"\b\b\u0001\u0010(*\u00020\u00012\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u0002H(0\u001eJ:\u0010)\u001a\u000e\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u0002H(0*\"\b\b\u0000\u0010'*\u00020\u0001\"\b\b\u0001\u0010(*\u00020\u00012\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u0002H(0\u001eR\u0018\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006,"}, d2={"Lcom/squareup/wire/GrpcClient;", "", "client", "Lokhttp3/Call$Factory;", "baseUrl", "Lokhttp3/HttpUrl;", "Lcom/squareup/wire/GrpcHttpUrl;", "minMessageToCompress", "", "(Lokhttp3/Call$Factory;Lokhttp3/HttpUrl;J)V", "getBaseUrl$wire_grpc_client", "()Lokhttp3/HttpUrl;", "getClient$wire_grpc_client", "()Lokhttp3/Call$Factory;", "getMinMessageToCompress$wire_grpc_client", "()J", "create", "T", "Lcom/squareup/wire/Service;", "()Lcom/squareup/wire/Service;", "service", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)Lcom/squareup/wire/Service;", "implementationClass", "Ljava/lang/Class;", "newBuilder", "Lcom/squareup/wire/GrpcClient$Builder;", "newCall", "Lokhttp3/Call;", "method", "Lcom/squareup/wire/GrpcMethod;", "requestMetadata", "", "", "requestBody", "Lokhttp3/RequestBody;", "Lcom/squareup/wire/GrpcRequestBody;", "newCall$wire_grpc_client", "Lcom/squareup/wire/GrpcCall;", "S", "R", "newStreamingCall", "Lcom/squareup/wire/GrpcStreamingCall;", "Builder", "wire-grpc-client"})
public final class GrpcClient {
    @NotNull
    private final Call.Factory client;
    @NotNull
    private final HttpUrl baseUrl;
    private final long minMessageToCompress;

    private GrpcClient(Call.Factory client, HttpUrl baseUrl, long minMessageToCompress) {
        this.client = client;
        this.baseUrl = baseUrl;
        this.minMessageToCompress = minMessageToCompress;
    }

    @NotNull
    public final Call.Factory getClient$wire_grpc_client() {
        return this.client;
    }

    @NotNull
    public final HttpUrl getBaseUrl$wire_grpc_client() {
        return this.baseUrl;
    }

    public final long getMinMessageToCompress$wire_grpc_client() {
        return this.minMessageToCompress;
    }

    public final /* synthetic */ <T extends Service> T create() {
        boolean $i$f$create = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.create(Reflection.getOrCreateKotlinClass(Service.class));
    }

    @NotNull
    public final <T extends Service> T create(@NotNull KClass<T> service) {
        Intrinsics.checkNotNullParameter(service, (String)"service");
        try {
            Class<?> implementationClass = this.implementationClass(service);
            Constructor<?>[] constructorArray = implementationClass.getDeclaredConstructors();
            Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"implementationClass.declaredConstructors");
            Constructor onlyConstructor = (Constructor)ArraysKt.single((Object[])constructorArray);
            Object object = new Object[]{this};
            Object instance = onlyConstructor.newInstance(object);
            object = JvmClassMappingKt.getJavaClass(service).cast(instance);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"service.java.cast(instance)");
            return (T)((Service)object);
        }
        catch (Exception _) {
            throw new IllegalStateException(("failed to create gRPC class for " + service + ": is it a Wire-generated gRPC interface?").toString());
        }
    }

    private final <T extends Service> Class<?> implementationClass(KClass<T> service) {
        String string = service.getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        String interfaceName = string;
        int simpleNameOffset = StringsKt.lastIndexOf$default((CharSequence)interfaceName, (String)".", (int)0, (boolean)false, (int)6, null) + 1;
        String string2 = interfaceName;
        int n = 0;
        Object object = string2.substring(n, simpleNameOffset);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String packageName = object;
        object = interfaceName.substring(simpleNameOffset);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).substring(startIndex)");
        String interfaceSimpleName = object;
        String implementationName = packageName + "Grpc" + interfaceSimpleName;
        object = Class.forName(implementationName);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"forName(implementationName)");
        return object;
    }

    @NotNull
    public final <S, R> GrpcCall<S, R> newCall(@NotNull GrpcMethod<S, R> method) {
        Intrinsics.checkNotNullParameter(method, (String)"method");
        return new RealGrpcCall<S, R>(this, method);
    }

    @NotNull
    public final <S, R> GrpcStreamingCall<S, R> newStreamingCall(@NotNull GrpcMethod<S, R> method) {
        Intrinsics.checkNotNullParameter(method, (String)"method");
        return new RealGrpcStreamingCall<S, R>(this, method);
    }

    @NotNull
    public final Builder newBuilder() {
        return new Builder().callFactory(this.client).baseUrl(this.baseUrl).minMessageToCompress(this.minMessageToCompress);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Call newCall$wire_grpc_client(@NotNull GrpcMethod<?, ?> method, @NotNull Map<String, String> requestMetadata, @NotNull RequestBody requestBody) {
        void $this$newCall_u24lambda_u2d0;
        Request.Builder builder;
        Intrinsics.checkNotNullParameter(method, (String)"method");
        Intrinsics.checkNotNullParameter(requestMetadata, (String)"requestMetadata");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        Request.Builder builder2 = new Request.Builder();
        HttpUrl httpUrl = this.baseUrl.resolve(method.getPath());
        Intrinsics.checkNotNull((Object)httpUrl);
        Request.Builder builder3 = builder = builder2.url(httpUrl).addHeader("te", "trailers").addHeader("grpc-trace-bin", "").addHeader("grpc-accept-encoding", "gzip");
        Call.Factory factory = this.client;
        boolean bl = false;
        if (this.getMinMessageToCompress$wire_grpc_client() < Long.MAX_VALUE) {
            $this$newCall_u24lambda_u2d0.addHeader("grpc-encoding", "gzip");
        }
        for (Map.Entry<String, String> entry : requestMetadata.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            $this$newCall_u24lambda_u2d0.addHeader(key, value);
        }
        return factory.newCall(builder.tag(GrpcMethod.class, method).method("POST", requestBody).build());
    }

    public /* synthetic */ GrpcClient(Call.Factory client, HttpUrl baseUrl, long minMessageToCompress, DefaultConstructorMarker $constructor_marker) {
        this(client, baseUrl, minMessageToCompress);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00002\n\u0010\n\u001a\u00060\u0004j\u0002`\u0005J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u000fJ\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\tR\u0016\u0010\u0003\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/squareup/wire/GrpcClient$Builder;", "", "()V", "baseUrl", "Lokhttp3/HttpUrl;", "Lcom/squareup/wire/GrpcHttpUrl;", "client", "Lokhttp3/Call$Factory;", "minMessageToCompress", "", "url", "", "build", "Lcom/squareup/wire/GrpcClient;", "callFactory", "Lokhttp3/OkHttpClient;", "bytes", "wire-grpc-client"})
    public static final class Builder {
        @Nullable
        private Call.Factory client;
        @Nullable
        private HttpUrl baseUrl;
        private long minMessageToCompress;

        @NotNull
        public final Builder client(@NotNull OkHttpClient client) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            if (!(client.protocols().contains(Protocol.HTTP_2) || client.protocols().contains(Protocol.H2_PRIOR_KNOWLEDGE))) {
                boolean bl = false;
                String string = "OkHttpClient is not configured with a HTTP/2 protocol which is required for gRPC connections.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.callFactory((Call.Factory)client);
        }

        @NotNull
        public final Builder callFactory(@NotNull Call.Factory client) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Builder $this$callFactory_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$callFactory_u24lambda_u2d1.client = client;
            return builder;
        }

        @NotNull
        public final Builder baseUrl(@NotNull String baseUrl) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Builder $this$baseUrl_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            $this$baseUrl_u24lambda_u2d2.baseUrl = GrpcHttpUrlKt.toHttpUrl(baseUrl);
            return builder;
        }

        @NotNull
        public final Builder baseUrl(@NotNull HttpUrl url) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Builder $this$baseUrl_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$baseUrl_u24lambda_u2d3.baseUrl = url;
            return builder;
        }

        @NotNull
        public final Builder minMessageToCompress(long bytes) {
            Builder builder;
            Builder $this$minMessageToCompress_u24lambda_u2d5 = builder = this;
            boolean bl = false;
            if (!(bytes >= 0L)) {
                boolean bl2 = false;
                String string = Intrinsics.stringPlus((String)"minMessageToCompress must not be negative: ", (Object)bytes);
                throw new IllegalArgumentException(string.toString());
            }
            $this$minMessageToCompress_u24lambda_u2d5.minMessageToCompress = bytes;
            return builder;
        }

        @NotNull
        public final GrpcClient build() {
            Call.Factory factory = this.client;
            if (factory == null) {
                throw new IllegalArgumentException("client is not set");
            }
            HttpUrl httpUrl = this.baseUrl;
            if (httpUrl == null) {
                throw new IllegalArgumentException("baseUrl is not set");
            }
            return new GrpcClient(factory, httpUrl, this.minMessageToCompress, null);
        }
    }
}

