/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.wire;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.util.construction.ModelCoders;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class LengthPrefixUnknownCoders {
    private static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> otherKnownCoderUrns = new HashSet<String>();

    public static void addKnownCoderUrn(@UnknownKeyFor @NonNull @Initialized String urn) {
        otherKnownCoderUrns.add(urn);
    }

    public static @UnknownKeyFor @NonNull @Initialized String addLengthPrefixedCoder(@UnknownKeyFor @NonNull @Initialized String coderId, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components.Builder components, @UnknownKeyFor @NonNull @Initialized boolean replaceWithByteArrayCoder) {
        String lengthPrefixedByteArrayCoderId = LengthPrefixUnknownCoders.addLengthPrefixByteArrayCoder(components);
        String urn = components.getCodersOrThrow(coderId).getSpec().getUrn();
        if (ModelCoders.LENGTH_PREFIX_CODER_URN.equals(urn)) {
            return replaceWithByteArrayCoder ? lengthPrefixedByteArrayCoderId : coderId;
        }
        if (ModelCoders.urns().contains(urn) || otherKnownCoderUrns.contains(urn)) {
            return LengthPrefixUnknownCoders.addForModelCoder(coderId, components, replaceWithByteArrayCoder);
        }
        return replaceWithByteArrayCoder ? lengthPrefixedByteArrayCoderId : LengthPrefixUnknownCoders.addWrappedWithLengthPrefixCoder(coderId, components);
    }

    private static @UnknownKeyFor @NonNull @Initialized String addForModelCoder(@UnknownKeyFor @NonNull @Initialized String coderId, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components.Builder components, @UnknownKeyFor @NonNull @Initialized boolean replaceWithByteArrayCoder) {
        RunnerApi.Coder coder = components.getCodersOrThrow(coderId);
        if (coder.getComponentCoderIdsCount() == 0) {
            return coderId;
        }
        RunnerApi.Coder.Builder builder = coder.toBuilder().clearComponentCoderIds();
        for (String componentCoderId : coder.getComponentCoderIdsList()) {
            builder.addComponentCoderIds(LengthPrefixUnknownCoders.addLengthPrefixedCoder(componentCoderId, components, replaceWithByteArrayCoder));
        }
        return LengthPrefixUnknownCoders.addCoder(builder.build(), components, coderId + "-length_prefix");
    }

    private static @UnknownKeyFor @NonNull @Initialized String addWrappedWithLengthPrefixCoder(@UnknownKeyFor @NonNull @Initialized String coderId, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components.Builder components) {
        RunnerApi.Coder.Builder lengthPrefixed = RunnerApi.Coder.newBuilder().addComponentCoderIds(coderId);
        lengthPrefixed.getSpecBuilder().setUrn(ModelCoders.LENGTH_PREFIX_CODER_URN).build();
        return LengthPrefixUnknownCoders.addCoder(lengthPrefixed.build(), components, coderId + "-length_prefix");
    }

    private static @UnknownKeyFor @NonNull @Initialized String addLengthPrefixByteArrayCoder(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components.Builder components) {
        RunnerApi.Coder.Builder byteArrayCoder = RunnerApi.Coder.newBuilder();
        byteArrayCoder.getSpecBuilder().setUrn(ModelCoders.BYTES_CODER_URN);
        String byteArrayCoderId = LengthPrefixUnknownCoders.addCoder(byteArrayCoder.build(), components, "byte_array");
        RunnerApi.Coder.Builder lengthPrefixByteArrayCoder = RunnerApi.Coder.newBuilder();
        lengthPrefixByteArrayCoder.addComponentCoderIds(byteArrayCoderId).getSpecBuilder().setUrn(ModelCoders.LENGTH_PREFIX_CODER_URN);
        return LengthPrefixUnknownCoders.addCoder(lengthPrefixByteArrayCoder.build(), components, "length_prefix_byte_array");
    }

    private static @UnknownKeyFor @NonNull @Initialized String addCoder(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Coder coder, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components.Builder components, @UnknownKeyFor @NonNull @Initialized String uniqueIdPrefix) {
        for (Map.Entry entry : components.getCodersMap().entrySet()) {
            if (!((RunnerApi.Coder)entry.getValue()).equals((Object)coder)) continue;
            return (String)entry.getKey();
        }
        String id = LengthPrefixUnknownCoders.generateUniqueId(uniqueIdPrefix, arg_0 -> ((RunnerApi.Components.Builder)components).containsCoders(arg_0));
        components.putCoders(id, coder);
        return id;
    }

    static @UnknownKeyFor @NonNull @Initialized String generateUniqueId(@UnknownKeyFor @NonNull @Initialized String prefix, @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized String> isExistingId) {
        int i = 0;
        while (isExistingId.test(prefix + i)) {
            ++i;
        }
        return prefix + i;
    }
}

