/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.converters;

import io.github.spannm.jackcess.Column;
import io.github.spannm.jackcess.ColumnBuilder;
import io.github.spannm.jackcess.Cursor;
import io.github.spannm.jackcess.CursorBuilder;
import io.github.spannm.jackcess.DataType;
import io.github.spannm.jackcess.Database;
import io.github.spannm.jackcess.Index;
import io.github.spannm.jackcess.IndexBuilder;
import io.github.spannm.jackcess.IndexCursor;
import io.github.spannm.jackcess.PropertyMap;
import io.github.spannm.jackcess.RelationshipBuilder;
import io.github.spannm.jackcess.Row;
import io.github.spannm.jackcess.Table;
import io.github.spannm.jackcess.TableBuilder;
import io.github.spannm.jackcess.impl.DatabaseImpl;
import io.github.spannm.jackcess.impl.TableImpl;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.ucanaccess.commands.InsertCommand;
import net.ucanaccess.complex.ComplexBase;
import net.ucanaccess.complex.UnsupportedValue;
import net.ucanaccess.converters.LoadJet;
import net.ucanaccess.converters.Metadata;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.converters.TypesMap;
import net.ucanaccess.exception.UnsupportedTypeException;
import net.ucanaccess.jdbc.DBReference;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.jdbc.UcanaccessDatabaseMetadata;
import net.ucanaccess.jdbc.UcanaccessStatement;
import net.ucanaccess.type.ObjectType;
import net.ucanaccess.util.HibernateSupport;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimestampData;

public class Persist2Jet {
    private static final Map<File, Map<String, List<String>>> COL_NAMES_CACHE = new LinkedHashMap<File, Map<String, List<String>>>();

    public Map<String, Object> getRowPattern(Object[] varr, Table t) throws SQLException {
        String ntn = SQLConverter.basicEscapingIdentifier(t.getName()).toUpperCase();
        LinkedHashMap<String, Object> vl = new LinkedHashMap<String, Object>();
        int i = 0;
        for (String s : this.getCreateColumnNamesCache(ntn)) {
            vl.put(s, varr[i++]);
        }
        if (i == 0) {
            throw new SQLException("Could not read metadata of table " + t.getName());
        }
        return this.escapeIdentifiers(vl, t);
    }

    public Object[] getValues(Map<String, Object> rowPattern, Table t) {
        Object[] values = new Object[rowPattern.size()];
        int i = 0;
        for (Object obj : rowPattern.values()) {
            values[i++] = obj;
        }
        return values;
    }

    public List<String> getCreateColumnNamesCache(String tableName) throws SQLException {
        String nname = SQLConverter.basicEscapingIdentifier(tableName).toUpperCase();
        nname = UcanaccessDatabaseMetadata.normalizeName(nname);
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        Map dbFileObjMap = COL_NAMES_CACHE.computeIfAbsent(conn.getDbIO().getFile(), k -> new LinkedHashMap());
        if (!dbFileObjMap.containsKey(nname)) {
            try (ResultSet rs = conn.getHSQLDBConnection().getMetaData().getColumns(null, "PUBLIC", nname, null);){
                TreeMap<Integer, String> colsByPos = new TreeMap<Integer, String>();
                while (rs.next()) {
                    Integer pos = rs.getInt("ORDINAL_POSITION");
                    String name = rs.getString("COLUMN_NAME");
                    colsByPos.put(pos, name.toUpperCase());
                }
                List colList = colsByPos.values().stream().collect(Collectors.toUnmodifiableList());
                dbFileObjMap.put(nname, colList);
            }
        }
        return (List)dbFileObjMap.get(nname);
    }

    private List<String> getColumnNamesCreate(String ntn) throws SQLException {
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        ArrayList<String> ar = new ArrayList<String>();
        ResultSet rs = conn.getMetaData().getColumns(null, "PUBLIC", ntn, null);
        while (rs.next()) {
            String cbase = rs.getString("COLUMN_NAME");
            ar.add(cbase);
        }
        return ar;
    }

    public void convertRowTypes(Object[] values, Table t) throws SQLException {
        try {
            List columns = t.getColumns();
            Iterator it = columns.iterator();
            for (int i = 0; i < values.length; ++i) {
                int vl;
                Object value = values[i];
                Column column = (Column)it.next();
                if (value == null) continue;
                if (value instanceof TimestampData && column.getType().equals((Object)DataType.SHORT_DATE_TIME)) {
                    TimestampData ts = (TimestampData)value;
                    LocalDateTime val = LocalDateTime.of(1970, 1, 1, 0, 0).plusSeconds(ts.getSeconds()).plusNanos(ts.getNanos());
                    values[i] = val;
                }
                if (value instanceof BlobData) {
                    BlobData bd = (BlobData)value;
                    JDBCConnection hsqlConn = (JDBCConnection)UcanaccessConnection.getCtxConnection().getHSQLDBConnection();
                    SessionInterface si = hsqlConn.getSession();
                    long length = bd.length(si);
                    values[i] = ((BlobData)value).getBytes(si, 0L, (int)length);
                }
                if (value instanceof JavaObjectData) {
                    JavaObjectData jod = (JavaObjectData)value;
                    Object obj = jod.getObject();
                    if (obj instanceof ComplexBase[] && !(obj instanceof UnsupportedValue[])) {
                        values[i] = obj;
                    } else {
                        throw new UnsupportedTypeException(Optional.ofNullable(obj).map(o -> o.getClass().getName()).orElse("null"));
                    }
                }
                if (!column.getType().equals((Object)DataType.BYTE) || (vl = ((Integer)value).intValue()) >= 0 && vl <= 256) continue;
                throw new SQLException("Data out of range");
            }
        }
        catch (Exception _ex) {
            throw new SQLException(_ex);
        }
    }

    private Map<String, Object> escapeIdentifiers(Map<String, Object> map, Table t) {
        List colums = t.getColumns();
        LinkedHashMap<String, Object> vl = new LinkedHashMap<String, Object>();
        for (Column col : colums) {
            String ekey;
            String key = col.getName();
            String keyu = key.toUpperCase();
            String string = ekey = map.containsKey(keyu) ? keyu : SQLConverter.escapeIdentifier(key).toUpperCase();
            if (!map.containsKey(ekey) && map.containsKey(ekey.substring(1, ekey.length() - 1))) {
                ekey = ekey.substring(1, ekey.length() - 1);
            }
            vl.put(key, map.get(ekey));
        }
        return vl;
    }

    private String getNormalizedName(String _name, Map<String, String> _columnMap) {
        return _columnMap == null ? _name : _columnMap.getOrDefault(_name, _name);
    }

    private ColumnBuilder getColumn(ResultSet _rs, int _seq, Map<String, String> _columnMap, String[] _types) throws SQLException, IOException {
        String name = _rs.getString("COLUMN_NAME");
        String nname = this.getNormalizedName(name, _columnMap);
        ColumnBuilder cb = new ColumnBuilder(nname);
        short length = (short)_rs.getInt("COLUMN_SIZE");
        byte scale = (byte)_rs.getInt("DECIMAL_DIGITS");
        DataType dt = null;
        if (length == 0 && _types != null) {
            if (_types[_seq].equalsIgnoreCase(TypesMap.AccessType.MEMO.name()) || _types[_seq].equalsIgnoreCase(TypesMap.AccessType.HYPERLINK.name())) {
                dt = DataType.MEMO;
                cb.withType(dt);
                if (_types[_seq].equalsIgnoreCase(TypesMap.AccessType.HYPERLINK.name())) {
                    cb.withHyperlink(true);
                }
            }
            if (_types[_seq].equalsIgnoreCase(TypesMap.AccessType.TEXT.name())) {
                dt = DataType.TEXT;
                cb.withType(dt);
            }
        }
        if (_types != null && _seq < _types.length && _types[_seq] != null && (_types[_seq].equalsIgnoreCase(TypesMap.AccessType.LONG.name()) || _types[_seq].equalsIgnoreCase(TypesMap.AccessType.BYTE.name()) || _types[_seq].equalsIgnoreCase(TypesMap.AccessType.CURRENCY.name()) || _types[_seq].equalsIgnoreCase(TypesMap.AccessType.INTEGER.name()) || _types[_seq].equalsIgnoreCase(TypesMap.AccessType.SINGLE.name()) || _types[_seq].equalsIgnoreCase(TypesMap.AccessType.DOUBLE.name()) || _types[_seq].equalsIgnoreCase(TypesMap.AccessType.YESNO.name()) || _types[_seq].equalsIgnoreCase(TypesMap.AccessType.DATETIME.name()) || _types[_seq].equalsIgnoreCase(TypesMap.AccessType.COUNTER.name()) || _types[_seq].equalsIgnoreCase(TypesMap.AccessType.AUTOINCREMENT.name()))) {
            dt = TypesMap.map2Jackcess(TypesMap.AccessType.valueOf(_types[_seq].toUpperCase(Locale.US)));
            cb.withType(dt).withLengthInUnits((int)((short)dt.getFixedSize()));
        }
        if (dt == null) {
            dt = _types != null && _seq < _types.length && _types[_seq] != null && _types[_seq].equalsIgnoreCase(TypesMap.AccessType.NUMERIC.name()) ? DataType.NUMERIC : DataType.fromSQLType((int)_rs.getInt("DATA_TYPE"), (int)length, (Database.FileFormat)UcanaccessConnection.getCtxConnection().getDbIO().getFileFormat());
            cb.withType(dt);
            if (length > 0 && dt.equals((Object)DataType.TEXT)) {
                cb.withLengthInUnits((int)length);
            }
            if (scale > 0) {
                cb.withScale((int)scale);
                if (length > 0) {
                    cb.withPrecision((int)length);
                }
            }
        }
        if (_types != null && _seq < _types.length) {
            if (_types[_seq].equalsIgnoreCase(TypesMap.AccessType.COUNTER.name()) || _types[_seq].equalsIgnoreCase(TypesMap.AccessType.AUTOINCREMENT.name())) {
                cb.withAutoNumber(true).withProperty("Required", (Object)false);
            }
            if (_types[_seq].equalsIgnoreCase(TypesMap.AccessType.GUID.name())) {
                cb.withType(DataType.GUID).withAutoNumber(true);
            }
        }
        return cb;
    }

    private ColumnBuilder getColumn(String _tableName, Map<String, String> _columnMap, String[] _types) throws SQLException, IOException {
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        String columnName = _columnMap.keySet().iterator().next();
        ResultSet rs = conn.getHSQLDBConnection().getMetaData().getColumns(null, "PUBLIC", _tableName.toUpperCase(), SQLConverter.preEscapingIdentifier(columnName));
        if (rs.next()) {
            return this.getColumn(rs, 0, _columnMap, _types);
        }
        return null;
    }

    private Collection<ColumnBuilder> getColumns(String tableName, Map<String, String> columnMap, String[] types) throws SQLException, IOException {
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        TreeMap<Integer, ColumnBuilder> ordm = new TreeMap<Integer, ColumnBuilder>();
        String tableNamePattern = tableName.toUpperCase(Locale.US).replace("_", "\\_");
        ResultSet rs = conn.getHSQLDBConnection().getMetaData().getColumns(null, "PUBLIC", tableNamePattern, null);
        while (rs.next()) {
            int seq = rs.getInt("ORDINAL_POSITION") - 1;
            ordm.put(seq, this.getColumn(rs, seq, columnMap, types));
        }
        return ordm.values();
    }

    private List<IndexBuilder> getIndexBuilders(String tableName, Map<String, String> columnMap) throws SQLException {
        ArrayList<IndexBuilder> arcl = new ArrayList<IndexBuilder>();
        this.addIndexBuildersSimple(tableName, columnMap, arcl);
        return arcl;
    }

    private void checkPK(List<IndexBuilder> _arcl, IndexBuilder _ibpk) {
        if (_ibpk == null) {
            return;
        }
        Iterator<IndexBuilder> itib = _arcl.iterator();
        List clspk = _ibpk.getColumns();
        ArrayList<String> columnNamesPK = new ArrayList<String>();
        for (IndexBuilder.Column clpk : clspk) {
            columnNamesPK.add(clpk.getName().toUpperCase());
        }
        while (itib.hasNext()) {
            IndexBuilder ib = itib.next();
            List cls = ib.getColumns();
            if (cls.size() != clspk.size()) continue;
            boolean clsPK = true;
            for (IndexBuilder.Column cl : cls) {
                if (columnNamesPK.contains(cl.getName().toUpperCase())) continue;
                clsPK = false;
                break;
            }
            if (!clsPK) continue;
            itib.remove();
        }
    }

    private IndexBuilder getIndexBuilderPK(String tableName, Map<String, String> columnMap) throws SQLException {
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        ResultSet pkrs = conn.getMetaData().getPrimaryKeys(null, "PUBLIC", tableName.toUpperCase());
        IndexBuilder indpk = null;
        while (pkrs.next()) {
            if (indpk == null) {
                String indexName = "PrimaryKey";
                indpk = new IndexBuilder(indexName).withPrimaryKey();
            }
            indpk.withColumns(new String[]{this.getNormalizedName(pkrs.getString("COLUMN_NAME"), columnMap)});
        }
        return indpk;
    }

    private void addIndexBuildersSimple(String tableName, Map<String, String> columnMap, List<IndexBuilder> arcl) throws SQLException {
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        ResultSet idxrs = conn.getMetaData().getIndexInfo(null, "PUBLIC", tableName, false, false);
        HashMap<String, IndexBuilder> hi = new HashMap<String, IndexBuilder>();
        for (IndexBuilder ib : arcl) {
            hi.put(ib.getName(), ib);
        }
        while (idxrs.next()) {
            boolean asc;
            String colName = this.getNormalizedName(idxrs.getString("COLUMN_NAME"), columnMap);
            String indexName = idxrs.getString("INDEX_NAME");
            boolean unique = !idxrs.getBoolean("NON_UNIQUE");
            String ad = idxrs.getString("ASC_OR_DESC");
            boolean bl = asc = ad == null || "A".equals(ad);
            if (!hi.containsKey(indexName)) {
                IndexBuilder ib = new IndexBuilder(indexName);
                if (unique) {
                    ib.withUnique();
                }
                arcl.add(ib);
                hi.put(indexName, ib);
            }
            IndexBuilder toIdx = (IndexBuilder)hi.get(indexName);
            toIdx.withColumns(asc, new String[]{colName});
        }
    }

    private void saveColumnsDefaults(String[] _defaults, Boolean[] _required, Column _cl, int _j) throws IOException {
        PropertyMap map = _cl.getProperties();
        if (_defaults != null && _j < _defaults.length && _defaults[_j] != null) {
            map.put("DefaultValue", DataType.TEXT, (Object)_defaults[_j]);
        }
        if (_required != null && _j < _required.length && _required[_j] != null && !_cl.isAutoNumber()) {
            map.put("Required", DataType.BOOLEAN, (Object)_required[_j]);
        }
        map.save();
    }

    private void saveColumnsDefaults(String[] defaults, Boolean[] required, Table table) throws IOException {
        List cols = table.getColumns();
        int j = 0;
        if (defaults != null || required != null) {
            for (Column col : cols) {
                this.saveColumnsDefaults(defaults, required, col, j);
                ++j;
            }
        }
    }

    private String escape4Hsqldb(String tn) {
        if (tn.startsWith("[") && tn.endsWith("]") || tn.startsWith("`") && tn.endsWith("`")) {
            tn = tn.substring(1, tn.length() - 1);
            return SQLConverter.preEscapingIdentifier(tn);
        }
        return tn;
    }

    private String escape4Access(String tn) {
        if (tn.startsWith("[") && tn.endsWith("]") || tn.startsWith("`") && tn.endsWith("`")) {
            return tn.substring(1, tn.length() - 1);
        }
        return tn;
    }

    private String getUcaMetadataTypeName(int colIdx, ColumnBuilder cb, String[] types) {
        String ucaMetadataTypeName = cb.getType().name();
        if (types != null && colIdx < types.length && types[colIdx].toUpperCase(Locale.US).equals("HYPERLINK")) {
            ucaMetadataTypeName = types[colIdx].toUpperCase(Locale.US);
        }
        return ucaMetadataTypeName;
    }

    public void createTable(String tableName, Map<String, String> columnMap, String[] types, String[] defaults, Boolean[] notNulls) throws IOException, SQLException {
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        Database db = conn.getDbIO();
        String tn = this.escape4Access(tableName);
        String ntn = this.escape4Hsqldb(tableName);
        Metadata mtd = new Metadata(conn.getHSQLDBConnection());
        TableBuilder tb = new TableBuilder(tn);
        int idTable = mtd.newTable(tn, ntn, ObjectType.TABLE);
        Collection<ColumnBuilder> lcb = this.getColumns(ntn, columnMap, types);
        tb.addColumns(lcb);
        int colIdx = 0;
        for (ColumnBuilder cb : lcb) {
            mtd.newColumn(cb.getName(), SQLConverter.preEscapingIdentifier(cb.getName()), this.getUcaMetadataTypeName(colIdx, cb, types), idTable);
            ++colIdx;
        }
        List<IndexBuilder> arcl = this.getIndexBuilders(ntn, columnMap);
        IndexBuilder ibpk = this.getIndexBuilderPK(ntn, columnMap);
        this.checkPK(arcl, ibpk);
        if (ibpk != null) {
            arcl.add(ibpk);
        }
        for (IndexBuilder ixb : arcl) {
            tb.addIndex(ixb);
        }
        Table table = tb.toTable(db);
        this.saveColumnsDefaults(defaults, notNulls, table);
        LoadJet lj = new LoadJet(conn.getHSQLDBConnection(), db);
        lj.loadDefaultValues(table);
        this.createForeignKeys(tableName);
        try (UcanaccessStatement st = conn.createStatement();){
            ResultSet rs = st.executeQuery(String.format("SELECT * FROM %s", tableName));
            List<String> clns = this.getColumnNamesCreate(tn);
            while (rs.next()) {
                Object[] rec = new Object[clns.size()];
                int i = 0;
                for (String columnName : clns) {
                    rec[i++] = rs.getObject(columnName);
                }
                new InsertCommand(table, rec, null).persist();
            }
        }
    }

    public void dropTable(String tableName) throws IOException, SQLException {
        Row row;
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        Database db = conn.getDbIO();
        Table t = db.getTable(tableName = this.escape4Access(tableName));
        if (t == null) {
            return;
        }
        Metadata mt = new Metadata(conn.getHSQLDBConnection());
        mt.dropTable(t.getName());
        if (!HibernateSupport.isActive()) {
            Cursor c = t.getDefaultCursor();
            while (c.getNextRow() != null) {
                c.deleteCurrentRow();
            }
        }
        DatabaseImpl dbi = (DatabaseImpl)db;
        TableImpl cat = dbi.getSystemCatalog();
        Cursor catc = cat.getDefaultCursor();
        while ((row = catc.getNextRow()) != null) {
            String name = (String)row.get("Name");
            if (name == null || !name.equalsIgnoreCase(tableName)) continue;
            Integer id = (Integer)row.get("Id");
            Table tsa = db.getSystemTable("MSysACEs");
            HashMap<String, Integer> rowtsa = new HashMap<String, Integer>();
            rowtsa.put("ObjectId", id);
            Cursor cur = tsa.getDefaultCursor();
            if (cur.findNextRow(rowtsa)) {
                cur.deleteCurrentRow();
            }
            catc.deleteCurrentRow();
            Table srs = db.getSystemTable("MSysRelationships");
            Cursor srsc = srs.getDefaultCursor();
            while ((row = srsc.getNextRow()) != null) {
                String szObject = (String)row.get("szObject");
                String szReferencedObject = (String)row.get("szReferencedObject");
                if ((szObject == null || !szObject.equalsIgnoreCase(tableName)) && (szReferencedObject == null || !szReferencedObject.equalsIgnoreCase(tableName))) continue;
                srsc.deleteCurrentRow();
            }
        }
        conn.reloadDbIO();
    }

    public void renameTable(String oldTableName, String newTableName) throws IOException, SQLException {
        Row row;
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        Database db = conn.getDbIO();
        oldTableName = this.escape4Access(oldTableName);
        String tn = this.escape4Access(newTableName);
        String ntn = this.escape4Hsqldb(newTableName);
        Table t = db.getTable(oldTableName);
        if (t == null) {
            return;
        }
        Metadata mt = new Metadata(conn.getHSQLDBConnection());
        mt.rename(t.getName(), tn, ntn);
        DatabaseImpl dbi = (DatabaseImpl)db;
        TableImpl cat = dbi.getSystemCatalog();
        Cursor catc = cat.getDefaultCursor();
        while ((row = catc.getNextRow()) != null) {
            String name = (String)row.get("Name");
            if (name == null || !name.equalsIgnoreCase(oldTableName)) continue;
            Integer id = (Integer)row.get("Id");
            HashMap<String, Integer> rowtsa = new HashMap<String, Integer>();
            rowtsa.put("ObjectId", id);
            Row r = catc.getCurrentRow();
            r.put((Object)"Name", (Object)tn);
            catc.updateCurrentRowFromMap((Map)r);
            Table srs = db.getSystemTable("MSysRelationships");
            Cursor srsc = srs.getDefaultCursor();
            while ((row = srsc.getNextRow()) != null) {
                String szObject = (String)row.get("szObject");
                String szReferencedObject = (String)row.get("szReferencedObject");
                boolean updated = false;
                if (szObject != null && szObject.equalsIgnoreCase(oldTableName)) {
                    row.put("szObject", tn);
                    updated = true;
                }
                if (szReferencedObject != null && szReferencedObject.equalsIgnoreCase(oldTableName)) {
                    row.put("szReferencedObject", tn);
                    updated = true;
                }
                if (!updated) continue;
                srsc.updateCurrentRowFromMap((Map)row);
            }
        }
        conn.reloadDbIO();
    }

    public void addColumn(String _tableName, String _columnName, Map<String, String> _columnMap, String[] _types, String[] _defaults, Boolean[] _notNulls) throws IOException, SQLException {
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        Database db = conn.getDbIO();
        String tn = this.escape4Access(_tableName);
        String ntn = this.escape4Hsqldb(_tableName);
        Metadata mtd = new Metadata(conn.getHSQLDBConnection());
        ColumnBuilder cb = this.getColumn(ntn, _columnMap, _types);
        if (cb == null) {
            return;
        }
        Table t = db.getTable(tn);
        Column col = cb.addToTable(t);
        int idTable = mtd.getTableId(ntn.toUpperCase());
        mtd.newColumn(cb.getName(), SQLConverter.preEscapingIdentifier(cb.getName()), this.getUcaMetadataTypeName(0, cb, _types), idTable);
        this.saveColumnsDefaults(_defaults, _notNulls, col, 0);
        this.updateNewColumnToDefault(_tableName, _columnName, t, col);
        this.setHsqldbNotNull(_tableName, _columnName, col);
        conn.reloadDbIO();
    }

    private void setHsqldbNotNull(String _tableName, String _columnName, Column _cl) throws SQLException, IOException {
        boolean req = Optional.ofNullable(_cl.getProperties().getValue("Required")).map(Boolean.class::cast).orElse(false);
        if (req) {
            UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
            try (Statement stNN = conn.getHSQLDBConnection().createStatement();){
                stNN.execute(SQLConverter.convertSQL("ALTER TABLE " + _tableName + " ALTER COLUMN " + _columnName + " SET NOT NULL ").getSql());
            }
        }
    }

    private void updateNewColumnToDefault(String _tableName, String _columnName, Table t, Column _col) throws SQLException, IOException {
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        LoadJet lj = new LoadJet(conn.getHSQLDBConnection(), conn.getDbIO());
        lj.loadDefaultValues(_col);
        String default4SQL = lj.defaultValue4SQL(_col);
        Object defObj = lj.tryDefault(default4SQL);
        conn.setFeedbackState(true);
        if (default4SQL != null) {
            for (Row row : t) {
                row.put((Object)_col.getName(), defObj);
                t.updateRow(row);
            }
            conn.getDbIO().flush();
        }
        if (default4SQL != null || _col.getType().equals((Object)DataType.BOOLEAN)) {
            defObj = default4SQL == null && _col.getType().equals((Object)DataType.BOOLEAN) ? Boolean.FALSE : defObj;
            try (PreparedStatement ps = conn.getHSQLDBConnection().prepareStatement(SQLConverter.convertSQL("UPDATE " + _tableName + " SET " + _columnName + "= ?").getSql());){
                ps.setObject(1, defObj);
                ps.executeUpdate();
            }
        }
        conn.setFeedbackState(false);
    }

    public void createIndex(String tableName, String indexName) throws IOException, SQLException {
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        Database db = conn.getDbIO();
        String ntn = this.escape4Hsqldb(tableName);
        String idn = this.escape4Hsqldb(indexName);
        String tn = this.escape4Access(tableName);
        String in = this.escape4Access(indexName);
        Table t = db.getTable(tn);
        ResultSet idxrs = conn.getHSQLDBConnection().getMetaData().getIndexInfo(null, "PUBLIC", ntn.toUpperCase(), false, false);
        boolean asc = false;
        ArrayList<String> cols = new ArrayList<String>();
        IndexBuilder ib = new IndexBuilder(in);
        while (idxrs.next()) {
            boolean unique;
            String dbIdxName = idxrs.getString("INDEX_NAME");
            if (!dbIdxName.equalsIgnoreCase(idn)) continue;
            boolean bl = unique = !idxrs.getBoolean("NON_UNIQUE");
            if (unique) {
                ib.withUnique();
            }
            String colName = idxrs.getString("COLUMN_NAME");
            Metadata mt = new Metadata(conn);
            colName = mt.getColumnName(ntn, colName);
            String ad = idxrs.getString("ASC_OR_DESC");
            asc = ad == null || "A".equals(ad);
            cols.add(colName);
        }
        ib.withColumns(asc, cols.toArray(new String[0])).addToTable(t);
    }

    public void createPrimaryKey(String tableName) throws IOException, SQLException {
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        String ntn = this.escape4Hsqldb(tableName);
        Table t = conn.getDbIO().getTable(this.escape4Access(tableName));
        Metadata md = new Metadata(conn);
        TreeMap<Short, String> cols = new TreeMap<Short, String>();
        try (ResultSet rs = conn.getHSQLDBConnection().getMetaData().getPrimaryKeys(null, null, ntn.toUpperCase());){
            while (rs.next()) {
                cols.put(rs.getShort("KEY_SEQ"), md.getColumnName(ntn, rs.getString("COLUMN_NAME")));
            }
        }
        new IndexBuilder("PrimaryKey").withPrimaryKey().withColumns(cols.values()).addToTable(t);
    }

    public void createForeignKey(String tableName, String referencedTable) throws IOException, SQLException {
        this.createForeignKey(tableName, referencedTable, null);
    }

    public void createForeignKey(String tableName, String referencedTable, String relationshipName) throws IOException, SQLException {
        String ntn = this.escape4Hsqldb(tableName);
        String rntn = this.escape4Hsqldb(referencedTable);
        String tn = this.escape4Access(tableName);
        String rtn = this.escape4Access(referencedTable);
        String relName = null;
        if (relationshipName != null) {
            relName = this.escape4Access(relationshipName);
        }
        this.createForeignKey(ntn, rntn, tn, rtn, relName);
    }

    public void createForeignKeys(String tableName) throws IOException, SQLException {
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        String ntn = this.escape4Hsqldb(tableName);
        String tn = this.escape4Access(tableName);
        ResultSet fkrs = conn.getHSQLDBConnection().getMetaData().getImportedKeys(null, null, ntn.toUpperCase());
        HashSet<String> hs = new HashSet<String>();
        while (fkrs.next()) {
            hs.add(fkrs.getString("PKTABLE_NAME"));
        }
        Metadata mt = new Metadata(conn);
        for (String rntn : hs) {
            this.createForeignKey(ntn, rntn, tn, mt.getTableName(rntn), null);
        }
    }

    private void createForeignKey(String tn4Hsqldb, String refTn4Hsqldb, String tn4Access, String refTn4Access, String relationshipName) throws IOException, SQLException {
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        Database db = conn.getDbIO();
        Table t = db.getTable(tn4Access);
        Table rt = db.getTable(refTn4Access);
        RelationshipBuilder rb = new RelationshipBuilder(rt, t).withName(relationshipName).withReferentialIntegrity();
        ResultSet fkrs = conn.getHSQLDBConnection().getMetaData().getCrossReference(null, null, refTn4Hsqldb.toUpperCase(), null, null, tn4Hsqldb.toUpperCase());
        Metadata mt = new Metadata(conn);
        while (fkrs.next()) {
            if (relationshipName != null && !fkrs.getString("FK_NAME").equalsIgnoreCase(tn4Hsqldb + "_" + relationshipName)) continue;
            String colName = fkrs.getString("FKCOLUMN_NAME");
            colName = mt.getColumnName(tn4Hsqldb, colName);
            String rcolName = fkrs.getString("PKCOLUMN_NAME");
            rcolName = mt.getColumnName(refTn4Hsqldb, rcolName);
            rb.addColumns(rcolName, colName);
            short dr = fkrs.getShort("DELETE_RULE");
            short ur = fkrs.getShort("UPDATE_RULE");
            switch (dr) {
                case 0: {
                    rb.withCascadeDeletes();
                    break;
                }
                case 2: {
                    rb.withCascadeNullOnDelete();
                    break;
                }
            }
            if (ur != 0) continue;
            rb.withCascadeUpdates();
        }
        rb.toRelationship(db);
    }

    public void dropForeignKey(String relationshipName) throws IOException {
        relationshipName = this.escape4Access(relationshipName);
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        Database db = conn.getDbIO();
        Table tbl = db.getSystemTable("MSysRelationships");
        IndexCursor crsr = CursorBuilder.createCursor((Index)tbl.getIndex("szRelationship"));
        Row r = crsr.findRowByEntry(new Object[]{relationshipName});
        if (r != null) {
            while (r != null) {
                tbl.deleteRow(r);
                r = crsr.findRowByEntry(new Object[]{relationshipName});
            }
            tbl = db.getSystemTable("MSysObjects");
            crsr = CursorBuilder.createCursor((Index)tbl.getIndex("ParentIdName"));
            HashMap<String, Object> rowPattern = new HashMap<String, Object>();
            rowPattern.put("Name", "Relationships");
            rowPattern.put("Type", 3);
            if (crsr.findFirstRow(rowPattern)) {
                Integer relationshipsId = crsr.getCurrentRow().getInt("Id");
                r = crsr.findRowByEntry(new Object[]{relationshipsId, relationshipName});
                if (r != null) {
                    Integer relationshipId = r.getInt("Id");
                    tbl.deleteRow(r);
                    tbl = db.getSystemTable("MSysACEs");
                    crsr = CursorBuilder.createCursor((Index)tbl.getIndex("ObjectId"));
                    r = crsr.findRowByEntry(new Object[]{relationshipId});
                    while (r != null) {
                        tbl.deleteRow(r);
                        r = crsr.findRowByEntry(new Object[]{relationshipId});
                    }
                }
            }
        }
    }

    static {
        DBReference.addOnReloadRefListener(COL_NAMES_CACHE::clear);
    }
}

