/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.triggers;

import io.github.spannm.jackcess.Column;
import io.github.spannm.jackcess.impl.ColumnImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.ucanaccess.jdbc.DBReference;

public final class AutoNumberManager {
    private static final Map<Column, AtomicInteger> REGISTER = new HashMap<Column, AtomicInteger>();

    private AutoNumberManager() {
    }

    static synchronized void clear() {
        REGISTER.clear();
    }

    static synchronized int getNext(Column _col) {
        ColumnImpl col = (ColumnImpl)_col;
        AtomicInteger next = REGISTER.get(col);
        if (next == null) {
            next = new AtomicInteger((Integer)col.getAutoNumberGenerator().getLast());
            REGISTER.put((Column)col, next);
        }
        return next.incrementAndGet();
    }

    public static synchronized void reset(Column _col, int _newVal) {
        REGISTER.put(_col, new AtomicInteger(_newVal));
    }

    public static synchronized void bump(Column _col, int _newVal) {
        ColumnImpl col = (ColumnImpl)_col;
        AtomicInteger next = REGISTER.get(col);
        if (next == null) {
            next = new AtomicInteger((Integer)col.getAutoNumberGenerator().getLast());
            REGISTER.put((Column)col, next);
        }
        if (_newVal > next.get()) {
            next.set(_newVal);
        }
    }

    static {
        DBReference.addOnReloadRefListener(AutoNumberManager::clear);
    }
}

