/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.netpreserve.jwarc.MessageBody;

class DigestingMessageBody
extends MessageBody {
    private final MessageBody body;
    private final MessageDigest digest;

    DigestingMessageBody(MessageBody digestedBody, MessageDigest digest) {
        this.body = digestedBody;
        this.digest = digest;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int i = this.body.read(dst);
        if (i > 0) {
            ByteBuffer tmp = dst.duplicate();
            tmp.position(dst.position() - i);
            tmp.limit(dst.position());
            this.digest.update(tmp);
        }
        return i;
    }

    @Override
    public boolean isOpen() {
        return this.body.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.body.close();
    }

    @Override
    public long position() throws IOException {
        return this.body.position();
    }

    public MessageDigest getDigest() {
        return this.digest;
    }

    @Override
    public long size() throws IOException {
        return this.body.size();
    }
}

