/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.netpreserve.jwarc.MessageParser;
import org.netpreserve.jwarc.ParsingException;

public class GeminiParser
extends MessageParser {
    private int initialState;
    private int cs;
    private long position;
    private boolean finished;
    private byte[] buf = new byte[256];
    private int bufPos = 0;
    private int status;
    private String meta;
    private String url;
    private static final byte[] _gemini_actions = GeminiParser.init__gemini_actions_0();
    private static final byte[] _gemini_key_offsets = GeminiParser.init__gemini_key_offsets_0();
    private static final char[] _gemini_trans_keys = GeminiParser.init__gemini_trans_keys_0();
    private static final byte[] _gemini_single_lengths = GeminiParser.init__gemini_single_lengths_0();
    private static final byte[] _gemini_range_lengths = GeminiParser.init__gemini_range_lengths_0();
    private static final byte[] _gemini_index_offsets = GeminiParser.init__gemini_index_offsets_0();
    private static final byte[] _gemini_trans_targs = GeminiParser.init__gemini_trans_targs_0();
    private static final byte[] _gemini_trans_actions = GeminiParser.init__gemini_trans_actions_0();
    static final int gemini_start = 1;
    static final int gemini_first_final = 8;
    static final int gemini_error = 0;
    static final int gemini_en_gemini_request = 6;
    static final int gemini_en_gemini_response = 1;

    public GeminiParser() {
        this.reset();
    }

    public void reset() {
        this.cs = 1;
        this.bufPos = 0;
        if (this.buf.length > 8192) {
            this.buf = new byte[256];
        }
        this.status = 0;
        this.meta = null;
        this.url = null;
        this.position = 0L;
        this.finished = false;
        this.cs = this.initialState;
    }

    public int status() {
        return this.status;
    }

    public String meta() {
        return this.meta;
    }

    public String url() {
        return this.url;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isError() {
        return this.cs == 0;
    }

    public void strictRequest() {
        this.initialState = this.cs = 6;
    }

    public void strictResponse() {
        this.initialState = this.cs = 1;
    }

    /*
     * Unable to fully structure code
     */
    public void parse(ByteBuffer data) throws ParsingException {
        if (data == null) {
            p = 0;
            pe = 0;
            eof = 0;
        } else {
            p = data.position();
            pe = data.limit();
            eof = -1;
        }
        _trans = 0;
        _goto_targ = 0;
        block12: while (true) {
            switch (_goto_targ) {
                case 0: {
                    if (p == pe) {
                        _goto_targ = 4;
                        continue block12;
                    }
                    if (this.cs == 0) {
                        _goto_targ = 5;
                        continue block12;
                    }
                }
                case 1: {
                    _keys = GeminiParser._gemini_key_offsets[this.cs];
                    _trans = GeminiParser._gemini_index_offsets[this.cs];
                    _klen = GeminiParser._gemini_single_lengths[this.cs];
                    if (_klen <= 0) ** GOTO lbl39
                    _lower = _keys;
                    _upper = _keys + _klen - 1;
                    while (_upper >= _lower) {
                        _mid = _lower + (_upper - _lower >> 1);
                        if ((data.get(p) & 255) < GeminiParser._gemini_trans_keys[_mid]) {
                            _upper = _mid - 1;
                            continue;
                        }
                        if ((data.get(p) & 255) > GeminiParser._gemini_trans_keys[_mid]) {
                            _lower = _mid + 1;
                            continue;
                        }
                        _trans += _mid - _keys;
                        ** GOTO lbl53
                    }
                    _keys += _klen;
                    _trans += _klen;
lbl39:
                    // 2 sources

                    if ((_klen = GeminiParser._gemini_range_lengths[this.cs]) > 0) {
                        _lower = _keys;
                        _upper = _keys + (_klen << 1) - 2;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1 & -2);
                            if ((data.get(p) & 255) < GeminiParser._gemini_trans_keys[_mid]) {
                                _upper = _mid - 2;
                                continue;
                            }
                            if ((data.get(p) & 255) > GeminiParser._gemini_trans_keys[_mid + 1]) {
                                _lower = _mid + 2;
                                continue;
                            }
                            _trans += _mid - _keys >> 1;
                            ** GOTO lbl53
                        }
                        _trans += _klen;
                    }
lbl53:
                    // 5 sources

                    this.cs = GeminiParser._gemini_trans_targs[_trans];
                    if (GeminiParser._gemini_trans_actions[_trans] != 0) {
                        _acts = GeminiParser._gemini_trans_actions[_trans];
                        _nacts = GeminiParser._gemini_actions[_acts++];
                        while (_nacts-- > 0) {
                            switch (GeminiParser._gemini_actions[_acts++]) {
                                case 0: {
                                    this.push(data.get(p));
                                    break;
                                }
                                case 1: {
                                    this.status = this.status * 10 + data.get(p) - 48;
                                    break;
                                }
                                case 2: {
                                    this.meta = new String(this.buf, 0, this.bufPos, StandardCharsets.UTF_8);
                                    this.bufPos = 0;
                                    break;
                                }
                                case 3: {
                                    this.url = new String(this.buf, 0, this.bufPos, StandardCharsets.UTF_8);
                                    this.bufPos = 0;
                                    break;
                                }
                                case 4: {
                                    this.finished = true;
                                    ++p;
                                    _goto_targ = 5;
                                    continue block12;
                                }
                            }
                        }
                    }
                }
                case 2: {
                    if (this.cs == 0) {
                        _goto_targ = 5;
                        continue block12;
                    }
                    if (++p == pe) break block12;
                    _goto_targ = 1;
                    continue block12;
                }
            }
            break;
        }
        if (data != null) {
            this.position += (long)(p - data.position());
            data.position(p);
        }
    }

    public void parse(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        this.parse(channel, buffer, null);
    }

    void parse(ReadableByteChannel channel, ByteBuffer buffer, WritableByteChannel copyTo) throws IOException {
        block3: {
            int n;
            do {
                ByteBuffer copy = buffer.duplicate();
                long buffOffset = (long)buffer.position() - this.position;
                this.parse(buffer);
                if (copyTo != null) {
                    copy.limit(buffer.position());
                    copyTo.write(copy);
                }
                if (this.isFinished()) break block3;
                if (this.isError()) {
                    throw new ParsingException("invalid gemini message at byte position " + this.position + ": " + GeminiParser.getErrorContext(buffer.duplicate(), (int)(buffOffset + this.position), 40));
                }
                buffer.compact();
                n = channel.read(buffer);
                buffer.flip();
            } while (n >= 0);
            this.parse(null);
        }
    }

    private void push(byte b) throws ParsingException {
        if (this.bufPos >= 1024) {
            throw new ParsingException("gemini header field longer than 1024 bytes");
        }
        if (this.bufPos >= this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, this.buf.length * 2);
        }
        this.buf[this.bufPos++] = b;
    }

    private static byte[] init__gemini_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4};
    }

    private static byte[] init__gemini_key_offsets_0() {
        return new byte[]{0, 0, 2, 4, 5, 7, 8, 10, 11, 11};
    }

    private static char[] init__gemini_trans_keys_0() {
        return new char[]{'0', '9', '0', '9', ' ', '\n', '\r', '\n', '\n', '\r', '\n', '\u0000'};
    }

    private static byte[] init__gemini_single_lengths_0() {
        return new byte[]{0, 0, 0, 1, 2, 1, 2, 1, 0, 0};
    }

    private static byte[] init__gemini_range_lengths_0() {
        return new byte[]{0, 1, 1, 0, 0, 0, 0, 0, 0, 0};
    }

    private static byte[] init__gemini_index_offsets_0() {
        return new byte[]{0, 0, 2, 4, 6, 9, 11, 14, 16, 17};
    }

    private static byte[] init__gemini_trans_targs_0() {
        return new byte[]{2, 0, 3, 0, 4, 0, 0, 5, 4, 8, 0, 0, 7, 6, 9, 0, 0, 0, 0};
    }

    private static byte[] init__gemini_trans_actions_0() {
        return new byte[]{3, 0, 3, 0, 0, 0, 0, 5, 1, 9, 0, 0, 7, 1, 9, 0, 0, 0, 0};
    }
}

