/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netpreserve.jwarc.FetchOptions;
import org.netpreserve.jwarc.FetchResult;
import org.netpreserve.jwarc.GzipChannel;
import org.netpreserve.jwarc.HttpRequest;
import org.netpreserve.jwarc.HttpResponse;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.WarcCompression;
import org.netpreserve.jwarc.WarcRecord;

public class WarcWriter
implements Closeable {
    private static final byte[] TRAILER = new byte[]{13, 10, 13, 10};
    private final WritableByteChannel channel;
    private final WarcCompression compression;
    private final ByteBuffer buffer = ByteBuffer.allocate(8192);
    private final String digestAlgorithm = "SHA-1";
    private final AtomicLong position = new AtomicLong(0L);
    private final Set<Socket> fetchSockets = Collections.synchronizedSet(new HashSet());
    private final ReadWriteLock closeLock = new ReentrantReadWriteLock();
    private volatile boolean closing = false;

    public WarcWriter(WritableByteChannel channel, WarcCompression compression) throws IOException {
        this.compression = compression;
        this.channel = compression == WarcCompression.GZIP ? new GzipChannel(channel) : channel;
        if (channel instanceof SeekableByteChannel) {
            this.position.set(((SeekableByteChannel)channel).position());
        }
    }

    public WarcWriter(WritableByteChannel channel) throws IOException {
        this(channel, WarcCompression.NONE);
    }

    public WarcWriter(OutputStream stream) throws IOException {
        this(Channels.newChannel(stream));
    }

    public WarcWriter(Path path) throws IOException {
        this(FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), WarcCompression.forPath(path));
    }

    public synchronized void write(WarcRecord record) throws IOException {
        this.position.addAndGet(this.channel.write(ByteBuffer.wrap(record.serializeHeader())));
        MessageBody body = record.body();
        while (body.read(this.buffer) >= 0) {
            this.buffer.flip();
            this.position.addAndGet(this.channel.write(this.buffer));
            this.buffer.compact();
        }
        this.position.addAndGet(this.channel.write(ByteBuffer.wrap(TRAILER)));
        if (this.compression == WarcCompression.GZIP) {
            ((GzipChannel)this.channel).finish();
            this.position.set(((GzipChannel)this.channel).outputPosition());
        }
    }

    public FetchResult fetch(URI uri) throws IOException {
        return this.fetch(uri, new FetchOptions());
    }

    public FetchResult fetch(URI uri, FetchOptions options) throws IOException {
        HttpRequest httpRequest = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)new HttpRequest.Builder("GET", uri).version(MessageVersion.HTTP_1_0)).addHeader("User-Agent", options.userAgent)).addHeader("Connection", "close")).build();
        return this.fetch(uri, httpRequest, options);
    }

    public FetchResult fetch(URI uri, HttpRequest httpRequest, OutputStream copyTo) throws IOException {
        return this.fetch(uri, httpRequest, new FetchOptions().copyTo(copyTo));
    }

    /*
     * Exception decompiling
     */
    public FetchResult fetch(URI uri, HttpRequest httpRequest, FetchOptions options) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private MessageDigest tryCalculatingPayloadDigest(FileChannel channel) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        try {
            int n;
            HttpResponse httpResponse = HttpResponse.parse(channel);
            byte[] buffer = new byte[8192];
            InputStream steam = httpResponse.body().stream();
            long payloadLength = 0L;
            while ((n = steam.read(buffer)) >= 0) {
                digest.update(buffer, 0, n);
                payloadLength += (long)n;
            }
            if (payloadLength == 0L) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return digest;
    }

    public long position() {
        return this.position.get();
    }

    @Override
    public void close() throws IOException {
        this.closing = true;
        for (Socket socket : this.fetchSockets) {
            socket.close();
        }
        this.closeLock.writeLock().lock();
        try {
            this.channel.close();
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
    }
}

