/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fieldschangesequence;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.fieldschangesequence.FieldsChangeSequenceField;
import org.apache.hop.pipeline.transforms.fieldschangesequence.FieldsChangeSequenceMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageDialogWithToggle;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FieldsChangeSequenceDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = FieldsChangeSequenceMeta.class;
    private final FieldsChangeSequenceMeta input;
    private TextVar wStart;
    private TextVar wIncrement;
    private TableView wFields;
    private Text wResult;
    private final List<String> inputFields = new ArrayList<String>();
    private ColumnInfo[] colinf;
    public static final String STRING_CHANGE_SEQUENCE_WARNING_PARAMETER = "ChangeSequenceSortWarning";

    public FieldsChangeSequenceDialog(Shell parent, IVariables variables, FieldsChangeSequenceMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlResult = new Label((Composite)this.shell, 131072);
        wlResult.setText(BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.Result.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlResult);
        FormData fdlResult = new FormData();
        fdlResult.left = new FormAttachment(0, 0);
        fdlResult.right = new FormAttachment(middle, -margin);
        fdlResult.top = new FormAttachment((Control)this.wTransformName, 2 * margin);
        wlResult.setLayoutData((Object)fdlResult);
        this.wResult = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wResult);
        this.wResult.addModifyListener(lsMod);
        FormData fdResult = new FormData();
        fdResult.left = new FormAttachment(middle, 0);
        fdResult.top = new FormAttachment((Control)this.wTransformName, 2 * margin);
        fdResult.right = new FormAttachment(100, 0);
        this.wResult.setLayoutData((Object)fdResult);
        Label wlStart = new Label((Composite)this.shell, 131072);
        wlStart.setText(BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.Start.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlStart);
        FormData fdlStart = new FormData();
        fdlStart.left = new FormAttachment(0, 0);
        fdlStart.right = new FormAttachment(middle, -margin);
        fdlStart.top = new FormAttachment((Control)this.wResult, margin);
        wlStart.setLayoutData((Object)fdlStart);
        this.wStart = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wStart);
        FormData fdStart = new FormData();
        fdStart.left = new FormAttachment(middle, 0);
        fdStart.top = new FormAttachment((Control)this.wResult, margin);
        fdStart.right = new FormAttachment(100, 0);
        this.wStart.setLayoutData((Object)fdStart);
        Label wlIncrement = new Label((Composite)this.shell, 131072);
        wlIncrement.setText(BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.Increment.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIncrement);
        FormData fdlIncrement = new FormData();
        fdlIncrement.left = new FormAttachment(0, 0);
        fdlIncrement.right = new FormAttachment(middle, -margin);
        fdlIncrement.top = new FormAttachment((Control)this.wStart, margin);
        wlIncrement.setLayoutData((Object)fdlIncrement);
        this.wIncrement = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wIncrement);
        FormData fdIncrement = new FormData();
        fdIncrement.left = new FormAttachment(middle, 0);
        fdIncrement.top = new FormAttachment((Control)this.wStart, margin);
        fdIncrement.right = new FormAttachment(100, 0);
        this.wIncrement.setLayoutData((Object)fdIncrement);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wIncrement, margin);
        wlFields.setLayoutData((Object)fdlFields);
        boolean FieldsCols = true;
        int FieldsRows = this.input.getFields().size();
        this.colinf = new ColumnInfo[1];
        this.colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.Fieldname.Column", (String[])new String[0]), 2, new String[]{""}, false);
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, this.colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.wGet.addListener(13, e -> this.get());
        this.getData();
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    if (row != null) {
                        for (int i = 0; i < row.size(); ++i) {
                            this.inputFields.add(row.getValueMeta(i).getName());
                        }
                        this.setComboBoxes();
                    }
                    display.asyncExec(() -> {
                        if (!this.wFields.isDisposed()) {
                            for (int i = 0; i < this.wFields.table.getItemCount(); ++i) {
                                TableItem it = this.wFields.table.getItem(i);
                                if (Utils.isEmpty((CharSequence)it.getText(1)) || this.inputFields.contains(it.getText(1))) continue;
                                it.setBackground(GuiResource.getInstance().getColorRed());
                            }
                        }
                    });
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.ErrorGettingPreviousFields", (String[])new String[]{e.getMessage()}));
                }
            }
        };
        new Thread(runnable).start();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.colinf[0].setComboValues(fieldNames);
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener insertListener = (tableItem, v) -> {
                    tableItem.setText(2, BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]));
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)insertListener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void getData() {
        this.wStart.setText(Const.NVL((String)this.input.getStart(), (String)"1"));
        this.wIncrement.setText(Const.NVL((String)this.input.getIncrement(), (String)"1"));
        this.wResult.setText(Const.NVL((String)this.input.getResultFieldName(), (String)"result"));
        Table table = this.wFields.table;
        if (!this.input.getFields().isEmpty()) {
            table.removeAll();
        }
        List<FieldsChangeSequenceField> fields = this.input.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            TableItem ti = new TableItem(table, 0);
            ti.setText(0, "" + (i + 1));
            ti.setText(1, fields.get(i).getName());
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setStart(this.wStart.getText());
        this.input.setIncrement(this.wIncrement.getText());
        this.input.setResultFieldName(this.wResult.getText());
        int nrFields = this.wFields.nrNonEmpty();
        ArrayList<FieldsChangeSequenceField> fieldName = new ArrayList<FieldsChangeSequenceField>();
        for (int i = 0; i < nrFields; ++i) {
            TableItem ti = this.wFields.getNonEmpty(i);
            fieldName.add(new FieldsChangeSequenceField(ti.getText(1)));
        }
        this.input.setFields(fieldName);
        if ("Y".equalsIgnoreCase(this.props.getCustomParameter(STRING_CHANGE_SEQUENCE_WARNING_PARAMETER, "Y"))) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.InputNeedSort.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.InputNeedSort.DialogMessage", (String[])new String[]{Const.CR}) + Const.CR, 8, new String[]{BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.InputNeedSort.Option1", (String[])new String[0])}, BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.InputNeedSort.Option2", (String[])new String[0]), "N".equalsIgnoreCase(this.props.getCustomParameter(STRING_CHANGE_SEQUENCE_WARNING_PARAMETER, "Y")));
            md.open();
            this.props.setCustomParameter(STRING_CHANGE_SEQUENCE_WARNING_PARAMETER, md.getToggleState() ? "N" : "Y");
        }
        this.dispose();
    }
}

