/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.PrepareRequest;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultPrepareRequest
implements PrepareRequest {
    private final SimpleStatement statement;

    public DefaultPrepareRequest(SimpleStatement statement) {
        this.statement = statement;
    }

    public DefaultPrepareRequest(String query) {
        this.statement = SimpleStatement.newInstance(query);
    }

    @Override
    @NonNull
    public String getQuery() {
        return this.statement.getQuery();
    }

    @Override
    @Nullable
    public String getExecutionProfileName() {
        return this.statement.getExecutionProfileName();
    }

    @Override
    @Nullable
    public DriverExecutionProfile getExecutionProfile() {
        return this.statement.getExecutionProfile();
    }

    @Override
    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.statement.getKeyspace();
    }

    @Override
    @Nullable
    public CqlIdentifier getRoutingKeyspace() {
        return null;
    }

    @Override
    @Nullable
    public ByteBuffer getRoutingKey() {
        return null;
    }

    @Override
    @Nullable
    public Token getRoutingToken() {
        return null;
    }

    @Override
    @NonNull
    public Map<String, ByteBuffer> getCustomPayload() {
        return this.statement.getCustomPayload();
    }

    @Override
    @Nullable
    public Duration getTimeout() {
        return null;
    }

    @Override
    @Nullable
    public String getExecutionProfileNameForBoundStatements() {
        return this.statement.getExecutionProfileName();
    }

    @Override
    @Nullable
    public DriverExecutionProfile getExecutionProfileForBoundStatements() {
        return this.statement.getExecutionProfile();
    }

    @Override
    @Nullable
    public CqlIdentifier getRoutingKeyspaceForBoundStatements() {
        return this.statement.getKeyspace() != null ? this.statement.getKeyspace() : this.statement.getRoutingKeyspace();
    }

    @Override
    @Nullable
    public ByteBuffer getRoutingKeyForBoundStatements() {
        return this.statement.getRoutingKey();
    }

    @Override
    @Nullable
    public Token getRoutingTokenForBoundStatements() {
        return this.statement.getRoutingToken();
    }

    @Override
    @NonNull
    public Map<String, ByteBuffer> getCustomPayloadForBoundStatements() {
        return this.statement.getCustomPayload();
    }

    @Override
    @Nullable
    public Boolean areBoundStatementsIdempotent() {
        return this.statement.isIdempotent();
    }

    @Override
    @Nullable
    public Duration getTimeoutForBoundStatements() {
        return this.statement.getTimeout();
    }

    @Override
    @Nullable
    public ByteBuffer getPagingStateForBoundStatements() {
        return this.statement.getPagingState();
    }

    @Override
    public int getPageSizeForBoundStatements() {
        return this.statement.getPageSize();
    }

    @Override
    @Nullable
    public ConsistencyLevel getConsistencyLevelForBoundStatements() {
        return this.statement.getConsistencyLevel();
    }

    @Override
    @Nullable
    public ConsistencyLevel getSerialConsistencyLevelForBoundStatements() {
        return this.statement.getSerialConsistencyLevel();
    }

    @Override
    @Nullable
    public Node getNode() {
        return null;
    }

    @Override
    public boolean areBoundStatementsTracing() {
        return this.statement.isTracing();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DefaultPrepareRequest) {
            DefaultPrepareRequest that = (DefaultPrepareRequest)other;
            return this.statement.equals(that.statement);
        }
        return false;
    }

    public int hashCode() {
        return this.statement.hashCode();
    }
}

