/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.transform;

import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.extensions.avro.coders.AvroGenericCoder;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.fn.HopRowToKVStringStringFn;
import org.apache.hop.beam.transforms.kafka.ConfigOption;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamKafkaOutputTransform
extends PTransform<PCollection<HopRow>, PDone> {
    private String transformName;
    private String bootstrapServers;
    private String topic;
    private String keyField;
    private String messageField;
    private List<ConfigOption> configOptions;
    private String rowMetaJson;
    private static final Logger LOG = LoggerFactory.getLogger(BeamKafkaOutputTransform.class);
    private static final Counter numErrors = Metrics.counter((String)"main", (String)"BeamKafkaOutputError");

    public BeamKafkaOutputTransform() {
    }

    public BeamKafkaOutputTransform(String transformName, String bootstrapServers, String topic, String keyField, String messageField, String[] configOptionParameters, String[] configOptionValues, String[] configOptionTypes, String rowMetaJson) {
        super(transformName);
        this.transformName = transformName;
        this.bootstrapServers = bootstrapServers;
        this.topic = topic;
        this.keyField = keyField;
        this.messageField = messageField;
        this.rowMetaJson = rowMetaJson;
        this.configOptions = new ArrayList<ConfigOption>();
        for (int i = 0; i < configOptionParameters.length; ++i) {
            this.configOptions.add(new ConfigOption(configOptionParameters[i], configOptionValues[i], ConfigOption.Type.getTypeFromName(configOptionTypes[i])));
        }
    }

    public PDone expand(PCollection<HopRow> input) {
        try {
            PCollection kvpCollection;
            KafkaIO.Write stringsToKafka;
            BeamHop.init();
            IRowMeta rowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
            int keyIndex = rowMeta.indexOfValue(this.keyField);
            if (keyIndex < 0) {
                throw new HopException("Unable to find key field " + this.keyField + " in input row: " + String.valueOf(rowMeta));
            }
            int messageIndex = rowMeta.indexOfValue(this.messageField);
            if (messageIndex < 0) {
                throw new HopException("Unable to find message field " + this.messageField + " in input row: " + String.valueOf(rowMeta));
            }
            HashMap<String, Object> producerConfigUpdates = new HashMap<String, Object>();
            for (ConfigOption configOption : this.configOptions) {
                String optionValue = configOption.getValue();
                producerConfigUpdates.put(configOption.getParameter(), switch (configOption.getType()) {
                    case ConfigOption.Type.String -> optionValue;
                    case ConfigOption.Type.Short -> Short.valueOf(optionValue);
                    case ConfigOption.Type.Int -> Integer.valueOf(optionValue);
                    case ConfigOption.Type.Long -> Long.valueOf(optionValue);
                    case ConfigOption.Type.Double -> Double.valueOf(optionValue);
                    case ConfigOption.Type.Boolean -> Boolean.valueOf(optionValue);
                    default -> throw new RuntimeException("Config option parameter " + configOption.getParameter() + " uses unsupported type " + configOption.getType().name());
                });
            }
            IValueMeta messageValueMeta = rowMeta.getValueMeta(messageIndex);
            if (messageValueMeta.getType() == 2) {
                HopRowToKVStringStringFn hopRowToKVStringStringFn = new HopRowToKVStringStringFn(this.transformName, keyIndex, messageIndex, this.rowMetaJson);
                stringsToKafka = KafkaIO.write().withBootstrapServers(this.bootstrapServers).withTopic(this.topic).withKeySerializer(StringSerializer.class).withValueSerializer(StringSerializer.class).withProducerConfigUpdates(producerConfigUpdates);
                kvpCollection = (PCollection)input.apply((PTransform)ParDo.of((DoFn)hopRowToKVStringStringFn));
                return (PDone)kvpCollection.apply((PTransform)stringsToKafka);
            }
            if (messageValueMeta.getType() == 20) {
                HopRowToKVStringGenericRecordFn hopRowToKVStringGenericRecordFn = new HopRowToKVStringGenericRecordFn(this.transformName, keyIndex, messageIndex, this.rowMetaJson);
                stringsToKafka = KafkaIO.write().withBootstrapServers(this.bootstrapServers).withTopic(this.topic).withKeySerializer(StringSerializer.class).withValueSerializer(KafkaAvroSerializer.class).withProducerConfigUpdates(producerConfigUpdates);
                kvpCollection = (PCollection)input.apply((PTransform)ParDo.of((DoFn)hopRowToKVStringGenericRecordFn));
                return (PDone)kvpCollection.apply((PTransform)stringsToKafka);
            }
            throw new HopException("Hop only supports sending String or Avro Record values as Kafka messages");
        }
        catch (Exception e) {
            numErrors.inc();
            LOG.error("Error in Beam Kafka output transform", (Throwable)e);
            throw new RuntimeException("Error in Beam Kafka output transform", e);
        }
    }

    private static final class HopRowToKVStringGenericRecordFn
    extends DoFn<HopRow, KV<String, GenericRecord>> {
        private final String rowMetaJson;
        private final String transformName;
        private final int keyIndex;
        private final int valueIndex;
        private static final Logger LOG = LoggerFactory.getLogger(HopRowToKVStringGenericRecordFn.class);
        private final Counter numErrors = Metrics.counter((String)"main", (String)"BeamKafkaProducerTransformErrors");
        private IRowMeta rowMeta;
        private transient Counter inputCounter;
        private transient Counter writtenCounter;

        public HopRowToKVStringGenericRecordFn(String transformName, int keyIndex, int valueIndex, String rowMetaJson) {
            this.transformName = transformName;
            this.keyIndex = keyIndex;
            this.valueIndex = valueIndex;
            this.rowMetaJson = rowMetaJson;
        }

        @DoFn.Setup
        public void setUp() {
            try {
                this.inputCounter = Metrics.counter((String)"input", (String)this.transformName);
                this.writtenCounter = Metrics.counter((String)"written", (String)this.transformName);
                BeamHop.init();
                this.rowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
                Metrics.counter((String)"init", (String)this.transformName).inc();
            }
            catch (Exception e) {
                this.numErrors.inc();
                LOG.error("Error in setup of HopRow to KV<String,GenericRecord> function", (Throwable)e);
                throw new RuntimeException("Error in setup of HopRow to KV<String,GenericRecord> function", e);
            }
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext processContext) {
            try {
                HopRow hopRow = (HopRow)processContext.element();
                this.inputCounter.inc();
                String key = this.rowMeta.getString(hopRow.getRow(), this.keyIndex);
                GenericRecord value = (GenericRecord)hopRow.getRow()[this.valueIndex];
                processContext.output((Object)KV.of((Object)key, (Object)value));
                this.writtenCounter.inc();
            }
            catch (Exception e) {
                this.numErrors.inc();
                LOG.error("Error in HopRow to KV<String,GenericRecord> function", (Throwable)e);
                throw new RuntimeException("Error in HopRow to KV<String,GenericRecord> function", e);
            }
        }
    }

    private static final class GenericRecordCoder
    extends AtomicCoder<GenericRecord> {
        private GenericRecordCoder() {
        }

        public static GenericRecordCoder of() {
            return new GenericRecordCoder();
        }

        public void encode(GenericRecord value, OutputStream outStream) throws IOException {
            String schemaString = value.getSchema().toString();
            StringUtf8Coder.of().encode(schemaString, outStream);
            AvroGenericCoder coder = AvroCoder.of((Schema)value.getSchema());
            coder.encode((Object)value, outStream);
        }

        public GenericRecord decode(InputStream inStream) throws IOException {
            String schemaString = StringUtf8Coder.of().decode(inStream);
            AvroGenericCoder coder = AvroCoder.of((Schema)new Schema.Parser().parse(schemaString));
            return (GenericRecord)coder.decode(inStream);
        }
    }
}

