/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.bigtable;

import org.apache.hop.beam.transforms.bigtable.BeamBigtableOutputMeta;
import org.apache.hop.beam.transforms.bigtable.BigtableColumn;
import org.apache.hop.core.Const;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BeamBigtableOutputDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = BeamBigtableOutputDialog.class;
    private final BeamBigtableOutputMeta input;
    private TextVar wProjectId;
    private TextVar wInstanceId;
    private TextVar wTableId;
    private ComboVar wKeyField;
    private TableView wColumns;

    public BeamBigtableOutputDialog(Shell parent, IVariables variables, BeamBigtableOutputMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        String[] sourceFields;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"BeamBigtableOutputDialog.DialogTitle", (String[])new String[0]));
        try {
            sourceFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName).getFieldNames();
        }
        catch (Exception e2) {
            sourceFields = new String[]{};
            LogChannel.UI.logError("Error getting source fields", (Throwable)e2);
        }
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.getFields());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlProjectId = new Label((Composite)this.shell, 131072);
        wlProjectId.setText(BaseMessages.getString(PKG, (String)"BeamBigtableOutputDialog.ProjectId", (String[])new String[0]));
        PropsUi.setLook((Widget)wlProjectId);
        FormData fdlProjectId = new FormData();
        fdlProjectId.left = new FormAttachment(0, 0);
        fdlProjectId.top = new FormAttachment((Control)lastControl, margin);
        fdlProjectId.right = new FormAttachment(middle, -margin);
        wlProjectId.setLayoutData((Object)fdlProjectId);
        this.wProjectId = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wProjectId);
        FormData fdProjectId = new FormData();
        fdProjectId.left = new FormAttachment(middle, 0);
        fdProjectId.top = new FormAttachment((Control)wlProjectId, 0, 0x1000000);
        fdProjectId.right = new FormAttachment(100, 0);
        this.wProjectId.setLayoutData((Object)fdProjectId);
        lastControl = this.wProjectId;
        Label wlInstanceId = new Label((Composite)this.shell, 131072);
        wlInstanceId.setText(BaseMessages.getString(PKG, (String)"BeamBigtableOutputDialog.InstanceId", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInstanceId);
        FormData fdlInstanceId = new FormData();
        fdlInstanceId.left = new FormAttachment(0, 0);
        fdlInstanceId.top = new FormAttachment((Control)lastControl, margin);
        fdlInstanceId.right = new FormAttachment(middle, -margin);
        wlInstanceId.setLayoutData((Object)fdlInstanceId);
        this.wInstanceId = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wInstanceId);
        FormData fdInstanceId = new FormData();
        fdInstanceId.left = new FormAttachment(middle, 0);
        fdInstanceId.top = new FormAttachment((Control)wlInstanceId, 0, 0x1000000);
        fdInstanceId.right = new FormAttachment(100, 0);
        this.wInstanceId.setLayoutData((Object)fdInstanceId);
        lastControl = this.wInstanceId;
        Label wlTableId = new Label((Composite)this.shell, 131072);
        wlTableId.setText(BaseMessages.getString(PKG, (String)"BeamBigtableOutputDialog.TableId", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTableId);
        FormData fdlTableId = new FormData();
        fdlTableId.left = new FormAttachment(0, 0);
        fdlTableId.top = new FormAttachment((Control)lastControl, margin);
        fdlTableId.right = new FormAttachment(middle, -margin);
        wlTableId.setLayoutData((Object)fdlTableId);
        this.wTableId = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTableId);
        FormData fdTableId = new FormData();
        fdTableId.left = new FormAttachment(middle, 0);
        fdTableId.top = new FormAttachment((Control)wlTableId, 0, 0x1000000);
        fdTableId.right = new FormAttachment(100, 0);
        this.wTableId.setLayoutData((Object)fdTableId);
        lastControl = this.wTableId;
        Label wlKeyField = new Label((Composite)this.shell, 131072);
        wlKeyField.setText(BaseMessages.getString(PKG, (String)"BeamBigtableOutputDialog.KeyField", (String[])new String[0]));
        PropsUi.setLook((Widget)wlKeyField);
        FormData fdlKeyField = new FormData();
        fdlKeyField.left = new FormAttachment(0, 0);
        fdlKeyField.top = new FormAttachment((Control)lastControl, margin);
        fdlKeyField.right = new FormAttachment(middle, -margin);
        wlKeyField.setLayoutData((Object)fdlKeyField);
        this.wKeyField = new ComboVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wKeyField);
        this.wKeyField.setItems(sourceFields);
        FormData fdKeyField = new FormData();
        fdKeyField.left = new FormAttachment(middle, 0);
        fdKeyField.top = new FormAttachment((Control)wlKeyField, 0, 0x1000000);
        fdKeyField.right = new FormAttachment(100, 0);
        this.wKeyField.setLayoutData((Object)fdKeyField);
        lastControl = this.wKeyField;
        Label wlColumns = new Label((Composite)this.shell, 16384);
        wlColumns.setText(BaseMessages.getString(PKG, (String)"BeamBigtableOutputDialog.Columns", (String[])new String[0]));
        PropsUi.setLook((Widget)wlColumns);
        FormData fdlColumns = new FormData();
        fdlColumns.left = new FormAttachment(0, 0);
        fdlColumns.top = new FormAttachment((Control)lastControl, margin);
        fdlColumns.right = new FormAttachment(100, 0);
        wlColumns.setLayoutData((Object)fdlColumns);
        lastControl = wlColumns;
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"BeamBigtableOutputDialog.Column.Name", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"BeamBigtableOutputDialog.Column.Family", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"BeamBigtableOutputDialog.Column.SourceField", (String[])new String[0]), 2, sourceFields, false)};
        this.wColumns = new TableView(this.variables, (Composite)this.shell, 2048, columns, this.input.getColumns().size(), null, this.props);
        FormData fdColumns = new FormData();
        fdColumns.left = new FormAttachment(0, 0);
        fdColumns.top = new FormAttachment((Control)lastControl, margin);
        fdColumns.right = new FormAttachment(100, 0);
        fdColumns.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wColumns.setLayoutData((Object)fdColumns);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void getFields() {
        try {
            IRowMeta rowMeta = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            BaseTransformDialog.getFieldsFromPrevious((IRowMeta)rowMeta, (TableView)this.wColumns, (int)1, (int[])new int[]{1, 3}, (int[])new int[0], (int)-1, (int)-1, null);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error getting fields...", e);
        }
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        this.wProjectId.setText(Const.NVL((String)this.input.getProjectId(), (String)""));
        this.wInstanceId.setText(Const.NVL((String)this.input.getInstanceId(), (String)""));
        this.wTableId.setText(Const.NVL((String)this.input.getTableId(), (String)""));
        this.wKeyField.setText(Const.NVL((String)this.input.getKeyField(), (String)""));
        for (int i = 0; i < this.input.getColumns().size(); ++i) {
            BigtableColumn column = this.input.getColumns().get(i);
            TableItem item = this.wColumns.table.getItem(i);
            item.setText(1, Const.NVL((String)column.getName(), (String)""));
            item.setText(2, Const.NVL((String)column.getFamily(), (String)""));
            item.setText(3, Const.NVL((String)column.getSourceField(), (String)""));
        }
        this.wColumns.optimizeTableView();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(BeamBigtableOutputMeta in) {
        this.transformName = this.wTransformName.getText();
        in.setProjectId(this.wProjectId.getText());
        in.setInstanceId(this.wInstanceId.getText());
        in.setTableId(this.wTableId.getText());
        in.setKeyField(this.wKeyField.getText());
        in.getColumns().clear();
        for (TableItem item : this.wColumns.getNonEmptyItems()) {
            String qualifier = item.getText(1);
            String family = item.getText(2);
            String sourceField = item.getText(3);
            in.getColumns().add(new BigtableColumn(qualifier, family, sourceField));
        }
        this.input.setChanged();
    }
}

