/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hop.core.Counter;

public class Counters {
    private static Counters counters = null;
    private Map<String, Counter> counterMap = Collections.synchronizedMap(new HashMap());
    private static final Object lock = new Object();

    private Counters() {
    }

    public static final Counters getInstance() {
        if (counters != null) {
            return counters;
        }
        counters = new Counters();
        return counters;
    }

    public void setCounter(String name, Counter counter) {
        this.counterMap.put(name, counter);
    }

    public void clearCounter(String name) {
        this.counterMap.remove(name);
    }

    public void clear() {
        this.counterMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counter getCounter(String name) {
        Object object = lock;
        synchronized (object) {
            return this.counterMap.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Counter getOrUpdateCounter(String name, Counter counter) {
        Map<String, Counter> map = this.counterMap;
        synchronized (map) {
            Counter found = this.counterMap.get(name);
            if (found == null) {
                found = counter;
                this.counterMap.put(name, counter);
            }
            return found;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counter removeCounter(String name) {
        Object object = lock;
        synchronized (object) {
            return this.counterMap.remove(name);
        }
    }
}

