/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hop.core.Const;
import org.apache.hop.core.logging.HopLoggingEvent;
import org.apache.hop.core.logging.LogMessage;

public class HopLogLayout {
    private static final ThreadLocal<SimpleDateFormat> LOCAL_SIMPLE_DATE_PARSER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        }
    };
    public static final String ERROR_STRING = "ERROR";
    private boolean timeAdded;

    public HopLogLayout() {
        this(true);
    }

    public HopLogLayout(boolean addTime) {
        this.timeAdded = addTime;
    }

    public String format(HopLoggingEvent event) {
        Object object;
        StringBuilder line = new StringBuilder();
        Object dateTimeString = "";
        if (this.timeAdded) {
            dateTimeString = LOCAL_SIMPLE_DATE_PARSER.get().format(new Date(event.timeStamp)) + " - ";
        }
        if ((object = event.getMessage()) instanceof LogMessage) {
            LogMessage message = (LogMessage)object;
            String[] parts = message.getMessage() == null ? new String[]{} : message.getMessage().split(Const.CR);
            for (int i = 0; i < parts.length; ++i) {
                if (!message.isSimplified()) {
                    line.append((String)dateTimeString);
                    if (message.getSubject() != null) {
                        line.append(message.getSubject());
                        if (message.getCopy() != null) {
                            line.append(".").append(message.getCopy());
                        }
                        line.append(" - ");
                    }
                }
                if (i == 0 && message.isError()) {
                    line.append(ERROR_STRING);
                    line.append(": ");
                }
                line.append(parts[i]);
                if (i >= parts.length - 1) continue;
                line.append(Const.CR);
            }
        } else {
            line.append((String)dateTimeString);
            line.append(object != null ? object.toString() : "<null>");
        }
        return line.toString();
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void activateOptions() {
    }

    public boolean isTimeAdded() {
        return this.timeAdded;
    }

    public void setTimeAdded(boolean addTime) {
        this.timeAdded = addTime;
    }
}

