/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.metrics;

import java.util.Date;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.IMetrics;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.core.metrics.IMetricsSnapshot;
import org.apache.hop.core.metrics.MetricsSnapshotType;
import org.apache.hop.core.util.StringUtil;

public class MetricsSnapshot
implements IMetricsSnapshot {
    private Date date = new Date();
    private MetricsSnapshotType type;
    private IMetrics metric;
    private String subject;
    private String logChannelId;
    private Long value;

    public MetricsSnapshot(MetricsSnapshotType type, IMetrics metric, String subject, String logChannelId) {
        this.type = type;
        this.metric = metric;
        this.subject = subject;
        this.logChannelId = logChannelId;
    }

    public MetricsSnapshot(MetricsSnapshotType type, IMetrics metric, String logChannelId) {
        this(type, metric, null, logChannelId);
    }

    public MetricsSnapshot(MetricsSnapshotType type, IMetrics metric, String subject, long value, String logChannelId) {
        this(type, metric, subject, logChannelId);
        this.value = value;
    }

    public MetricsSnapshot(MetricsSnapshotType type, IMetrics metric, long value, String logChannelId) {
        this(type, metric, null, value, logChannelId);
    }

    @Override
    public String getKey() {
        if (this.subject == null) {
            return this.metric.getCode();
        }
        return this.metric.getCode() + " / " + this.subject;
    }

    public static String getKey(IMetrics metric, String subject) {
        if (subject == null) {
            return metric.getCode();
        }
        return metric.getCode() + " / " + subject;
    }

    public String toString() {
        ILoggingObject loggingObject = LoggingRegistry.getInstance().getLoggingObject(this.logChannelId);
        Object subject = null;
        subject = loggingObject != null ? loggingObject.getObjectName() + "(" + String.valueOf((Object)loggingObject.getObjectType()) + ")" : "-";
        return (String)subject + " - " + this.getKey() + " @ " + StringUtil.getFormattedDateTime(this.date, true) + " : " + this.type.toString();
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    public MetricsSnapshotType getType() {
        return this.type;
    }

    public void setType(MetricsSnapshotType type) {
        this.type = type;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public void setValue(Long value) {
        this.value = value;
    }

    @Override
    public String getLogChannelId() {
        return this.logChannelId;
    }

    public void setLogChannelId(String logChannelId) {
        this.logChannelId = logChannelId;
    }

    @Override
    public IMetrics getMetric() {
        return this.metric;
    }

    public void setMetric(IMetrics metric) {
        this.metric = metric;
    }
}

