/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesis.model.ChildShard;
import java.util.List;

@SdkInternalApi
public class ChildShardMarshaller {
    private static final MarshallingInfo<String> SHARDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShardId").build();
    private static final MarshallingInfo<List> PARENTSHARDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentShards").build();
    private static final MarshallingInfo<StructuredPojo> HASHKEYRANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HashKeyRange").build();
    private static final ChildShardMarshaller instance = new ChildShardMarshaller();

    public static ChildShardMarshaller getInstance() {
        return instance;
    }

    public void marshall(ChildShard childShard, ProtocolMarshaller protocolMarshaller) {
        if (childShard == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)childShard.getShardId(), SHARDID_BINDING);
            protocolMarshaller.marshall(childShard.getParentShards(), PARENTSHARDS_BINDING);
            protocolMarshaller.marshall((Object)childShard.getHashKeyRange(), HASHKEYRANGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

