/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.googlesheets;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.googlesheets.GoogleSheetsInput;
import org.apache.hop.pipeline.transforms.googlesheets.GoogleSheetsInputData;
import org.apache.hop.pipeline.transforms.googlesheets.GoogleSheetsInputField;

@Transform(id="GoogleSheetsInput", image="google-sheets-input.svg", name="i18n::GoogleSheetsInput.transform.Name", description="i18n::GoogleSheetsInput.transform.Name", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", documentationUrl="/pipeline/transforms/google-sheets-input.html")
public class GoogleSheetsInputMeta
extends BaseTransformMeta<GoogleSheetsInput, GoogleSheetsInputData> {
    @HopMetadataProperty(key="jsonCrendentialPath", injectionGroupKey="SHEET", isExcludedFromInjection=true)
    private String oldJsonCredentialPath;
    @HopMetadataProperty(key="jsonCredentialPath", injectionGroupKey="SHEET")
    private String jsonCredentialPath;
    @HopMetadataProperty(key="spreadsheetKey", injectionGroupKey="SHEET")
    private String spreadsheetKey;
    @HopMetadataProperty(key="worksheetId", injectionGroupKey="SHEET")
    private String worksheetId;
    @HopMetadataProperty(key="sampleFields", injectionGroupKey="INPUT_Fields")
    private Integer sampleFields;
    @HopMetadataProperty(key="timeout", injectionGroupKey="SHEET")
    private String timeout;
    @HopMetadataProperty(key="impersonation", injectionGroupKey="SHEET")
    private String impersonation;
    @HopMetadataProperty(key="appName", injectionGroupKey="SHEET")
    private String appName;
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupKey="FIELDS")
    private List<GoogleSheetsInputField> inputFields = new ArrayList<GoogleSheetsInputField>();
    @HopMetadataProperty
    private String proxyHost;
    @HopMetadataProperty
    private String proxyPort;

    public void setDefault() {
        this.spreadsheetKey = "";
        this.worksheetId = "";
        this.jsonCredentialPath = "client_secret.json";
        this.timeout = "5";
        this.impersonation = "";
        this.sampleFields = 100;
    }

    public String getJsonCredentialPath() {
        if (this.getOldJsonCredentialPath() != null && this.jsonCredentialPath == null) {
            this.jsonCredentialPath = this.getOldJsonCredentialPath();
            this.setOldJsonCredentialPath(null);
        }
        return this.jsonCredentialPath == null ? "" : this.jsonCredentialPath;
    }

    public void getFields(IRowMeta rowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            rowMeta.clear();
            for (int i = 0; i < this.inputFields.size(); ++i) {
                GoogleSheetsInputField field = this.inputFields.get(i);
                int type = field.getType();
                if (type == 0) {
                    type = 2;
                }
                try {
                    IValueMeta v = ValueMetaFactory.createValueMeta((String)field.getName(), (int)type);
                    v.setLength(field.getLength());
                    v.setPrecision(field.getPrecision());
                    v.setOrigin(name);
                    v.setConversionMask(field.getFormat());
                    v.setDecimalSymbol(field.getDecimalSymbol());
                    v.setGroupingSymbol(field.getGroupSymbol());
                    v.setCurrencySymbol(field.getCurrencySymbol());
                    v.setTrimType(field.getTrimType());
                    rowMeta.addValueMeta(v);
                    continue;
                }
                catch (Exception e) {
                    throw new HopTransformException((Throwable)e);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables space, IHopMetadataProvider metadataProvider) {
        if (prev == null || prev.size() == 0) {
            remarks.add((ICheckResult)new CheckResult(1, "Not receiving any fields from previous transforms.", (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(4, String.format("Transform is connected to previous one, receiving %1$d fields", prev.size()), (ICheckResultSource)transformMeta));
        }
        if (input.length > 0) {
            remarks.add((ICheckResult)new CheckResult(4, "Transform is receiving info from other transforms!", (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(1, "No input received from other transforms.", (ICheckResultSource)transformMeta));
        }
    }

    @Generated
    public String getOldJsonCredentialPath() {
        return this.oldJsonCredentialPath;
    }

    @Generated
    public String getSpreadsheetKey() {
        return this.spreadsheetKey;
    }

    @Generated
    public String getWorksheetId() {
        return this.worksheetId;
    }

    @Generated
    public Integer getSampleFields() {
        return this.sampleFields;
    }

    @Generated
    public String getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getImpersonation() {
        return this.impersonation;
    }

    @Generated
    public String getAppName() {
        return this.appName;
    }

    @Generated
    public List<GoogleSheetsInputField> getInputFields() {
        return this.inputFields;
    }

    @Generated
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Generated
    public String getProxyPort() {
        return this.proxyPort;
    }

    @Generated
    public void setOldJsonCredentialPath(String oldJsonCredentialPath) {
        this.oldJsonCredentialPath = oldJsonCredentialPath;
    }

    @Generated
    public void setJsonCredentialPath(String jsonCredentialPath) {
        this.jsonCredentialPath = jsonCredentialPath;
    }

    @Generated
    public void setSpreadsheetKey(String spreadsheetKey) {
        this.spreadsheetKey = spreadsheetKey;
    }

    @Generated
    public void setWorksheetId(String worksheetId) {
        this.worksheetId = worksheetId;
    }

    @Generated
    public void setSampleFields(Integer sampleFields) {
        this.sampleFields = sampleFields;
    }

    @Generated
    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setImpersonation(String impersonation) {
        this.impersonation = impersonation;
    }

    @Generated
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Generated
    public void setInputFields(List<GoogleSheetsInputField> inputFields) {
        this.inputFields = inputFields;
    }

    @Generated
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @Generated
    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }
}

