/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.op;

import com.nimbusds.oauth2.sdk.AbstractRequest;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.util.URIUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import net.jcip.annotations.Immutable;

@Immutable
public class OIDCProviderConfigurationRequest
extends AbstractRequest {
    public static final String OPENID_PROVIDER_WELL_KNOWN_PATH = "/.well-known/openid-configuration";

    public OIDCProviderConfigurationRequest(Issuer issuer) {
        super(URI.create(URIUtils.removeTrailingSlash(URI.create(issuer.getValue())) + OPENID_PROVIDER_WELL_KNOWN_PATH));
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        URL url;
        try {
            url = this.getEndpointURI().toURL();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new SerializeException(e.getMessage(), e);
        }
        return new HTTPRequest(HTTPRequest.Method.GET, url);
    }
}

