/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.GeoArray;
import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoLinearRing;
import com.azure.core.models.GeoObject;
import com.azure.core.models.GeoObjectType;
import com.azure.core.models.GeoPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class GeoPolygon
extends GeoObject {
    private final List<GeoLinearRing> rings;

    public GeoPolygon(GeoLinearRing ring) {
        this(ring, null, null);
    }

    public GeoPolygon(GeoLinearRing ring, GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        this(Collections.singletonList(Objects.requireNonNull(ring, "'ring' cannot be null.")), boundingBox, customProperties);
    }

    public GeoPolygon(List<GeoLinearRing> rings) {
        this(rings, null, null);
    }

    public GeoPolygon(List<GeoLinearRing> rings, GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        super(boundingBox, customProperties);
        Objects.requireNonNull(rings, "'rings' cannot be null.");
        this.rings = Collections.unmodifiableList(new ArrayList<GeoLinearRing>(rings));
    }

    public List<GeoLinearRing> getRings() {
        return this.rings;
    }

    public GeoLinearRing getOuterRing() {
        return this.rings.get(0);
    }

    GeoArray<GeoArray<GeoPosition>> getCoordinates() {
        return new GeoArray<GeoArray<GeoPosition>>(this);
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.POLYGON;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rings, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GeoPolygon)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoPolygon other = (GeoPolygon)obj;
        return super.equals(obj) && Objects.equals(this.rings, other.rings);
    }
}

