/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.metrics;

import java.io.Closeable;
import java.io.IOException;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.metrics.FlinkMetricContainerBase;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ReaderInvocationUtil<@UnknownKeyFor OutputT, @UnknownKeyFor ReaderT extends // Could not load outer class - annotation placement on inner may be incorrect
 @UnknownKeyFor @NonNull @Initialized Source.Reader<OutputT>> {
    private final @UnknownKeyFor @NonNull @Initialized String stepName;
    private final @UnknownKeyFor @NonNull @Initialized FlinkMetricContainerBase container;
    private final @UnknownKeyFor @NonNull @Initialized Boolean enableMetrics;

    public ReaderInvocationUtil(@UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized FlinkMetricContainerBase container) {
        FlinkPipelineOptions flinkPipelineOptions = (FlinkPipelineOptions)options.as(FlinkPipelineOptions.class);
        this.stepName = stepName;
        this.enableMetrics = flinkPipelineOptions.getDisableMetrics() == false;
        this.container = container;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean invokeStart(ReaderT reader) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.enableMetrics.booleanValue()) {
            try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.container.getMetricsContainer(this.stepName));){
                boolean result = reader.start();
                this.container.updateMetrics(this.stepName);
                boolean bl = result;
                return bl;
            }
        }
        return reader.start();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean invokeAdvance(ReaderT reader) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.enableMetrics.booleanValue()) {
            try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.container.getMetricsContainer(this.stepName));){
                boolean result = reader.advance();
                this.container.updateMetrics(this.stepName);
                boolean bl = result;
                return bl;
            }
        }
        return reader.advance();
    }
}

