/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.io.source;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.translation.utils.SerdeUtils;
import org.apache.beam.runners.flink.translation.wrappers.streaming.io.source.FlinkSourceSplit;
import org.apache.beam.runners.flink.translation.wrappers.streaming.io.source.FlinkSourceSplitEnumerator;
import org.apache.beam.runners.flink.translation.wrappers.streaming.io.source.bounded.FlinkBoundedSource;
import org.apache.beam.runners.flink.translation.wrappers.streaming.io.source.impulse.BeamImpulseSource;
import org.apache.beam.runners.flink.translation.wrappers.streaming.io.source.unbounded.FlinkUnboundedSource;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.construction.UnboundedReadFromBoundedSource;
import org.apache.flink.api.common.eventtime.Watermark;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class FlinkSource<@UnknownKeyFor T, @UnknownKeyFor OutputT>
implements Source<OutputT, FlinkSourceSplit<T>, Map<Integer, List<FlinkSourceSplit<T>>>> {
    protected final @UnknownKeyFor @NonNull @Initialized String stepName;
    protected final @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.io.Source<T> beamSource;
    protected final @UnknownKeyFor @NonNull @Initialized Boundedness boundedness;
    protected final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions serializablePipelineOptions;
    private final @UnknownKeyFor @NonNull @Initialized int numSplits;

    public static <T> @UnknownKeyFor @NonNull @Initialized FlinkBoundedSource<T> bounded(@UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized BoundedSource<T> boundedSource, @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions serializablePipelineOptions, @UnknownKeyFor @NonNull @Initialized int numSplits) {
        return new FlinkBoundedSource<T>(stepName, boundedSource, serializablePipelineOptions, Boundedness.BOUNDED, numSplits);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized FlinkUnboundedSource<T> unbounded(@UnknownKeyFor @NonNull @Initialized String stepName, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> source, @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions serializablePipelineOptions, @UnknownKeyFor @NonNull @Initialized int numSplits) {
        return new FlinkUnboundedSource<T>(stepName, source, serializablePipelineOptions, numSplits);
    }

    public static @UnknownKeyFor @NonNull @Initialized FlinkUnboundedSource<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> unboundedImpulse(@UnknownKeyFor @NonNull @Initialized long shutdownSourceAfterIdleMs) {
        FlinkPipelineOptions flinkPipelineOptions = FlinkPipelineOptions.defaults();
        flinkPipelineOptions.setShutdownSourcesAfterIdleMs(shutdownSourceAfterIdleMs);
        return new FlinkUnboundedSource<byte[]>("Impulse", (UnboundedSource<byte[], ?>)new UnboundedReadFromBoundedSource.BoundedToUnboundedSourceAdapter((BoundedSource)new BeamImpulseSource()), new SerializablePipelineOptions((PipelineOptions)flinkPipelineOptions), 1, record -> BoundedWindow.TIMESTAMP_MIN_VALUE.getMillis());
    }

    public static @UnknownKeyFor @NonNull @Initialized FlinkBoundedSource<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> boundedImpulse() {
        return new FlinkBoundedSource<byte[]>("Impulse", new BeamImpulseSource(), new SerializablePipelineOptions((PipelineOptions)FlinkPipelineOptions.defaults()), Boundedness.BOUNDED, 1, record -> Watermark.MAX_WATERMARK.getTimestamp());
    }

    protected FlinkSource(@UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.io.Source<T> beamSource, @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions serializablePipelineOptions, @UnknownKeyFor @NonNull @Initialized Boundedness boundedness, @UnknownKeyFor @NonNull @Initialized int numSplits) {
        this.stepName = stepName;
        this.beamSource = beamSource;
        this.serializablePipelineOptions = serializablePipelineOptions;
        this.boundedness = boundedness;
        this.numSplits = numSplits;
    }

    public @UnknownKeyFor @NonNull @Initialized Boundedness getBoundedness() {
        return this.boundedness;
    }

    public @UnknownKeyFor @NonNull @Initialized SplitEnumerator<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>>>> createEnumerator(@UnknownKeyFor @NonNull @Initialized SplitEnumeratorContext<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>> enumContext) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return new FlinkSourceSplitEnumerator<T>(enumContext, this.beamSource, this.serializablePipelineOptions.get(), this.numSplits);
    }

    public @UnknownKeyFor @NonNull @Initialized SplitEnumerator<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>>>> restoreEnumerator(@UnknownKeyFor @NonNull @Initialized SplitEnumeratorContext<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>> enumContext, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>>> checkpoint) throws @UnknownKeyFor @NonNull @Initialized Exception {
        FlinkSourceSplitEnumerator enumerator = new FlinkSourceSplitEnumerator(enumContext, this.beamSource, this.serializablePipelineOptions.get(), this.numSplits);
        checkpoint.forEach((subtaskId, splitsForSubtask) -> enumerator.addSplitsBack((List)splitsForSubtask, (int)subtaskId));
        return enumerator;
    }

    public @UnknownKeyFor @NonNull @Initialized SimpleVersionedSerializer<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>> getSplitSerializer() {
        return FlinkSourceSplit.serializer();
    }

    public @UnknownKeyFor @NonNull @Initialized SimpleVersionedSerializer<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>>>> getEnumeratorCheckpointSerializer() {
        return SerdeUtils.getNaiveObjectSerializer();
    }

    public @UnknownKeyFor @NonNull @Initialized int getNumSplits() {
        return this.numSplits;
    }

    @FunctionalInterface
    public static interface TimestampExtractor<@UnknownKeyFor T>
    extends Function<T, Long>,
    Serializable {
    }
}

