/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.chat;

import dev.ai4j.openai4j.chat.Message;
import dev.ai4j.openai4j.chat.Role;
import java.util.Objects;

public final class SystemMessage
implements Message {
    private final Role role = Role.SYSTEM;
    private final String content;
    private final String name;

    private SystemMessage(Builder builder) {
        this.content = builder.content;
        this.name = builder.name;
    }

    @Override
    public Role role() {
        return this.role;
    }

    public String content() {
        return this.content;
    }

    public String name() {
        return this.name;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SystemMessage && this.equalTo((SystemMessage)another);
    }

    private boolean equalTo(SystemMessage another) {
        return Objects.equals((Object)this.role, (Object)another.role) && Objects.equals(this.content, another.content) && Objects.equals(this.name, another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.role);
        h += (h << 5) + Objects.hashCode(this.content);
        h += (h << 5) + Objects.hashCode(this.name);
        return h;
    }

    public String toString() {
        return "SystemMessage{role=" + (Object)((Object)this.role) + ", content=" + this.content + ", name=" + this.name + "}";
    }

    public static SystemMessage from(String content) {
        return SystemMessage.builder().content(content).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String content;
        private String name;

        private Builder() {
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public SystemMessage build() {
            return new SystemMessage(this);
        }
    }
}

