/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import org.apache.derby.client.BasicClientDataSource;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.CallableLocatorProcedures;
import org.apache.derby.client.am.ClientBlob;
import org.apache.derby.client.am.ClientCallableStatement;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientDatabaseMetaData;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientPreparedStatement;
import org.apache.derby.client.am.ClientSavepoint;
import org.apache.derby.client.am.ClientStatement;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.EncryptionManager;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SQLExceptionFactory;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SectionManager;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.UnitOfWorkListener;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.NetXAResource;

public abstract class ClientConnection
implements Connection,
ConnectionCallbackInterface {
    public Agent agent_;
    public ClientDatabaseMetaData databaseMetaData_;
    final WeakHashMap<ClientStatement, Void> openStatements_ = new WeakHashMap();
    final WeakHashMap<UnitOfWorkListener, Void> CommitAndRollbackListeners_ = new WeakHashMap();
    private SqlWarning warnings_ = null;
    private static final int INVALID_LOCATOR = -1;
    protected final String user_;
    boolean retrieveMessageText_;
    private boolean jdbcReadOnly_;
    private int holdability = 1;
    public String databaseName_;
    public String productID_;
    protected EncryptionManager encryptionManager_;
    private final HashMap<String, ClientPreparedStatement> isolationLevelPreparedStmts = new HashMap();
    private ClientPreparedStatement getTransactionIsolationPrepStmt = null;
    protected boolean open_ = true;
    private boolean aborting_ = false;
    private boolean availableForReuse_ = false;
    private static final int TRANSACTION_UNKNOWN = -1;
    private int isolation_ = -1;
    private int defaultIsolation = 2;
    private String currentSchemaName_ = null;
    public boolean autoCommit_ = true;
    protected boolean inUnitOfWork_ = false;
    private boolean accumulated440ForMessageProcFailure_ = false;
    private boolean accumulated444ForMessageProcFailure_ = false;
    private int transactionID_ = 0;
    protected boolean isXAConnection_ = false;
    public static final int XA_T0_NOT_ASSOCIATED = 0;
    public static final int XA_T1_ASSOCIATED = 1;
    private int xaState_ = 0;
    public int xaHostVersion_ = 0;
    private int loginTimeout_;
    public BasicClientDataSource dataSource_;
    public String serverNameIP_;
    public int portNumber_;
    private int clientSSLMode_ = 0;
    Hashtable<String, String> clientCursorNameCache_ = new Hashtable();
    public int commBufferSize_ = Short.MAX_VALUE;
    public boolean resetConnectionAtFirstSql_ = false;
    private static String DERBY_TRANSACTION_REPEATABLE_READ = "RS";
    private static String DERBY_TRANSACTION_SERIALIZABLE = "RR";
    private static String DERBY_TRANSACTION_READ_COMMITTED = "CS";
    private static String DERBY_TRANSACTION_READ_UNCOMMITTED = "UR";
    private int dncGeneratedSavepointId_;
    private static final String dncGeneratedSavepointNamePrefix__ = "DNC_GENENERATED_NAME_";
    private CallableLocatorProcedures lobProcs;

    protected ClientConnection(LogWriter logWriter, String string, String string2, BasicClientDataSource basicClientDataSource) throws SqlException {
        this.user_ = string;
        this.initConnection(logWriter, basicClientDataSource);
    }

    protected ClientConnection(LogWriter logWriter, String string, String string2, boolean bl, BasicClientDataSource basicClientDataSource) throws SqlException {
        this.user_ = string;
        this.isXAConnection_ = bl;
        this.initConnection(logWriter, basicClientDataSource);
    }

    private void initConnection(LogWriter logWriter, BasicClientDataSource basicClientDataSource) throws SqlException {
        if (logWriter != null) {
            logWriter.traceConnectEntry(basicClientDataSource);
        }
        this.databaseName_ = basicClientDataSource.getDatabaseName();
        Object object = basicClientDataSource.getConnectionAttributes();
        if (basicClientDataSource.getCreateDatabase() != null) {
            object = object == null ? "create=true" : (String)object + ";create=true";
        }
        if (basicClientDataSource.getShutdownDatabase() != null) {
            object = object == null ? "shutdown=true" : (String)object + ";shutdown=true";
        }
        if (this.databaseName_ != null && object != null) {
            this.databaseName_ = this.databaseName_ + ";" + (String)object;
        }
        this.retrieveMessageText_ = basicClientDataSource.getRetrieveMessageText();
        this.loginTimeout_ = basicClientDataSource.getLoginTimeout();
        this.dataSource_ = basicClientDataSource;
        this.serverNameIP_ = basicClientDataSource.getServerName();
        this.portNumber_ = basicClientDataSource.getPortNumber();
        this.clientSSLMode_ = BasicClientDataSource.getSSLModeFromString(basicClientDataSource.getSsl());
        this.agent_ = this.newAgent_(logWriter, this.loginTimeout_, this.serverNameIP_, this.portNumber_, this.clientSSLMode_);
    }

    protected ClientConnection(LogWriter logWriter, boolean bl, BasicClientDataSource basicClientDataSource) throws SqlException {
        if (logWriter != null) {
            logWriter.traceConnectEntry(basicClientDataSource);
        }
        this.isXAConnection_ = bl;
        this.user_ = "APP";
        this.databaseName_ = basicClientDataSource.getDatabaseName();
        this.retrieveMessageText_ = basicClientDataSource.getRetrieveMessageText();
        this.loginTimeout_ = basicClientDataSource.getLoginTimeout();
        this.dataSource_ = basicClientDataSource;
        this.serverNameIP_ = basicClientDataSource.getServerName();
        this.portNumber_ = basicClientDataSource.getPortNumber();
        this.clientSSLMode_ = BasicClientDataSource.getSSLModeFromString(basicClientDataSource.getSsl());
        this.agent_ = this.newAgent_(logWriter, this.loginTimeout_, this.serverNameIP_, this.portNumber_, this.clientSSLMode_);
    }

    protected void resetConnection(LogWriter logWriter) throws SqlException {
        this.clearWarningsX();
        this.encryptionManager_ = null;
        this.currentSchemaName_ = this.user_;
        this.autoCommit_ = true;
        this.inUnitOfWork_ = false;
        this.holdability = 1;
        this.agent_.resetAgent(this, logWriter, this.loginTimeout_, this.serverNameIP_, this.portNumber_);
    }

    protected ClientConnection(LogWriter logWriter, int n, String string, int n2, String string2, Properties properties) throws SqlException {
        if (logWriter != null) {
            logWriter.traceConnectEntry(string, n2, string2, properties);
        }
        this.databaseName_ = string2;
        this.user_ = BasicClientDataSource.getUser(properties);
        this.retrieveMessageText_ = BasicClientDataSource.getRetrieveMessageText(properties);
        this.loginTimeout_ = n;
        this.serverNameIP_ = string;
        this.portNumber_ = n2;
        this.clientSSLMode_ = BasicClientDataSource.getClientSSLMode(properties);
        this.agent_ = this.newAgent_(logWriter, this.loginTimeout_, this.serverNameIP_, this.portNumber_, this.clientSSLMode_);
    }

    protected void finalize() throws Throwable {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "finalize", new Object[0]);
        }
        if (!this.open_) {
            return;
        }
        this.agent_.disconnectEvent();
        super.finalize();
    }

    @Override
    public synchronized Statement createStatement() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "createStatement", new Object[0]);
            }
            ClientStatement clientStatement = this.createStatementX(1003, 1007, this.holdability());
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "createStatement", clientStatement);
            }
            return clientStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "prepareStatement", string);
            }
            ClientPreparedStatement clientPreparedStatement = this.prepareStatementX(string, 1003, 1007, this.holdability(), 2, null, null);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", clientPreparedStatement);
            }
            return clientPreparedStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    synchronized ClientPreparedStatement preparePositionedUpdateStatement(String string, Section section) throws SqlException {
        this.checkForClosedConnection();
        ClientPreparedStatement clientPreparedStatement = this.newPositionedUpdatePreparedStatement_(string, section);
        clientPreparedStatement.flowPrepareDescribeInputOutput();
        return clientPreparedStatement;
    }

    @Override
    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "prepareCall", string);
            }
            ClientCallableStatement clientCallableStatement = this.prepareCallX(string, 1003, 1007, this.holdability());
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareCall", clientCallableStatement);
            }
            return clientCallableStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    synchronized ClientPreparedStatement prepareDynamicCatalogQuery(String string) throws SqlException {
        ClientPreparedStatement clientPreparedStatement = this.newPreparedStatement_(string, 1003, 1007, this.holdability(), 2, null, null);
        clientPreparedStatement.isCatalogQuery_ = true;
        clientPreparedStatement.prepare();
        this.openStatements_.put(clientPreparedStatement, null);
        return clientPreparedStatement;
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "nativeSQL", string);
            }
            String string2 = this.nativeSQLX(string);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "nativeSQL", string2);
            }
            return string2;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    synchronized String nativeSQLX(String string) throws SqlException {
        this.checkForClosedConnection();
        if (string == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ067.S"), new Object[0]);
        }
        String string2 = string.trim();
        if (string2.startsWith("{") && string2.lastIndexOf("}") >= 0) {
            return string2.substring(1, string2.lastIndexOf("}"));
        }
        return string2;
    }

    protected abstract boolean allowLocalCommitRollback_() throws SqlException;

    @Override
    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "setAutoCommit", bl);
            }
            this.checkForClosedConnection();
            if (!this.allowLocalCommitRollback_()) {
                if (bl) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("2D521.S.1"), new Object[0]);
                }
            } else {
                if (bl == this.autoCommit_) {
                    return;
                }
                if (this.inUnitOfWork_) {
                    this.flowCommit();
                }
            }
            this.autoCommit_ = bl;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            this.checkForClosedConnection();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getAutoCommit", this.autoCommit_);
            }
            if (!this.allowLocalCommitRollback_()) {
                return false;
            }
            return this.autoCommit_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public synchronized void commit() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "commit", new Object[0]);
            }
            this.checkForClosedConnection();
            this.checkForInvalidXAStateOnCommitOrRollback();
            this.flowCommit();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void checkForInvalidXAStateOnCommitOrRollback() throws SqlException {
        if (!this.allowLocalCommitRollback_()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("2D521.S.2"), new Object[0]);
        }
    }

    private void flowCommit() throws SqlException {
        if (!this.inUnitOfWork_) {
            return;
        }
        if (this.isXAConnection_) {
            this.agent_.beginWriteChainOutsideUOW();
            this.writeCommit();
            this.agent_.flowOutsideUOW();
            this.readCommit();
            this.agent_.endReadChain();
        } else {
            this.agent_.beginWriteChain(null);
            this.writeCommit();
            this.agent_.flow(null);
            this.readCommit();
            this.agent_.endReadChain();
        }
    }

    public boolean flowAutoCommit() throws SqlException {
        if (this.willAutoCommitGenerateFlow()) {
            this.flowCommit();
            return true;
        }
        return false;
    }

    public boolean willAutoCommitGenerateFlow() throws SqlException {
        if (!this.autoCommit_) {
            return false;
        }
        return this.allowLocalCommitRollback_();
    }

    void writeAutoCommit() throws SqlException {
        if (this.willAutoCommitGenerateFlow()) {
            this.writeCommit();
        }
    }

    void writeCommit() throws SqlException {
        if (this.isXAConnection_) {
            this.writeXACommit_();
        } else {
            this.writeLocalCommit_();
        }
    }

    void readAutoCommit() throws SqlException {
        if (this.willAutoCommitGenerateFlow()) {
            this.readCommit();
        }
    }

    void readCommit() throws SqlException {
        if (this.isXAConnection_) {
            this.readXACommit_();
        } else {
            this.readLocalCommit_();
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "rollback", new Object[0]);
            }
            if (!this.isAborting()) {
                this.checkForClosedConnection();
            }
            this.checkForInvalidXAStateOnCommitOrRollback();
            this.flowRollback();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    protected void flowRollback() throws SqlException {
        if (this.isXAConnection_) {
            this.agent_.beginWriteChainOutsideUOW();
            this.writeRollback();
            this.agent_.flowOutsideUOW();
            this.readRollback();
            this.agent_.endReadChain();
        } else {
            this.agent_.beginWriteChain(null);
            this.writeRollback();
            this.agent_.flow(null);
            this.readRollback();
            this.agent_.endReadChain();
        }
    }

    private void writeRollback() throws SqlException {
        if (this.isXAConnection_) {
            this.writeXARollback_();
        } else {
            this.writeLocalRollback_();
        }
    }

    private void readRollback() throws SqlException {
        if (this.isXAConnection_) {
            this.readLocalXARollback_();
        } else {
            this.readLocalRollback_();
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "close", new Object[0]);
        }
        this.closeX();
    }

    void checkForTransactionInProgress() throws SqlException {
        if (this.transactionInProgress()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("25001"), new Object[0]);
        }
    }

    public boolean transactionInProgress() {
        return this.inUnitOfWork_ && !this.allowCloseInUOW_();
    }

    private void closeX() throws SQLException {
        if (!this.open_ && !this.isAborting()) {
            return;
        }
        this.closeResourcesX();
    }

    public synchronized void closeResources() throws SQLException {
        if (this.open_ || !this.open_ && this.availableForReuse_) {
            this.availableForReuse_ = false;
            this.closeResourcesX();
        }
    }

    private void closeResourcesX() throws SQLException {
        try {
            this.checkForTransactionInProgress();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        this.resetConnectionAtFirstSql_ = false;
        SQLException sQLException = null;
        for (ClientPreparedStatement clientPreparedStatement : this.isolationLevelPreparedStmts.values()) {
            try {
                clientPreparedStatement.close();
            }
            catch (SQLException sQLException2) {
                sQLException = Utils.accumulateSQLException(sQLException2, sQLException);
            }
        }
        this.isolationLevelPreparedStmts.clear();
        if (this.getTransactionIsolationPrepStmt != null) {
            try {
                this.getTransactionIsolationPrepStmt.close();
            }
            catch (SQLException sQLException3) {
                sQLException = Utils.accumulateSQLException(sQLException3, sQLException);
            }
        }
        this.getTransactionIsolationPrepStmt = null;
        try {
            this.flowClose();
        }
        catch (SqlException sqlException) {
            sQLException = Utils.accumulateSQLException(sqlException.getSQLException(), sQLException);
        }
        this.markClosed(false);
        this.aborting_ = false;
        try {
            this.agent_.close();
        }
        catch (SqlException sqlException) {
            throw Utils.accumulateSQLException(sqlException.getSQLException(), sQLException);
        }
    }

    protected abstract boolean isGlobalPending_();

    synchronized void closeForReuse(boolean bl) throws SqlException {
        if (!this.open_) {
            return;
        }
        this.resetConnectionAtFirstSql_ = false;
        SqlException sqlException = null;
        try {
            this.flowClose();
        }
        catch (SqlException sqlException2) {
            sqlException = sqlException2;
        }
        if (this.open_) {
            this.markClosedForReuse(bl);
        }
        if (sqlException != null) {
            throw sqlException;
        }
    }

    private void flowClose() throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        if (this.doCloseStatementsOnClose_()) {
            this.writeCloseStatements();
        }
        if (this.autoCommit_) {
            this.writeAutoCommit();
        }
        this.agent_.flowOutsideUOW();
        if (this.doCloseStatementsOnClose_()) {
            this.readCloseStatements();
        }
        if (this.autoCommit_) {
            this.readAutoCommit();
        }
        this.agent_.endReadChain();
    }

    protected abstract void markClosed_();

    private void markClosed(boolean bl) {
        this.open_ = false;
        this.inUnitOfWork_ = false;
        if (!bl) {
            this.markStatementsClosed();
        }
        this.CommitAndRollbackListeners_.clear();
        this.markClosed_();
    }

    private void markClosedForReuse(boolean bl) {
        this.availableForReuse_ = true;
        this.markClosed(bl);
    }

    private void markStatementsClosed() {
        Set<ClientStatement> set = this.openStatements_.keySet();
        Iterator<ClientStatement> iterator = set.iterator();
        while (iterator.hasNext()) {
            ClientStatement clientStatement = iterator.next();
            clientStatement.markClosed();
            iterator.remove();
        }
    }

    private void writeCloseStatements() throws SqlException {
        Set<ClientStatement> set = this.openStatements_.keySet();
        Iterator<ClientStatement> iterator = set.iterator();
        while (iterator.hasNext()) {
            iterator.next().writeClose(false);
        }
    }

    private void readCloseStatements() throws SqlException {
        Set<ClientStatement> set = this.openStatements_.keySet();
        Iterator<ClientStatement> iterator = set.iterator();
        while (iterator.hasNext()) {
            iterator.next().readClose(false);
        }
    }

    public boolean isPhysicalConnClosed() {
        return !this.open_ && !this.availableForReuse_;
    }

    @Override
    public boolean isClosed() {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "isClosed", !this.open_);
        }
        return !this.open_;
    }

    public boolean isClosedX() {
        return !this.open_;
    }

    @Override
    public synchronized void setTransactionIsolation(int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setTransactionIsolation", n);
        }
        if (n == this.getTransactionIsolationX()) {
            return;
        }
        try {
            this.checkForClosedConnection();
            this.setTransactionIsolationX(n);
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void setTransactionIsolationX(int n) throws SqlException {
        String string = null;
        switch (n) {
            case 4: {
                string = DERBY_TRANSACTION_REPEATABLE_READ;
                break;
            }
            case 2: {
                string = DERBY_TRANSACTION_READ_COMMITTED;
                break;
            }
            case 8: {
                string = DERBY_TRANSACTION_SERIALIZABLE;
                break;
            }
            case 1: {
                string = DERBY_TRANSACTION_READ_UNCOMMITTED;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ045.S"), n);
            }
        }
        ClientPreparedStatement clientPreparedStatement = this.isolationLevelPreparedStmts.get(string);
        if (clientPreparedStatement == null || !clientPreparedStatement.openOnClient_) {
            clientPreparedStatement = this.prepareStatementX("SET CURRENT ISOLATION = " + string, 1003, 1007, this.holdability(), 2, null, null);
            this.isolationLevelPreparedStmts.put(string, clientPreparedStatement);
        }
        try {
            clientPreparedStatement.execute();
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
        this.completeLocalCommit();
    }

    protected abstract boolean supportsSessionDataCaching();

    protected abstract boolean serverSupportsLocators();

    protected abstract boolean serverSupportsTimestampNanoseconds();

    @Override
    public int getTransactionIsolation() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getTransactionIsolation", this.isolation_);
        }
        try {
            this.checkForClosedConnection();
            return this.getTransactionIsolationX();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public int getTransactionIsolationX() throws SQLException {
        boolean bl = this.autoCommit_;
        ResultSet resultSet = null;
        try {
            this.checkForClosedConnection();
            if (this.isolation_ != -1) {
                int n = this.isolation_;
                return n;
            }
            this.autoCommit_ = false;
            if (this.getTransactionIsolationPrepStmt == null || !this.getTransactionIsolationPrepStmt.openOnClient_) {
                this.getTransactionIsolationPrepStmt = this.prepareStatementX("VALUES CURRENT ISOLATION", 1003, 1007, this.holdability(), 2, null, null);
            }
            boolean bl2 = this.inUnitOfWork_;
            resultSet = this.getTransactionIsolationPrepStmt.executeQuery();
            resultSet.next();
            String string = resultSet.getString(1);
            int n = this.translateIsolation(string);
            if (this.isolation_ == -1 && this.supportsSessionDataCaching()) {
                this.isolation_ = n;
            }
            resultSet.close();
            this.inUnitOfWork_ = bl2;
            int n2 = n;
            return n2;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        finally {
            this.autoCommit_ = bl;
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    public int getTransactionID() {
        return this.transactionID_;
    }

    public String getCurrentSchemaName() throws SQLException {
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        if (this.currentSchemaName_ == null) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getCurrentSchemaName() executes query", new Object[0]);
            }
            Statement statement = this.createStatement();
            ResultSet resultSet = statement.executeQuery("VALUES CURRENT SCHEMA");
            resultSet.next();
            String string = resultSet.getString(1);
            resultSet.close();
            statement.close();
            return string;
        }
        return this.currentSchemaName_;
    }

    private int translateIsolation(String string) {
        if (string.compareTo(DERBY_TRANSACTION_REPEATABLE_READ) == 0) {
            return 4;
        }
        if (string.compareTo(DERBY_TRANSACTION_SERIALIZABLE) == 0) {
            return 8;
        }
        if (string.compareTo(DERBY_TRANSACTION_READ_COMMITTED) == 0) {
            return 2;
        }
        if (string.compareTo(DERBY_TRANSACTION_READ_UNCOMMITTED) == 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getWarnings", this.warnings_);
        }
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        return this.warnings_ == null ? null : this.warnings_.getSQLWarning();
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "clearWarnings", new Object[0]);
            }
            this.checkForClosedConnection();
            this.clearWarningsX();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void clearWarningsX() throws SqlException {
        this.warnings_ = null;
        this.accumulated440ForMessageProcFailure_ = false;
        this.accumulated444ForMessageProcFailure_ = false;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            this.checkForClosedConnection();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getMetaData", this.databaseMetaData_);
            }
            return this.databaseMetaData_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public synchronized void setReadOnly(boolean bl) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "setReadOnly", bl);
            }
            this.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            this.checkForClosedConnection();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "isReadOnly", this.jdbcReadOnly_);
            }
            return false;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public synchronized void setCatalog(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "setCatalog", string);
            }
            this.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            this.checkForClosedConnection();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getCatalog", (Object)null);
            }
            return null;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "createStatement", n, n2);
            }
            ClientStatement clientStatement = this.createStatementX(n, n2, this.holdability());
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "createStatement", clientStatement);
            }
            return clientStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "prepareStatement", string, n, n2);
            }
            ClientPreparedStatement clientPreparedStatement = this.prepareStatementX(string, n, n2, this.holdability(), 2, null, null);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", clientPreparedStatement);
            }
            return clientPreparedStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "prepareCall", string, n, n2);
            }
            ClientCallableStatement clientCallableStatement = this.prepareCallX(string, n, n2, this.holdability());
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareCall", clientCallableStatement);
            }
            return clientCallableStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    synchronized ClientCallableStatement prepareMessageProc(String string) throws SqlException {
        this.checkForClosedConnection();
        ClientCallableStatement clientCallableStatement = this.prepareCallX(string, 1003, 1007, this.holdability());
        return clientCallableStatement;
    }

    private int downgradeResultSetType(int n) {
        if (n == 1005) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J10"), new Object[0]));
            return 1004;
        }
        return n;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getTypeMap", new Object[0]);
            }
            this.checkForClosedConnection();
            Map<String, Class<?>> map = Collections.emptyMap();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTypeMap", map);
            }
            return map;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "setTypeMap", map);
            }
            this.checkForClosedConnection();
            if (map == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), map, "map", "setTypeMap");
            }
            if (!map.isEmpty()) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S"), "setTypeMap");
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public synchronized void setHoldability(int n) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "setHoldability", n);
            }
            this.checkForClosedConnection();
            if (this.isXAConnection_ && this.xaState_ == 1 && n == 1) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ05C.S"), new Object[0]);
            }
            this.holdability = n;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            this.checkForClosedConnection();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getHoldability", this.holdability());
            }
            return this.holdability();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "setSavepoint", new Object[0]);
            }
            this.checkForClosedConnection();
            if (this.autoCommit_) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ010.S"), new Object[0]);
            }
            if (++this.dncGeneratedSavepointId_ < 0) {
                this.dncGeneratedSavepointId_ = 1;
            }
            ClientSavepoint clientSavepoint = this.setSavepointX(new ClientSavepoint(this.agent_, this.dncGeneratedSavepointId_));
            return clientSavepoint;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "setSavepoint", string);
            }
            this.checkForClosedConnection();
            if (string == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ011.S"), new Object[0]);
            }
            if (this.autoCommit_) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ010.S"), new Object[0]);
            }
            ClientSavepoint clientSavepoint = this.setSavepointX(new ClientSavepoint(this.agent_, string));
            return clientSavepoint;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private ClientSavepoint setSavepointX(ClientSavepoint clientSavepoint) throws SQLException {
        ClientStatement clientStatement = null;
        try {
            Object object;
            clientStatement = this.createStatementX(1003, 1007, this.holdability());
            try {
                object = clientSavepoint.getSavepointName();
            }
            catch (SQLException sQLException) {
                object = dncGeneratedSavepointNamePrefix__ + clientSavepoint.getSavepointId();
            }
            clientStatement.executeX("SAVEPOINT " + Utils.quoteSqlIdentifier((String)object) + " ON ROLLBACK RETAIN CURSORS");
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        finally {
            if (clientStatement != null) {
                try {
                    clientStatement.closeX();
                }
                catch (SqlException sqlException) {}
            }
        }
        return clientSavepoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        try {
            int n = this.xaState_;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "rollback", savepoint);
            }
            this.checkForClosedConnection();
            if (savepoint == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("3B502.S"), new Object[0]);
            }
            if (this.autoCommit_) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ008.S"), new Object[0]);
            }
            try {
                if (this != ((ClientSavepoint)savepoint).agent_.connection_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ097.S"), new Object[0]);
                }
            }
            catch (ClassCastException classCastException) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ097.S"), new Object[0]);
            }
            ClientStatement clientStatement = null;
            try {
                Object object;
                clientStatement = this.createStatementX(1003, 1007, this.holdability());
                try {
                    object = ((ClientSavepoint)savepoint).getSavepointName();
                }
                catch (SQLException sQLException) {
                    object = dncGeneratedSavepointNamePrefix__ + ((ClientSavepoint)savepoint).getSavepointId();
                }
                clientStatement.executeX("ROLLBACK TO SAVEPOINT " + Utils.quoteSqlIdentifier((String)object));
            }
            finally {
                if (clientStatement != null) {
                    try {
                        clientStatement.closeX();
                    }
                    catch (SqlException sqlException) {}
                }
                this.xaState_ = n;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            int n = this.xaState_;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "releaseSavepoint", savepoint);
            }
            this.checkForClosedConnection();
            if (savepoint == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("3B502.S"), new Object[0]);
            }
            if (this.autoCommit_) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ008.S"), new Object[0]);
            }
            try {
                if (this != ((ClientSavepoint)savepoint).agent_.connection_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ097.S"), new Object[0]);
                }
            }
            catch (ClassCastException classCastException) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ097.S"), new Object[0]);
            }
            ClientStatement clientStatement = null;
            try {
                Object object;
                clientStatement = this.createStatementX(1003, 1007, this.holdability());
                try {
                    object = ((ClientSavepoint)savepoint).getSavepointName();
                }
                catch (SQLException sQLException) {
                    object = dncGeneratedSavepointNamePrefix__ + ((ClientSavepoint)savepoint).getSavepointId();
                }
                clientStatement.executeX("RELEASE SAVEPOINT " + Utils.quoteSqlIdentifier((String)object));
            }
            finally {
                if (clientStatement != null) {
                    try {
                        clientStatement.closeX();
                    }
                    catch (SqlException sqlException) {}
                }
                this.xaState_ = n;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public synchronized Statement createStatement(int n, int n2, int n3) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "createStatement", n, n2, n3);
            }
            ClientStatement clientStatement = this.createStatementX(n, n2, n3);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "createStatement", clientStatement);
            }
            return clientStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private ClientStatement createStatementX(int n, int n2, int n3) throws SqlException {
        this.checkForClosedConnection();
        n = this.downgradeResultSetType(n);
        if (this.isXAConnection_ && this.xaState_ == 1 && n3 == 1) {
            n3 = 2;
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J07"), new Object[0]));
        }
        ClientStatement clientStatement = this.newStatement_(n, n2, n3);
        clientStatement.cursorAttributesToSendOnPrepare_ = clientStatement.cacheCursorAttributesToSendOnPrepare();
        this.openStatements_.put(clientStatement, null);
        return clientStatement;
    }

    protected void resetStatement(ClientStatement clientStatement) throws SqlException {
        String string = clientStatement.cursorAttributesToSendOnPrepare_;
        this.resetStatement_(clientStatement, clientStatement.resultSetType_, clientStatement.resultSetConcurrency_, clientStatement.resultSetHoldability_);
        clientStatement.cursorAttributesToSendOnPrepare_ = string;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "prepareStatement", string, n, n2, n3);
            }
            ClientPreparedStatement clientPreparedStatement = this.prepareStatementX(string, n, n2, n3, 2, null, null);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", clientPreparedStatement);
            }
            return clientPreparedStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    ClientPreparedStatement prepareStatementX(String string, int n, int n2, int n3, int n4, String[] stringArray, int[] nArray) throws SqlException {
        this.checkForClosedConnection();
        n = this.downgradeResultSetType(n);
        ClientPreparedStatement clientPreparedStatement = this.newPreparedStatement_(string, n, n2, n3, n4, stringArray, nArray);
        clientPreparedStatement.cursorAttributesToSendOnPrepare_ = clientPreparedStatement.cacheCursorAttributesToSendOnPrepare();
        clientPreparedStatement.prepare();
        this.openStatements_.put(clientPreparedStatement, null);
        return clientPreparedStatement;
    }

    protected void resetPrepareStatement(ClientPreparedStatement clientPreparedStatement) throws SqlException {
        String string = clientPreparedStatement.cursorAttributesToSendOnPrepare_;
        this.resetPreparedStatement_(clientPreparedStatement, clientPreparedStatement.sql_, clientPreparedStatement.resultSetType_, clientPreparedStatement.resultSetConcurrency_, clientPreparedStatement.resultSetHoldability_, clientPreparedStatement.autoGeneratedKeys_, clientPreparedStatement.generatedKeysColumnNames_, clientPreparedStatement.generatedKeysColumnIndexes_);
        clientPreparedStatement.cursorAttributesToSendOnPrepare_ = string;
        clientPreparedStatement.prepare();
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "prepareCall", string, n, n2, n3);
            }
            ClientCallableStatement clientCallableStatement = this.prepareCallX(string, n, n2, n3);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareCall", clientCallableStatement);
            }
            return clientCallableStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    ClientCallableStatement prepareCallX(String string, int n, int n2, int n3) throws SqlException {
        this.checkForClosedConnection();
        n = this.downgradeResultSetType(n);
        ClientCallableStatement clientCallableStatement = this.newCallableStatement_(string, n, n2, n3);
        clientCallableStatement.cursorAttributesToSendOnPrepare_ = clientCallableStatement.cacheCursorAttributesToSendOnPrepare();
        clientCallableStatement.prepare();
        this.openStatements_.put(clientCallableStatement, null);
        return clientCallableStatement;
    }

    protected void resetPrepareCall(ClientCallableStatement clientCallableStatement) throws SqlException {
        String string = clientCallableStatement.cursorAttributesToSendOnPrepare_;
        this.resetCallableStatement_(clientCallableStatement, clientCallableStatement.sql_, clientCallableStatement.resultSetType_, clientCallableStatement.resultSetConcurrency_, clientCallableStatement.resultSetHoldability_);
        clientCallableStatement.cursorAttributesToSendOnPrepare_ = string;
        clientCallableStatement.prepare();
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "prepareStatement", string, n);
            }
            ClientPreparedStatement clientPreparedStatement = this.prepareStatementX(string, 1003, 1007, this.holdability(), n, null, null);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", clientPreparedStatement);
            }
            return clientPreparedStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "prepareStatement", string, nArray);
            }
            int n = nArray == null || nArray.length == 0 ? 2 : 1;
            ClientPreparedStatement clientPreparedStatement = this.prepareStatementX(string, 1003, 1007, this.holdability(), n, null, nArray);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", clientPreparedStatement);
            }
            return clientPreparedStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "prepareStatement", string, stringArray);
            }
            int n = stringArray == null || stringArray.length == 0 ? 2 : 1;
            ClientPreparedStatement clientPreparedStatement = this.prepareStatementX(string, 1003, 1007, this.holdability(), n, stringArray, null);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", clientPreparedStatement);
            }
            return clientPreparedStatement;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    protected abstract boolean allowCloseInUOW_();

    protected abstract boolean doCloseStatementsOnClose_();

    public abstract SectionManager newSectionManager(Agent var1);

    protected abstract Agent newAgent_(LogWriter var1, int var2, String var3, int var4, int var5) throws SqlException;

    protected abstract ClientDatabaseMetaData newDatabaseMetaData_();

    protected abstract ClientStatement newStatement_(int var1, int var2, int var3) throws SqlException;

    protected abstract void resetStatement_(ClientStatement var1, int var2, int var3, int var4) throws SqlException;

    protected abstract ClientPreparedStatement newPositionedUpdatePreparedStatement_(String var1, Section var2) throws SqlException;

    protected abstract ClientPreparedStatement newPreparedStatement_(String var1, int var2, int var3, int var4, int var5, String[] var6, int[] var7) throws SqlException;

    protected abstract void resetPreparedStatement_(ClientPreparedStatement var1, String var2, int var3, int var4, int var5, int var6, String[] var7, int[] var8) throws SqlException;

    protected abstract ClientCallableStatement newCallableStatement_(String var1, int var2, int var3, int var4) throws SqlException;

    protected abstract void resetCallableStatement_(ClientCallableStatement var1, String var2, int var3, int var4, int var5) throws SqlException;

    public final void completeConnect() throws SqlException {
        this.open_ = true;
        this.databaseMetaData_ = this.newDatabaseMetaData_();
        this.agent_.sectionManager_ = this.newSectionManager(this.agent_);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceConnectExit(this);
        }
    }

    public abstract void writeCommitSubstitute_() throws SqlException;

    public abstract void readCommitSubstitute_() throws SqlException;

    public abstract void writeLocalXAStart_() throws SqlException;

    public abstract void readLocalXAStart_() throws SqlException;

    public abstract void writeLocalXACommit_() throws SqlException;

    protected abstract void writeXACommit_() throws SqlException;

    public abstract void readLocalXACommit_() throws SqlException;

    protected abstract void readXACommit_() throws SqlException;

    public abstract void writeLocalCommit_() throws SqlException;

    public abstract void readLocalCommit_() throws SqlException;

    protected abstract void writeXATransactionStart(ClientStatement var1) throws SqlException;

    @Override
    public void completeLocalCommit() {
        Set<UnitOfWorkListener> set = this.CommitAndRollbackListeners_.keySet();
        Iterator<UnitOfWorkListener> iterator = set.iterator();
        while (iterator.hasNext()) {
            iterator.next().completeLocalCommit(iterator);
        }
        this.inUnitOfWork_ = false;
        ++this.transactionID_;
    }

    public abstract void writeLocalRollback_() throws SqlException;

    public abstract void readLocalRollback_() throws SqlException;

    @Override
    public void completeLocalRollback() {
        Set<UnitOfWorkListener> set = this.CommitAndRollbackListeners_.keySet();
        Iterator<UnitOfWorkListener> iterator = set.iterator();
        while (iterator.hasNext()) {
            iterator.next().completeLocalRollback(iterator);
        }
        this.inUnitOfWork_ = false;
        ++this.transactionID_;
    }

    private void completeSpecificRollback(UnitOfWorkListener unitOfWorkListener) {
        Set<UnitOfWorkListener> set = this.CommitAndRollbackListeners_.keySet();
        Iterator<UnitOfWorkListener> iterator = set.iterator();
        while (iterator.hasNext()) {
            UnitOfWorkListener unitOfWorkListener2 = iterator.next();
            if (unitOfWorkListener2 != unitOfWorkListener) continue;
            unitOfWorkListener2.completeLocalRollback(iterator);
            break;
        }
        this.inUnitOfWork_ = false;
    }

    public abstract void writeLocalXARollback_() throws SqlException;

    protected abstract void writeXARollback_() throws SqlException;

    public abstract void readLocalXARollback_() throws SqlException;

    protected abstract void readXARollback_() throws SqlException;

    public void writeTransactionStart(ClientStatement clientStatement) throws SqlException {
        if (this.isXAConnection_) {
            this.writeXATransactionStart(clientStatement);
        }
    }

    public void readTransactionStart() throws SqlException {
        this.completeTransactionStart();
    }

    void completeTransactionStart() {
        this.inUnitOfWork_ = true;
    }

    @Override
    public void completeAbnormalUnitOfWork() {
        this.completeLocalRollback();
    }

    @Override
    public void completeAbnormalUnitOfWork(UnitOfWorkListener unitOfWorkListener) {
        this.completeSpecificRollback(unitOfWorkListener);
    }

    @Override
    public void completeChainBreakingDisconnect() {
        this.open_ = false;
        this.completeLocalRollback();
        this.markStatementsClosed();
    }

    @Override
    public void completeSqlca(Sqlca sqlca) {
        if (sqlca != null) {
            if (sqlca.getSqlCode() > 0) {
                this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
            } else if (sqlca.getSqlCode() < 0) {
                this.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, sqlca));
            }
        }
    }

    @Override
    public void completePiggyBackIsolation(int n) {
        this.isolation_ = n;
    }

    public void completeInitialPiggyBackIsolation(int n) {
        this.defaultIsolation = this.isolation_ = n;
    }

    @Override
    public void completePiggyBackSchema(String string) {
        this.currentSchemaName_ = string;
    }

    public void completeInitialPiggyBackSchema(String string) {
        this.currentSchemaName_ = string;
    }

    public synchronized void reset(LogWriter logWriter) throws SqlException {
        if (logWriter != null) {
            logWriter.traceConnectResetEntry(this, logWriter, this.user_, this.dataSource_);
        }
        try {
            this.reset_(logWriter);
        }
        catch (SqlException sqlException) {
            DisconnectException disconnectException = new DisconnectException(this.agent_, new ClientMessageId("08006.C.1"), new Object[0]);
            disconnectException.setNextException(sqlException);
            throw disconnectException;
        }
    }

    public synchronized void lightReset() throws SqlException {
        if (!this.open_ && !this.availableForReuse_) {
            return;
        }
        this.open_ = true;
        this.availableForReuse_ = false;
    }

    protected abstract void reset_(LogWriter var1) throws SqlException;

    protected void completeReset(boolean bl, boolean bl2, NetXAResource netXAResource) throws SqlException {
        this.open_ = true;
        this.completeLocalRollback();
        if (bl2) {
            for (ClientStatement clientStatement : this.openStatements_.keySet()) {
                clientStatement.reset(bl2);
            }
        }
        if (netXAResource != null && netXAResource.keepCurrentIsolationLevel()) {
            netXAResource.setKeepCurrentIsolationLevel(false);
        } else if (this.isolation_ != this.defaultIsolation) {
            this.setTransactionIsolationX(this.defaultIsolation);
        }
        if (!bl && this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceConnectResetExit(this);
        }
    }

    CallableLocatorProcedures locatorProcedureCall() {
        if (this.lobProcs == null) {
            this.lobProcs = new CallableLocatorProcedures(this);
        }
        return this.lobProcs;
    }

    protected void checkForClosedConnection() throws SqlException {
        if (!this.open_) {
            this.agent_.checkForDeferredExceptions();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("08003"), new Object[0]);
        }
        this.agent_.checkForDeferredExceptions();
    }

    public boolean isXAConnection() {
        return this.isXAConnection_;
    }

    public int getXAState() {
        return this.xaState_;
    }

    public void setXAState(int n) {
        this.xaState_ = n;
    }

    private void accumulateWarning(SqlWarning sqlWarning) {
        if (this.warnings_ == null) {
            this.warnings_ = sqlWarning;
        } else {
            this.warnings_.setNextException(sqlWarning);
        }
    }

    void accumulate440WarningForMessageProcFailure(SqlWarning sqlWarning) {
        if (!this.accumulated440ForMessageProcFailure_) {
            this.accumulateWarning(sqlWarning);
            this.accumulated440ForMessageProcFailure_ = true;
        }
    }

    void accumulate444WarningForMessageProcFailure(SqlWarning sqlWarning) {
        if (!this.accumulated444ForMessageProcFailure_) {
            this.accumulateWarning(sqlWarning);
            this.accumulated444ForMessageProcFailure_ = true;
        }
    }

    public int getServerVersion() {
        return this.databaseMetaData_.productLevel_.versionLevel_;
    }

    final int holdability() {
        if (this.isXAConnection_ && this.xaState_ == 1) {
            return 2;
        }
        return this.holdability;
    }

    @Override
    public Clob createClob() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "createClob", new Object[0]);
        }
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        int n = -1;
        ClientClob clientClob = null;
        try {
            n = this.locatorProcedureCall().clobCreateLocator();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        clientClob = n != -1 ? new ClientClob(this.agent_, n) : new ClientClob(this.agent_, "");
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "createClob", clientClob);
        }
        return clientClob;
    }

    @Override
    public Blob createBlob() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "createBlob", new Object[0]);
        }
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        int n = -1;
        ClientBlob clientBlob = null;
        try {
            n = this.locatorProcedureCall().blobCreateLocator();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        clientBlob = n != -1 ? new ClientBlob(this.agent_, n) : new ClientBlob(new byte[0], this.agent_, 0);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "createBlob", clientBlob);
        }
        return clientBlob;
    }

    public boolean isAborting() {
        return this.aborting_;
    }

    protected void beginAborting() {
        this.aborting_ = true;
        this.markClosed(false);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.getCurrentSchemaName();
    }

    @Override
    public void setSchema(String string) throws SQLException {
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        if (this.currentSchemaName_ != null && this.currentSchemaName_.equals(string)) {
            return;
        }
        try (PreparedStatement preparedStatement = null;){
            preparedStatement = this.prepareStatement("set schema ?");
            preparedStatement.setString(1, string);
            preparedStatement.execute();
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (!this.open_) {
            return;
        }
        if (executor == null) {
            ClientMessageId clientMessageId = new ClientMessageId("XCZ02.S");
            SqlException sqlException = new SqlException(this.agent_.logWriter_, clientMessageId, "executor", "null");
            throw sqlException.getSQLException();
        }
        this.beginAborting();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientConnection.this.rollback();
                    ClientConnection.this.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace(ClientConnection.this.agent_.getLogWriter());
                }
            }
        });
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNetworkTimeout");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNetworkTimeout");
    }
}

