/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.pgpencryptstream;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.pgpencryptstream.PGPEncryptStream;
import org.apache.hop.pipeline.transforms.pgpencryptstream.PGPEncryptStreamData;
import org.w3c.dom.Node;

@Transform(id="PGPEncryptStream", image="pgpencryptstream.svg", description="i18n::PGPEncryptStream.Description", name="i18n::PGPEncryptStream.Name", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Cryptography", keywords={"i18n::PGPEncryptStreamMeta.keyword"}, documentationUrl="/pipeline/transforms/pgpencryptstream.html")
public class PGPEncryptStreamMeta
extends BaseTransformMeta<PGPEncryptStream, PGPEncryptStreamData> {
    private static final Class<?> PKG = PGPEncryptStreamMeta.class;
    private String gpgLocation;
    private String keyname;
    private String streamfield;
    private String resultFieldName;
    private boolean keynameInField;
    private String keynameFieldName;

    public void setGPGLocation(String value) {
        this.gpgLocation = value;
    }

    public String getGPGLocation() {
        return this.gpgLocation;
    }

    public String getStreamField() {
        return this.streamfield;
    }

    public void setStreamField(String streamfield) {
        this.streamfield = streamfield;
    }

    public String getKeynameFieldName() {
        return this.keynameFieldName;
    }

    public void setKeynameFieldName(String keynameFieldName) {
        this.keynameFieldName = keynameFieldName;
    }

    public boolean isKeynameInField() {
        return this.keynameInField;
    }

    public void setKeynameInField(boolean keynameInField) {
        this.keynameInField = keynameInField;
    }

    public String getResultFieldName() {
        return this.resultFieldName;
    }

    public void setResultFieldName(String resultFieldName) {
        this.resultFieldName = resultFieldName;
    }

    public String getKeyName() {
        return this.keyname;
    }

    public void setKeyName(String keyname) {
        this.keyname = keyname;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public Object clone() {
        PGPEncryptStreamMeta retval = (PGPEncryptStreamMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.resultFieldName = "result";
        this.streamfield = null;
        this.keyname = null;
        this.gpgLocation = null;
        this.keynameInField = false;
        this.keynameFieldName = null;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (!Utils.isEmpty((CharSequence)this.resultFieldName)) {
            ValueMetaString v = new ValueMetaString(variables.resolve(this.resultFieldName));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XmlHandler.addTagValue((String)"gpglocation", (String)this.gpgLocation));
        retval.append("    " + XmlHandler.addTagValue((String)"keyname", (String)this.keyname));
        retval.append("    " + XmlHandler.addTagValue((String)"keynameInField", (boolean)this.keynameInField));
        retval.append("    " + XmlHandler.addTagValue((String)"keynameFieldName", (String)this.keynameFieldName));
        retval.append("    " + XmlHandler.addTagValue((String)"streamfield", (String)this.streamfield));
        retval.append("    " + XmlHandler.addTagValue((String)"resultfieldname", (String)this.resultFieldName));
        return retval.toString();
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.gpgLocation = XmlHandler.getTagValue((Node)transformNode, (String)"gpglocation");
            this.keyname = XmlHandler.getTagValue((Node)transformNode, (String)"keyname");
            this.keynameInField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"keynameInField"));
            this.keynameFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"keynameFieldName");
            this.streamfield = XmlHandler.getTagValue((Node)transformNode, (String)"streamfield");
            this.resultFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"resultfieldname");
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.Exception.UnableToReadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        if (Utils.isEmpty((CharSequence)this.gpgLocation)) {
            errorMessage = BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.GPGLocationMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.GPGLocationOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
        }
        if (!this.isKeynameInField()) {
            if (Utils.isEmpty((CharSequence)this.keyname)) {
                errorMessage = BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.KeyNameMissing", (String[])new String[0]);
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                errorMessage = BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.KeyNameOK", (String[])new String[0]);
                cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            }
        }
        if (Utils.isEmpty((CharSequence)this.resultFieldName)) {
            errorMessage = BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.ResultFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.ResultFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (Utils.isEmpty((CharSequence)this.streamfield)) {
            errorMessage = BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.StreamFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.StreamFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PGPEncryptStreamMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

