/*
 * Decompiled with CFR 0.152.
 */
package waffle.util;

public final class SPNegoMessage {
    private static final byte[] SPENGO_OID = new byte[]{6, 6, 43, 6, 1, 5, 5, 2};

    public static boolean isSPNegoMessage(byte[] message) {
        if (message == null || message.length < 2) {
            return false;
        }
        return SPNegoMessage.isNegTokenInit(message) || SPNegoMessage.isNegTokenArg(message);
    }

    public static boolean isNegTokenInit(byte[] message) {
        if (message[0] != 96) {
            return false;
        }
        int lenBytes = 1;
        if ((message[1] & 0x80) != 0) {
            lenBytes = 1 + (message[1] & 0x7F);
        }
        if (message.length < SPENGO_OID.length + 1 + lenBytes) {
            return false;
        }
        for (int i = 0; i < SPENGO_OID.length; ++i) {
            if (SPENGO_OID[i] == message[i + 1 + lenBytes]) continue;
            return false;
        }
        return true;
    }

    public static boolean isNegTokenArg(byte[] message) {
        int len;
        if ((message[0] & 0xFF) != 161) {
            return false;
        }
        if ((message[1] & 0x80) == 0) {
            len = message[1];
        } else {
            len = 0;
            int i = 2;
            for (int lenBytes = message[1] & 0x7F; lenBytes > 0; --lenBytes) {
                len <<= 8;
                len |= message[i] & 0xFF;
            }
        }
        return len + 2 == message.length;
    }

    private SPNegoMessage() {
    }
}

