/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.testing;

import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.testing.DataSet;
import org.apache.hop.testing.DataSetCsvUtil;
import org.apache.hop.testing.DataSetField;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.testing.EditRowsDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DataSetEditor
extends MetadataEditor<DataSet> {
    private static final Class<?> PKG = DataSetEditor.class;
    public static final String CONST_ERROR = "Error";
    private Text wName;
    private Text wDescription;
    private Text wBaseFilename;
    private TextVar wFolderName;
    private TableView wFieldMapping;

    public DataSetEditor(HopGui hopGui, MetadataManager<DataSet> manager, DataSet dataSet) {
        super(hopGui, manager, (IHopMetadata)dataSet);
    }

    public void createControl(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        int margin = PropsUi.getMargin();
        Label wIcon = new Label(parent, 131072);
        wIcon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wIcon.setLayoutData((Object)fdlicon);
        PropsUi.setLook((Widget)wIcon);
        Label wlName = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"DataSetDialog.Name.Label", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, 0);
        fdlName.left = new FormAttachment(0, 0);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(parent, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 5);
        fdName.left = new FormAttachment(0, 0);
        fdName.right = new FormAttachment((Control)wIcon, -5);
        this.wName.setLayoutData((Object)fdName);
        Label spacer = new Label(parent, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wName, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        Label wlDescription = new Label(parent, 16384);
        PropsUi.setLook((Widget)wlDescription);
        wlDescription.setText(BaseMessages.getString(PKG, (String)"DataSetDialog.Description.Label", (String[])new String[0]));
        FormData fdlDescription = new FormData();
        fdlDescription.top = new FormAttachment((Control)spacer, margin);
        fdlDescription.left = new FormAttachment(0, 0);
        fdlDescription.right = new FormAttachment(100, 0);
        wlDescription.setLayoutData((Object)fdlDescription);
        this.wDescription = new Text(parent, 18946);
        PropsUi.setLook((Widget)this.wDescription);
        FormData fdDescription = new FormData();
        fdDescription.height = 50;
        fdDescription.top = new FormAttachment((Control)wlDescription, margin);
        fdDescription.left = new FormAttachment(0, 0);
        fdDescription.right = new FormAttachment(100, 0);
        this.wDescription.setLayoutData((Object)fdDescription);
        Label wlFolderName = new Label(parent, 16384);
        PropsUi.setLook((Widget)wlFolderName);
        wlFolderName.setText(BaseMessages.getString(PKG, (String)"DataSetDialog.FolderName.Label", (String[])new String[0]));
        FormData fdlFolderName = new FormData();
        fdlFolderName.top = new FormAttachment((Control)this.wDescription, margin);
        fdlFolderName.left = new FormAttachment(0, 0);
        fdlFolderName.right = new FormAttachment(100, 0);
        wlFolderName.setLayoutData((Object)fdlFolderName);
        this.wFolderName = new TextVar(this.manager.getVariables(), parent, 18436);
        PropsUi.setLook((Widget)this.wFolderName);
        FormData fdFolderName = new FormData();
        fdFolderName.top = new FormAttachment((Control)wlFolderName, margin);
        fdFolderName.left = new FormAttachment(0, 0);
        fdFolderName.right = new FormAttachment(100, 0);
        this.wFolderName.setLayoutData((Object)fdFolderName);
        Label wlBaseFilename = new Label(parent, 16384);
        PropsUi.setLook((Widget)wlBaseFilename);
        wlBaseFilename.setText(BaseMessages.getString(PKG, (String)"DataSetDialog.BaseFilename.Label", (String[])new String[0]));
        FormData fdlBaseFilename = new FormData();
        fdlBaseFilename.top = new FormAttachment((Control)this.wFolderName, margin);
        fdlBaseFilename.left = new FormAttachment(0, 0);
        fdlBaseFilename.right = new FormAttachment(100, 0);
        wlBaseFilename.setLayoutData((Object)fdlBaseFilename);
        this.wBaseFilename = new Text(parent, 18436);
        PropsUi.setLook((Widget)this.wBaseFilename);
        FormData fdBaseFilename = new FormData();
        fdBaseFilename.top = new FormAttachment((Control)wlBaseFilename, margin);
        fdBaseFilename.left = new FormAttachment(0, 0);
        fdBaseFilename.right = new FormAttachment(100, 0);
        this.wBaseFilename.setLayoutData((Object)fdBaseFilename);
        Label wlFieldMapping = new Label(parent, 0);
        wlFieldMapping.setText(BaseMessages.getString(PKG, (String)"DataSetDialog.FieldMapping.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFieldMapping);
        FormData fdlUpIns = new FormData();
        fdlUpIns.left = new FormAttachment(0, 0);
        fdlUpIns.top = new FormAttachment((Control)this.wBaseFilename, margin * 2);
        wlFieldMapping.setLayoutData((Object)fdlUpIns);
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"DataSetDialog.ColumnInfo.FieldName", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataSetDialog.ColumnInfo.FieldType", (String[])new String[0]), 2, ValueMetaFactory.getAllValueMetaNames(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataSetDialog.ColumnInfo.FieldFormat", (String[])new String[0]), 5, 2), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataSetDialog.ColumnInfo.FieldLength", (String[])new String[0]), 1, true, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataSetDialog.ColumnInfo.FieldPrecision", (String[])new String[0]), 1, true, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataSetDialog.ColumnInfo.Comment", (String[])new String[0]), 1, false, false)};
        this.wFieldMapping = new TableView((IVariables)new Variables(), parent, 68354, columns, ((DataSet)this.getMetadata()).getFields().size(), null, props);
        FormData fdFieldMapping = new FormData();
        fdFieldMapping.left = new FormAttachment(0, 0);
        fdFieldMapping.top = new FormAttachment((Control)wlFieldMapping, margin);
        fdFieldMapping.right = new FormAttachment(100, 0);
        fdFieldMapping.bottom = new FormAttachment(100, -2 * margin);
        this.wFieldMapping.setLayoutData((Object)fdFieldMapping);
        this.setWidgetsContent();
        ModifyListener lsMod = e -> this.setChanged();
        this.wName.addModifyListener(lsMod);
        this.wDescription.addModifyListener(lsMod);
        this.wFolderName.addModifyListener(lsMod);
        this.wBaseFilename.addModifyListener(lsMod);
        this.wFieldMapping.addModifyListener(lsMod);
    }

    protected void editData(Composite parent) {
        int previewSize = PropsUi.getInstance().getDefaultPreviewSize();
        try {
            this.verifySettings();
            DataSet set = new DataSet();
            this.getWidgetsContent(set);
            List<Object[]> rows = set.getAllRows(this.manager.getVariables(), LogChannel.UI);
            IRowMeta fieldsRowMeta = set.getSetRowMeta();
            boolean written = false;
            while (!written) {
                try {
                    EditRowsDialog editRowsDialog = new EditRowsDialog(parent.getShell(), 0, BaseMessages.getString(PKG, (String)"DataSetDialog.EditRows.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DataSetDialog.EditRows.Message", (String[])new String[]{set.getName()}), fieldsRowMeta, rows);
                    List<Object[]> newList = editRowsDialog.open();
                    if (newList == null) break;
                    FileObject setFolder = HopVfs.getFileObject((String)set.getActualDataSetFolder(this.manager.getVariables()));
                    boolean folderExists = setFolder.exists();
                    if (!folderExists) {
                        MessageBox box = new MessageBox(this.getShell(), 452);
                        box.setText("Create data sets folder?");
                        box.setMessage("The data sets folder does not exist. Do you want to create it?" + Const.CR + set.getActualDataSetFolder(this.manager.getVariables()));
                        int answer = box.open();
                        if ((answer & 0x40) != 0) {
                            setFolder.createFolder();
                            folderExists = true;
                        } else if ((answer & 0x100) != 0) break;
                    }
                    if (!folderExists) continue;
                    DataSetCsvUtil.writeDataSetData(this.manager.getVariables(), set, fieldsRowMeta, newList);
                    written = true;
                }
                catch (Exception e) {
                    new ErrorDialog(this.getShell(), CONST_ERROR, "Error writing data to dataset file " + set.getActualDataSetFilename(this.manager.getVariables()), e);
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), CONST_ERROR, "Error previewing data from dataset table", e);
        }
    }

    public void setWidgetsContent() {
        DataSet dataSet = (DataSet)this.getMetadata();
        this.wName.setText(Const.NVL((String)dataSet.getName(), (String)""));
        this.wDescription.setText(Const.NVL((String)dataSet.getDescription(), (String)""));
        this.wFolderName.setText(Const.NVL((String)dataSet.getFolderName(), (String)""));
        this.wBaseFilename.setText(Const.NVL((String)dataSet.getBaseFilename(), (String)""));
        for (int i = 0; i < dataSet.getFields().size(); ++i) {
            DataSetField field = dataSet.getFields().get(i);
            int colNr = 1;
            this.wFieldMapping.setText(Const.NVL((String)field.getFieldName(), (String)""), colNr++, i);
            this.wFieldMapping.setText(ValueMetaFactory.getValueMetaName((int)field.getType()), colNr++, i);
            this.wFieldMapping.setText(Const.NVL((String)field.getFormat(), (String)""), colNr++, i);
            this.wFieldMapping.setText(field.getLength() >= 0 ? Integer.toString(field.getLength()) : "", colNr++, i);
            this.wFieldMapping.setText(field.getPrecision() >= 0 ? Integer.toString(field.getPrecision()) : "", colNr++, i);
            this.wFieldMapping.setText(Const.NVL((String)field.getComment(), (String)""), colNr++, i);
        }
    }

    public void getWidgetsContent(DataSet dataSet) {
        dataSet.setName(this.wName.getText());
        dataSet.setDescription(this.wDescription.getText());
        dataSet.setFolderName(this.wFolderName.getText());
        dataSet.setBaseFilename(this.wBaseFilename.getText());
        dataSet.getFields().clear();
        int nrFields = this.wFieldMapping.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wFieldMapping.getNonEmpty(i);
            int colnr = 1;
            String fieldName = item.getText(colnr++);
            int type = ValueMetaFactory.getIdForValueMeta((String)item.getText(colnr++));
            String format = item.getText(colnr++);
            int length = Const.toInt((String)item.getText(colnr++), (int)-1);
            int precision = Const.toInt((String)item.getText(colnr++), (int)-1);
            String comment = item.getText(colnr++);
            DataSetField field = new DataSetField(fieldName, type, length, precision, comment, format);
            dataSet.getFields().add(field);
        }
    }

    public void save() throws HopException {
        try {
            this.verifySettings();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), CONST_ERROR, BaseMessages.getString(PKG, (String)"DataSetDialog.Error.ValidationError", (String[])new String[0]), e);
        }
        this.getWidgetsContent((DataSet)this.getMetadata());
        super.save();
    }

    private void verifySettings() throws HopException {
        try {
            if (StringUtil.isEmpty((String)this.wBaseFilename.getText())) {
                throw new HopException(BaseMessages.getString(PKG, (String)"DataSetDialog.Error.NoTableSpecified", (String[])new String[0]));
            }
        }
        catch (Exception e) {
            throw new HopException("Error validating group and table values", (Throwable)e);
        }
    }

    protected void viewData(Composite parent) {
        try {
            DataSet set = new DataSet();
            this.getWidgetsContent(set);
            this.verifySettings();
            List<Object[]> setRows = set.getAllRows(this.manager.getVariables(), LogChannel.UI);
            IRowMeta setRowMeta = set.getSetRowMeta();
            PreviewRowsDialog previewRowsDialog = new PreviewRowsDialog(parent.getShell(), (IVariables)new Variables(), 0, set.getName(), setRowMeta, setRows);
            previewRowsDialog.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), CONST_ERROR, "Error previewing data from dataset table", e);
        }
    }

    public boolean setFocus() {
        if (this.wName == null || this.wName.isDisposed()) {
            return false;
        }
        return this.wName.setFocus();
    }

    public Button[] createButtonsForButtonBar(Composite parent) {
        Button wEditData = new Button(parent, 8);
        wEditData.setText(BaseMessages.getString(PKG, (String)"DataSetDialog.EditData.Button", (String[])new String[0]));
        wEditData.addListener(13, e -> this.editData(parent));
        Button wViewData = new Button(parent, 8);
        wViewData.setText(BaseMessages.getString(PKG, (String)"DataSetDialog.ViewData.Button", (String[])new String[0]));
        wViewData.addListener(13, e -> this.viewData(parent));
        return new Button[]{wEditData, wViewData};
    }
}

