/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.PartiallyAppliedScalarFunction;
import org.apache.cassandra.cql3.functions.PreComputedScalarFunction;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.ProtocolVersion;

public interface ScalarFunction
extends Function {
    public boolean isCalledOnNullInput();

    default public boolean isMonotonic() {
        return false;
    }

    public ByteBuffer execute(ProtocolVersion var1, List<ByteBuffer> var2) throws InvalidRequestException;

    default public ScalarFunction partialApplication(ProtocolVersion protocolVersion, List<ByteBuffer> partialParameters) {
        int unresolvedCount = 0;
        for (ByteBuffer parameter : partialParameters) {
            if (parameter != UNRESOLVED) continue;
            ++unresolvedCount;
        }
        if (unresolvedCount == this.argTypes().size()) {
            return this;
        }
        if (this.isPure() && unresolvedCount == 0) {
            return new PreComputedScalarFunction(this.returnType(), this.execute(protocolVersion, partialParameters), protocolVersion, this, partialParameters);
        }
        return new PartiallyAppliedScalarFunction(this, partialParameters, unresolvedCount);
    }
}

