/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.security;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.security.ISslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SSLFactory {
    private static final Logger logger = LoggerFactory.getLogger(SSLFactory.class);
    private static final boolean openSslIsAvailable = Boolean.getBoolean("cassandra.disable_tcactive_openssl") ? false : OpenSsl.isAvailable();
    private static final ConcurrentHashMap<CacheKey, SslContext> cachedSslContexts = new ConcurrentHashMap();
    public static final int DEFAULT_HOT_RELOAD_INITIAL_DELAY_SEC = 600;
    public static final int DEFAULT_HOT_RELOAD_PERIOD_SEC = 600;
    private static boolean isHotReloadingInitialized = false;

    public static boolean openSslIsAvailable() {
        return openSslIsAvailable;
    }

    public static List<String> tlsInstanceProtocolSubstitution() {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, null, null);
            SSLParameters params = ctx.getDefaultSSLParameters();
            String[] protocols = params.getProtocols();
            return Arrays.asList(protocols);
        }
        catch (Exception e) {
            throw new RuntimeException("Error finding supported TLS Protocols", e);
        }
    }

    public static SSLContext createSSLContext(EncryptionOptions options, boolean verifyPeerCertificate) throws IOException {
        return options.sslContextFactoryInstance.createJSSESslContext(verifyPeerCertificate);
    }

    public static SslContext getOrCreateSslContext(EncryptionOptions options, boolean verifyPeerCertificate, ISslContextFactory.SocketType socketType, String contextDescription) throws IOException {
        CacheKey key = new CacheKey(options, socketType, contextDescription);
        SslContext sslContext = cachedSslContexts.get(key);
        if (sslContext != null) {
            return sslContext;
        }
        sslContext = SSLFactory.createNettySslContext(options, verifyPeerCertificate, socketType);
        SslContext previous = cachedSslContexts.putIfAbsent(key, sslContext);
        if (previous == null) {
            return sslContext;
        }
        ReferenceCountUtil.release((Object)sslContext);
        return previous;
    }

    static SslContext createNettySslContext(EncryptionOptions options, boolean verifyPeerCertificate, ISslContextFactory.SocketType socketType) throws IOException {
        return SSLFactory.createNettySslContext(options, verifyPeerCertificate, socketType, LoggingCipherSuiteFilter.QUIET_FILTER);
    }

    static SslContext createNettySslContext(EncryptionOptions options, boolean verifyPeerCertificate, ISslContextFactory.SocketType socketType, CipherSuiteFilter cipherFilter) throws IOException {
        return options.sslContextFactoryInstance.createNettySslContext(verifyPeerCertificate, socketType, cipherFilter);
    }

    public static void checkCertFilesForHotReloading() {
        if (!isHotReloadingInitialized) {
            throw new IllegalStateException("Hot reloading functionality has not been initialized.");
        }
        SSLFactory.checkCachedContextsForReload(false);
    }

    public static void forceCheckCertFiles() {
        SSLFactory.checkCachedContextsForReload(true);
    }

    private static void checkCachedContextsForReload(boolean forceReload) {
        ArrayList<CacheKey> keysToCheck = new ArrayList<CacheKey>(Collections.list(cachedSslContexts.keys()));
        while (!keysToCheck.isEmpty()) {
            CacheKey key = (CacheKey)keysToCheck.remove(keysToCheck.size() - 1);
            EncryptionOptions opts = key.encryptionOptions;
            logger.debug("Checking whether certificates have been updated for {}", (Object)key.contextDescription);
            if (!forceReload && !opts.sslContextFactoryInstance.shouldReload()) continue;
            try {
                SSLFactory.validateSslContext(key.contextDescription, opts, opts instanceof EncryptionOptions.ServerEncryptionOptions || opts.require_client_auth, false);
                logger.info("SSL certificates have been updated for {}. Resetting the ssl contexts for new connections.", (Object)key.contextDescription);
                SSLFactory.clearSslContextCache(key.encryptionOptions, keysToCheck);
            }
            catch (Throwable tr) {
                logger.error("Failed to hot reload the SSL Certificates! Please check the certificate files for {}.", (Object)key.contextDescription, (Object)tr);
            }
        }
    }

    public static void clearSslContextCache() {
        cachedSslContexts.clear();
    }

    private static void clearSslContextCache(EncryptionOptions options, List<CacheKey> keysToCheck) {
        cachedSslContexts.forEachKey(1L, cacheKey -> {
            if (Objects.equals(options, ((CacheKey)cacheKey).encryptionOptions)) {
                cachedSslContexts.remove(cacheKey);
                keysToCheck.remove(cacheKey);
            }
        });
    }

    public static synchronized void initHotReloading(EncryptionOptions.ServerEncryptionOptions serverOpts, EncryptionOptions clientOpts, boolean force) throws IOException {
        if (isHotReloadingInitialized && !force) {
            return;
        }
        logger.debug("Initializing hot reloading SSLContext");
        if (serverOpts != null && serverOpts.tlsEncryptionPolicy() != EncryptionOptions.TlsEncryptionPolicy.UNENCRYPTED) {
            serverOpts.sslContextFactoryInstance.initHotReloading();
        }
        if (clientOpts != null && clientOpts.tlsEncryptionPolicy() != EncryptionOptions.TlsEncryptionPolicy.UNENCRYPTED) {
            clientOpts.sslContextFactoryInstance.initHotReloading();
        }
        if (!isHotReloadingInitialized) {
            ScheduledExecutors.scheduledTasks.scheduleWithFixedDelay(SSLFactory::checkCertFilesForHotReloading, 600L, 600L, TimeUnit.SECONDS);
        }
        isHotReloadingInitialized = true;
    }

    private static boolean filterOutSSLv2Hello(String string) {
        return !string.equals("SSLv2Hello");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateSslContext(String contextDescription, EncryptionOptions options, boolean verifyPeerCertificate, boolean logProtocolAndCiphers) throws IOException {
        if (options != null && options.tlsEncryptionPolicy() != EncryptionOptions.TlsEncryptionPolicy.UNENCRYPTED) {
            try {
                CipherSuiteFilter loggingCipherSuiteFilter = logProtocolAndCiphers ? new LoggingCipherSuiteFilter(contextDescription) : LoggingCipherSuiteFilter.QUIET_FILTER;
                SslContext serverSslContext = SSLFactory.createNettySslContext(options, verifyPeerCertificate, ISslContextFactory.SocketType.SERVER, loggingCipherSuiteFilter);
                try {
                    SSLEngine engine = serverSslContext.newEngine(ByteBufAllocator.DEFAULT);
                    try {
                        if (logProtocolAndCiphers) {
                            CharSequence[] supportedProtocols = engine.getSupportedProtocols();
                            CharSequence[] supportedCiphers = engine.getSupportedCipherSuites();
                            CharSequence[] enabledProtocols = engine.getEnabledProtocols();
                            String filteredEnabledProtocols = supportedProtocols == null ? "system default" : Arrays.stream(engine.getEnabledProtocols()).filter(SSLFactory::filterOutSSLv2Hello).collect(Collectors.joining(", "));
                            CharSequence[] enabledCiphers = engine.getEnabledCipherSuites();
                            logger.debug("{} supported TLS protocols: {}", (Object)contextDescription, (Object)(supportedProtocols == null ? "system default" : String.join((CharSequence)", ", supportedProtocols)));
                            logger.debug("{} unfiltered enabled TLS protocols: {}", (Object)contextDescription, (Object)(enabledProtocols == null ? "system default" : String.join((CharSequence)", ", enabledProtocols)));
                            logger.info("{} enabled TLS protocols: {}", (Object)contextDescription, (Object)filteredEnabledProtocols);
                            logger.debug("{} supported cipher suites: {}", (Object)contextDescription, (Object)(supportedCiphers == null ? "system default" : String.join((CharSequence)", ", supportedCiphers)));
                            logger.info("{} enabled cipher suites: {}", (Object)contextDescription, (Object)(enabledCiphers == null ? "system default" : String.join((CharSequence)", ", enabledCiphers)));
                        }
                    }
                    finally {
                        engine.closeInbound();
                        engine.closeOutbound();
                        ReferenceCountUtil.release((Object)engine);
                    }
                }
                finally {
                    ReferenceCountUtil.release((Object)serverSslContext);
                }
                SslContext clientSslContext = SSLFactory.createNettySslContext(options, verifyPeerCertificate, ISslContextFactory.SocketType.CLIENT);
                ReferenceCountUtil.release((Object)clientSslContext);
            }
            catch (Exception e) {
                throw new IOException("Failed to create SSL context using " + contextDescription, e);
            }
        }
    }

    public static void validateSslCerts(EncryptionOptions.ServerEncryptionOptions serverOpts, EncryptionOptions clientOpts) throws IOException {
        SSLFactory.validateSslContext("server_encryption_options", serverOpts, true, false);
        SSLFactory.validateSslContext("client_encryption_options", clientOpts, clientOpts.require_client_auth, false);
    }

    static class CacheKey {
        private final EncryptionOptions encryptionOptions;
        private final ISslContextFactory.SocketType socketType;
        private final String contextDescription;

        public CacheKey(EncryptionOptions encryptionOptions, ISslContextFactory.SocketType socketType, String contextDescription) {
            this.encryptionOptions = encryptionOptions;
            this.socketType = socketType;
            this.contextDescription = contextDescription;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.socketType == cacheKey.socketType && Objects.equals(this.encryptionOptions, cacheKey.encryptionOptions) && Objects.equals(this.contextDescription, cacheKey.contextDescription);
        }

        public int hashCode() {
            int result = 0;
            result += 31 * this.socketType.hashCode();
            result += 31 * this.encryptionOptions.hashCode();
            return result += 31 * this.contextDescription.hashCode();
        }
    }

    public static final class LoggingCipherSuiteFilter
    implements CipherSuiteFilter {
        public static final CipherSuiteFilter QUIET_FILTER = new LoggingCipherSuiteFilter();
        final String settingDescription;

        private LoggingCipherSuiteFilter() {
            this.settingDescription = null;
        }

        public LoggingCipherSuiteFilter(String settingDescription) {
            this.settingDescription = settingDescription;
        }

        public String[] filterCipherSuites(Iterable<String> ciphers, List<String> defaultCiphers, Set<String> supportedCiphers) {
            ArrayList<String> newCiphers;
            Objects.requireNonNull(defaultCiphers, "defaultCiphers");
            Objects.requireNonNull(supportedCiphers, "supportedCiphers");
            if (ciphers == null) {
                newCiphers = new ArrayList<String>(defaultCiphers.size());
                ciphers = defaultCiphers;
            } else {
                newCiphers = new ArrayList(supportedCiphers.size());
            }
            for (String c : ciphers) {
                if (c == null) break;
                if (supportedCiphers.contains(c)) {
                    newCiphers.add(c);
                    continue;
                }
                if (this.settingDescription == null) continue;
                logger.warn("Dropping unsupported cipher_suite {} from {} configuration", (Object)c, (Object)this.settingDescription.toLowerCase());
            }
            if (newCiphers.isEmpty()) {
                throw new IllegalStateException("No ciphers left after filtering supported cipher suite");
            }
            return newCiphers.toArray(new String[0]);
        }
    }
}

