/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cassandra.concurrent.ImmediateExecutor;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.RequestTimeoutException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.metrics.PaxosMetrics;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PaxosOperationLock;
import org.apache.cassandra.service.paxos.PrepareResponse;
import org.apache.cassandra.service.paxos.uncommitted.PaxosBallotTracker;
import org.apache.cassandra.service.paxos.uncommitted.PaxosStateTracker;
import org.apache.cassandra.service.paxos.uncommitted.PaxosUncommittedTracker;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.Nemesis;

public class PaxosState
implements PaxosOperationLock {
    private static volatile boolean DISABLE_COORDINATOR_LOCKING = Boolean.getBoolean("cassandra.paxos.disable_coordinator_locking");
    public static final ConcurrentHashMap<Key, PaxosState> ACTIVE = new ConcurrentHashMap();
    public static final Map<Key, Snapshot> RECENT = Caffeine.newBuilder().maximumWeight(DatabaseDescriptor.getPaxosCacheSizeInMiB() << 20).weigher((k, v) -> Ints.saturatedCast((long)((v.accepted != null ? v.accepted.update.unsharedHeapSize() : 0L) + v.committed.update.unsharedHeapSize()))).executor((Executor)ImmediateExecutor.INSTANCE).build().asMap();
    @Nemesis
    private static final AtomicReferenceFieldUpdater<PaxosState, Snapshot> currentUpdater = AtomicReferenceFieldUpdater.newUpdater(PaxosState.class, Snapshot.class, "current");
    final Key key;
    private int active;
    @Nemesis
    private volatile Snapshot current;
    @Nemesis
    private volatile Thread lockedBy;
    @Nemesis
    private volatile int waiting;
    private static final AtomicReferenceFieldUpdater<PaxosState, Thread> lockedByUpdater = AtomicReferenceFieldUpdater.newUpdater(PaxosState.class, Thread.class, "lockedBy");

    public static void setDisableCoordinatorLocking(boolean disable) {
        DISABLE_COORDINATOR_LOCKING = disable;
    }

    public static boolean getDisableCoordinatorLocking() {
        return DISABLE_COORDINATOR_LOCKING;
    }

    public static PaxosUncommittedTracker uncommittedTracker() {
        return TrackerHandle.tracker.uncommitted();
    }

    public static PaxosBallotTracker ballotTracker() {
        return TrackerHandle.tracker.ballots();
    }

    public static void initializeTrackers() {
        Preconditions.checkState((TrackerHandle.tracker != null ? 1 : 0) != 0);
        PaxosMetrics.initialize();
    }

    public static void maybeRebuildUncommittedState() throws IOException {
        TrackerHandle.tracker.maybeRebuild();
    }

    public static void startAutoRepairs() {
        TrackerHandle.tracker.uncommitted().startAutoRepairs();
    }

    private PaxosState(Key key, Snapshot current) {
        this.key = key;
        this.current = current;
    }

    @VisibleForTesting
    public static PaxosState get(Commit commit) {
        return PaxosState.get(commit.update.partitionKey(), commit.update.metadata());
    }

    public static PaxosState get(DecoratedKey partitionKey, TableMetadata table) {
        return PaxosState.getUnsafe(partitionKey, table).maybeLoad();
    }

    private static PaxosState tryGetUnsafe(DecoratedKey partitionKey, TableMetadata metadata) {
        return ACTIVE.compute(new Key(partitionKey, metadata), (key, cur) -> {
            Snapshot saved;
            if (cur == null && (saved = RECENT.remove(key)) != null) {
                cur = new PaxosState((Key)key, saved);
            }
            if (cur != null) {
                ++cur.active;
            }
            return cur;
        });
    }

    private static PaxosState getUnsafe(DecoratedKey partitionKey, TableMetadata metadata) {
        return ACTIVE.compute(new Key(partitionKey, metadata), (key, cur) -> {
            if (cur == null) {
                cur = new PaxosState((Key)key, RECENT.remove(key));
            }
            ++cur.active;
            return cur;
        });
    }

    private static PaxosState getUnsafe(Commit commit) {
        return PaxosState.getUnsafe(commit.update.partitionKey(), commit.update.metadata());
    }

    @VisibleForTesting
    public static PaxosOperationLock lock(DecoratedKey partitionKey, TableMetadata metadata, long deadline, ConsistencyLevel consistencyForConsensus, boolean isWrite) throws RequestTimeoutException {
        if (DISABLE_COORDINATOR_LOCKING) {
            return PaxosOperationLock.noOp();
        }
        PaxosState lock = ACTIVE.compute(new Key(partitionKey, metadata), (key, cur) -> {
            if (cur == null) {
                cur = new PaxosState((Key)key, RECENT.remove(key));
            }
            ++cur.active;
            return cur;
        });
        try {
            if (!lock.lock(deadline)) {
                throw PaxosState.throwTimeout(metadata, consistencyForConsensus, isWrite);
            }
            return lock;
        }
        catch (Throwable t) {
            lock.close();
            throw t;
        }
    }

    private static RequestTimeoutException throwTimeout(TableMetadata metadata, ConsistencyLevel consistencyForConsensus, boolean isWrite) {
        int blockFor = consistencyForConsensus.blockFor(Keyspace.open(metadata.keyspace).getReplicationStrategy());
        throw isWrite ? new WriteTimeoutException(WriteType.CAS, consistencyForConsensus, 0, blockFor) : new ReadTimeoutException(consistencyForConsensus, 0, blockFor, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PaxosState maybeLoad() {
        block8: {
            try {
                Snapshot current = this.current;
                if (current != null && !(current instanceof UnsafeSnapshot)) break block8;
                PaxosState paxosState = this;
                synchronized (paxosState) {
                    current = this.current;
                    if (current == null || current instanceof UnsafeSnapshot) {
                        Snapshot snapshot = SystemKeyspace.loadPaxosState(this.key.partitionKey, this.key.metadata, 0);
                        currentUpdater.accumulateAndGet(this, snapshot, Snapshot::merge);
                    }
                }
            }
            catch (Throwable t) {
                try {
                    this.close();
                }
                catch (Throwable t2) {
                    t.addSuppressed(t2);
                }
                throw t;
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean lock(long deadline) {
        try {
            Thread thread = Thread.currentThread();
            if (lockedByUpdater.compareAndSet(this, null, thread)) {
                return true;
            }
            PaxosState paxosState = this;
            synchronized (paxosState) {
                ++this.waiting;
                try {
                    block9: while (true) {
                        if (lockedByUpdater.compareAndSet(this, null, thread)) {
                            boolean bl = true;
                            return bl;
                        }
                        while (true) {
                            if (this.lockedBy == null) continue block9;
                            long now = Clock.Global.nanoTime();
                            if (now >= deadline) {
                                boolean bl = false;
                                return bl;
                            }
                            this.wait(1L + (deadline - now - 1L) / 1000000L);
                        }
                        break;
                    }
                }
                finally {
                    --this.waiting;
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeUnlock() {
        if (this.lockedBy == null) {
            return;
        }
        Thread thread = Thread.currentThread();
        if (this.lockedBy == thread) {
            this.lockedBy = null;
            if (this.waiting > 0) {
                PaxosState paxosState = this;
                synchronized (paxosState) {
                    this.notify();
                }
            }
        }
    }

    @Override
    public void close() {
        this.maybeUnlock();
        ACTIVE.compute(this.key, (key, cur) -> {
            assert (cur != null);
            if (--cur.active > 0) {
                return cur;
            }
            Snapshot stash = cur.current;
            if (stash != null && stash.getClass() == Snapshot.class) {
                RECENT.put((Key)key, stash);
            }
            return null;
        });
    }

    Snapshot current(Ballot ballot) {
        return this.current((int)ballot.unix(TimeUnit.SECONDS));
    }

    Snapshot current(int nowInSec) {
        Snapshot current = this.current;
        if (current == null || current.getClass() != Snapshot.class) {
            throw new IllegalStateException();
        }
        return current.removeExpired(nowInSec);
    }

    @VisibleForTesting
    public Snapshot currentSnapshot() {
        return this.current;
    }

    @VisibleForTesting
    public void updateStateUnsafe(Function<Snapshot, Snapshot> f) {
        this.current = f.apply(this.current);
    }

    public MaybePromise promiseIfNewer(Ballot ballot, boolean isWrite) {
        Snapshot after;
        Snapshot before;
        Snapshot realAfter;
        Snapshot realBefore;
        do {
            Ballot latestWriteOrLowBound;
            Ballot latest;
            if (Commit.isAfter(ballot, latest = (before = (realBefore = this.current).removeExpired((int)ballot.unix(TimeUnit.SECONDS))).latestWitnessedOrLowBound(latestWriteOrLowBound = before.latestWriteOrLowBound()))) {
                after = new Snapshot(ballot, isWrite ? ballot : before.promisedWrite, before.accepted, before.committed);
                if (currentUpdater.compareAndSet(this, before, after)) {
                    if (isWrite) {
                        Tracing.trace("Promising read/write ballot {}", (Object)ballot);
                        SystemKeyspace.savePaxosWritePromise(this.key.partitionKey, this.key.metadata, ballot);
                    } else {
                        Tracing.trace("Promising read ballot {}", (Object)ballot);
                        SystemKeyspace.savePaxosReadPromise(this.key.partitionKey, this.key.metadata, ballot);
                    }
                    return MaybePromise.promise(before, after);
                }
            } else {
                if (Commit.isAfter(ballot, latestWriteOrLowBound)) {
                    Tracing.trace("Permitting only read by ballot {}", (Object)ballot);
                    return MaybePromise.permitRead(before, latest);
                }
                Tracing.trace("Promise rejected; {} older than {}", (Object)ballot, (Object)latest);
                return MaybePromise.reject(before, latest);
            }
            realAfter = new Snapshot(ballot, isWrite ? ballot : realBefore.promisedWrite, realBefore.accepted, realBefore.committed);
            after = new Snapshot(ballot, realAfter.promisedWrite, before.accepted, before.committed);
        } while (!currentUpdater.compareAndSet(this, realBefore, realAfter));
        Tracing.trace("Promising ballot {}", (Object)ballot);
        if (isWrite) {
            SystemKeyspace.savePaxosWritePromise(this.key.partitionKey, this.key.metadata, ballot);
        } else {
            SystemKeyspace.savePaxosReadPromise(this.key.partitionKey, this.key.metadata, ballot);
        }
        return MaybePromise.promise(before, after);
    }

    public Ballot acceptIfLatest(Commit.Proposal proposal) {
        Snapshot after;
        Snapshot realBefore;
        if (DatabaseDescriptor.paxosStatePurging() == Config.PaxosStatePurging.legacy && !(proposal instanceof Commit.AcceptedWithTTL)) {
            proposal = Commit.AcceptedWithTTL.withDefaultTTL(proposal);
        }
        do {
            Snapshot before;
            Ballot latest;
            if (!proposal.isSameOrAfter(latest = (before = (realBefore = this.current).removeExpired((int)proposal.ballot.unix(TimeUnit.SECONDS))).latestWitnessedOrLowBound())) {
                Tracing.trace("Rejecting proposal {}; latest is now {}", (Object)proposal.ballot, (Object)latest);
                return latest;
            }
            if (!proposal.hasSameBallot(before.committed)) continue;
            return null;
        } while (!currentUpdater.compareAndSet(this, realBefore, after = new Snapshot(realBefore.promised, realBefore.promisedWrite, proposal.accepted(), realBefore.committed)));
        Tracing.trace("Accepting proposal {}", (Object)proposal);
        SystemKeyspace.savePaxosProposal(proposal);
        return null;
    }

    public void commit(Commit.Agreed commit) {
        PaxosState.applyCommit(commit, this, (apply, to) -> currentUpdater.accumulateAndGet((PaxosState)to, new UnsafeSnapshot((Commit)apply), Snapshot::merge));
    }

    public static void commitDirect(Commit commit) {
        PaxosState.applyCommit(commit, null, (apply, ignore) -> {
            try (PaxosState state = PaxosState.tryGetUnsafe(apply.update.partitionKey(), apply.update.metadata());){
                if (state != null) {
                    currentUpdater.accumulateAndGet(state, new UnsafeSnapshot((Commit)apply), Snapshot::merge);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void applyCommit(Commit commit, PaxosState state, BiConsumer<Commit, PaxosState> postCommit) {
        if (DatabaseDescriptor.paxosStatePurging() == Config.PaxosStatePurging.legacy && !(commit instanceof Commit.CommittedWithTTL)) {
            commit = Commit.CommittedWithTTL.withDefaultTTL(commit);
        }
        long start = Clock.Global.nanoTime();
        try {
            if (commit.ballot.unixMicros() >= SystemKeyspace.getTruncatedAt(commit.update.metadata().id)) {
                Tracing.trace("Committing proposal {}", (Object)commit);
                Mutation mutation = commit.makeMutation();
                Keyspace.open(mutation.getKeyspaceName()).apply(mutation, true);
            } else {
                Tracing.trace("Not committing proposal {} as ballot timestamp predates last truncation time", (Object)commit);
            }
            SystemKeyspace.savePaxosCommit(commit);
            postCommit.accept(commit, state);
        }
        finally {
            Keyspace.openAndGetStore((TableMetadata)commit.update.metadata()).metric.casCommit.addNano(Clock.Global.nanoTime() - start);
        }
    }

    /*
     * Exception decompiling
     */
    public static PrepareResponse legacyPrepare(Commit toPrepare) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 21[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Boolean legacyPropose(Commit proposal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 21[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void unsafeReset() {
        ACTIVE.clear();
        RECENT.clear();
        PaxosState.ballotTracker().truncate();
    }

    public static Snapshot unsafeGetIfPresent(DecoratedKey partitionKey, TableMetadata metadata) {
        Key key = new Key(partitionKey, metadata);
        PaxosState cur = ACTIVE.get(key);
        if (cur != null) {
            return cur.current;
        }
        return RECENT.get(key);
    }

    @VisibleForTesting
    public static class MaybePromise {
        final Snapshot before;
        final Snapshot after;
        final Ballot supersededBy;
        final Outcome outcome;

        MaybePromise(Snapshot before, Snapshot after, Ballot supersededBy, Outcome outcome) {
            this.before = before;
            this.after = after;
            this.supersededBy = supersededBy;
            this.outcome = outcome;
        }

        static MaybePromise promise(Snapshot before, Snapshot after) {
            return new MaybePromise(before, after, null, Outcome.PROMISE);
        }

        static MaybePromise permitRead(Snapshot before, Ballot supersededBy) {
            return new MaybePromise(before, before, supersededBy, Outcome.PERMIT_READ);
        }

        static MaybePromise reject(Snapshot snapshot, Ballot supersededBy) {
            return new MaybePromise(snapshot, snapshot, supersededBy, Outcome.REJECT);
        }

        public Outcome outcome() {
            return this.outcome;
        }

        public Ballot supersededBy() {
            return this.supersededBy;
        }

        public static enum Outcome {
            REJECT,
            PERMIT_READ,
            PROMISE;

        }
    }

    public static class UnsafeSnapshot
    extends Snapshot {
        public UnsafeSnapshot(@Nonnull Commit.Committed committed) {
            super(Ballot.none(), Ballot.none(), null, committed);
        }

        public UnsafeSnapshot(@Nonnull Commit committed) {
            this(new Commit.Committed(committed.ballot, committed.update));
        }
    }

    public static class Snapshot {
        @Nonnull
        public final Ballot promised;
        @Nonnull
        public final Ballot promisedWrite;
        @Nullable
        public final Commit.Accepted accepted;
        @Nonnull
        public final Commit.Committed committed;

        public Snapshot(@Nonnull Ballot promised, @Nonnull Ballot promisedWrite, @Nullable Commit.Accepted accepted, @Nonnull Commit.Committed committed) {
            assert (Commit.isAfter(promised, promisedWrite) || promised == promisedWrite);
            assert (accepted == null || accepted.update.partitionKey().equals(committed.update.partitionKey()));
            assert (accepted == null || accepted.update.metadata().id.equals(committed.update.metadata().id));
            assert (accepted == null || committed.isBefore(accepted.ballot));
            this.promised = promised;
            this.promisedWrite = promisedWrite;
            this.accepted = accepted;
            this.committed = committed;
        }

        @Nonnull
        public Ballot latestWitnessedOrLowBound(Ballot latestWriteOrLowBound) {
            return this.promised == this.promisedWrite ? latestWriteOrLowBound : Commit.latest(this.promised, latestWriteOrLowBound);
        }

        @Nonnull
        public Ballot latestWitnessedOrLowBound() {
            Ballot latest = ((Commit.Accepted)Commit.latest(this.accepted, this.committed)).ballot;
            latest = Commit.latest(latest, this.promised);
            latest = Commit.latest(latest, PaxosState.ballotTracker().getLowBound());
            return latest;
        }

        @Nonnull
        public Ballot latestWriteOrLowBound() {
            Ballot latest = this.accepted != null && !this.accepted.update.isEmpty() ? this.accepted.ballot : null;
            latest = Commit.latest(latest, this.committed.ballot);
            latest = Commit.latest(latest, this.promisedWrite);
            latest = Commit.latest(latest, PaxosState.ballotTracker().getLowBound());
            return latest;
        }

        public static Snapshot merge(Snapshot a, Snapshot b) {
            Commit.Accepted accepted;
            Ballot promisedWrite;
            Ballot promised;
            if (a == null || b == null) {
                return a == null ? b : a;
            }
            Commit.Committed committed = Commit.Committed.latestCommitted(a.committed, b.committed);
            if (a instanceof UnsafeSnapshot && b instanceof UnsafeSnapshot) {
                return new UnsafeSnapshot(committed);
            }
            if (a instanceof UnsafeSnapshot || b instanceof UnsafeSnapshot) {
                if (a instanceof UnsafeSnapshot) {
                    a = b;
                }
                if (committed == a.committed) {
                    return a;
                }
                promised = a.promised;
                promisedWrite = a.promisedWrite;
                accepted = Commit.isAfter((Commit)a.accepted, (Commit)committed) ? a.accepted : null;
            } else {
                accepted = Commit.Accepted.latestAccepted(a.accepted, b.accepted);
                accepted = Commit.isAfter((Commit)accepted, (Commit)committed) ? accepted : null;
                promised = Commit.latest(a.promised, b.promised);
                promisedWrite = Commit.latest(a.promisedWrite, b.promisedWrite);
            }
            return new Snapshot(promised, promisedWrite, accepted, committed);
        }

        Snapshot removeExpired(int nowInSec) {
            boolean isAcceptedExpired = this.accepted != null && this.accepted.isExpired(nowInSec);
            boolean isCommittedExpired = this.committed.isExpired(nowInSec);
            if (DatabaseDescriptor.paxosStatePurging() == Config.PaxosStatePurging.gc_grace) {
                long expireOlderThan = TimeUnit.SECONDS.toMicros(nowInSec - this.committed.update.metadata().params.gcGraceSeconds);
                isAcceptedExpired |= this.accepted != null && this.accepted.ballot.unixMicros() < expireOlderThan;
                isCommittedExpired |= this.committed.ballot.unixMicros() < expireOlderThan;
            }
            if (!isAcceptedExpired && !isCommittedExpired) {
                return this;
            }
            return new Snapshot(this.promised, this.promisedWrite, isAcceptedExpired ? null : this.accepted, isCommittedExpired ? Commit.Committed.none(this.committed.update.partitionKey(), this.committed.update.metadata()) : this.committed);
        }
    }

    public static class Key {
        final DecoratedKey partitionKey;
        final TableMetadata metadata;

        public Key(DecoratedKey partitionKey, TableMetadata metadata) {
            this.partitionKey = partitionKey;
            this.metadata = metadata;
        }

        public int hashCode() {
            return this.partitionKey.hashCode() * 31 + this.metadata.id.hashCode();
        }

        public boolean equals(Object that) {
            return that instanceof Key && this.equals((Key)that);
        }

        public boolean equals(Key that) {
            return this.partitionKey.equals(that.partitionKey) && this.metadata.id.equals(that.metadata.id);
        }
    }

    private static class TrackerHandle {
        static final PaxosStateTracker tracker;

        private TrackerHandle() {
        }

        static {
            try {
                tracker = PaxosStateTracker.create(Directories.dataDirectories);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

