/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.reservoirsampling;

import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.reservoirsampling.ReservoirSamplingData;
import org.apache.hop.pipeline.transforms.reservoirsampling.ReservoirSamplingMeta;

public class ReservoirSampling
extends BaseTransform<ReservoirSamplingMeta, ReservoirSamplingData> {
    public ReservoirSampling(TransformMeta transformMeta, ReservoirSamplingMeta meta, ReservoirSamplingData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        if (((ReservoirSamplingData)this.data).getProcessingMode() == ReservoirSamplingData.PROC_MODE.DISABLED) {
            this.setOutputDone();
            ((ReservoirSamplingData)this.data).cleanUp();
            return false;
        }
        Object[] row = this.getRow();
        if (this.first) {
            this.first = false;
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            ((ReservoirSamplingData)this.data).setOutputRowMeta(this.getInputRowMeta().clone());
            String sampleSize = this.resolve(((ReservoirSamplingMeta)this.meta).getSampleSize());
            String seed = this.resolve(((ReservoirSamplingMeta)this.meta).getSeed());
            ((ReservoirSamplingData)this.data).initialize(Integer.parseInt(sampleSize), Integer.parseInt(seed));
        }
        boolean finished = false;
        if (((ReservoirSamplingData)this.data).getProcessingMode() == ReservoirSamplingData.PROC_MODE.PASS_THROUGH) {
            finished = this.passThroughRow(row);
        } else if (((ReservoirSamplingData)this.data).getProcessingMode() == ReservoirSamplingData.PROC_MODE.SAMPLING) {
            finished = this.sampleRow(row);
        }
        if (finished) {
            return false;
        }
        if (this.isRowLevel()) {
            this.logRowlevel("Read row #" + this.getLinesRead() + " : " + Arrays.toString(row));
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Line number " + this.getLinesRead());
        }
        return true;
    }

    private boolean sampleRow(Object[] r) throws HopTransformException {
        if (r == null) {
            List<Object[]> samples = ((ReservoirSamplingData)this.data).getSamples();
            int numRows = samples != null ? samples.size() : 0;
            this.logBasic(this.getTransformName() + " Actual/Sample: " + numRows + "/" + ((ReservoirSamplingData)this.data).sampleSize + " Seed:" + this.resolve(((ReservoirSamplingMeta)this.meta).seed));
            if (samples != null) {
                for (Object[] sample : samples) {
                    if (sample == null) break;
                    this.putRow(((ReservoirSamplingData)this.data).getOutputRowMeta(), sample);
                }
            }
            this.setOutputDone();
            ((ReservoirSamplingData)this.data).cleanUp();
            return true;
        }
        ((ReservoirSamplingData)this.data).addRowToSamples(r);
        return false;
    }

    private boolean passThroughRow(Object[] r) throws HopTransformException {
        if (r == null) {
            this.setOutputDone();
            ((ReservoirSamplingData)this.data).cleanUp();
            return true;
        }
        this.putRow(((ReservoirSamplingData)this.data).getOutputRowMeta(), r);
        return false;
    }
}

