/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline;

import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.CommandGroupUsage;
import io.airlift.airline.CommandUsage;
import io.airlift.airline.GlobalUsage;
import io.airlift.airline.GlobalUsageSummary;
import io.airlift.airline.model.CommandGroupMetadata;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.GlobalMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;

@Command(name="help", description="Display help information")
public class Help
implements Runnable,
Callable<Void> {
    @Inject
    public GlobalMetadata global;
    @Arguments
    public List<String> command = new ArrayList<String>();

    @Override
    public void run() {
        Help.help(this.global, this.command);
    }

    @Override
    public Void call() {
        this.run();
        return null;
    }

    public static void help(CommandMetadata command) {
        StringBuilder stringBuilder = new StringBuilder();
        Help.help(command, stringBuilder);
        System.out.println(stringBuilder.toString());
    }

    public static void help(CommandMetadata command, StringBuilder out) {
        new CommandUsage().usage(null, null, command.getName(), command, out);
    }

    public static void help(GlobalMetadata global, List<String> commandNames) {
        StringBuilder stringBuilder = new StringBuilder();
        Help.help(global, commandNames, stringBuilder);
        System.out.println(stringBuilder.toString());
    }

    public static void help(GlobalMetadata global, List<String> commandNames, StringBuilder out) {
        if (commandNames.isEmpty()) {
            new GlobalUsageSummary().usage(global, out);
            return;
        }
        String name = commandNames.get(0);
        if (name.equals(global.getName())) {
            new GlobalUsage().usage(global, out);
            return;
        }
        for (CommandMetadata command : global.getDefaultGroupCommands()) {
            if (!name.equals(command.getName())) continue;
            new CommandUsage().usage(global.getName(), null, command.getName(), command, out);
            return;
        }
        for (CommandGroupMetadata group : global.getCommandGroups()) {
            if (!name.endsWith(group.getName())) continue;
            if (commandNames.size() == 1) {
                new CommandGroupUsage().usage(global, group, out);
                return;
            }
            String commandName = commandNames.get(1);
            for (CommandMetadata command : group.getCommands()) {
                if (!commandName.equals(command.getName())) continue;
                new CommandUsage().usage(global.getName(), group.getName(), command.getName(), command, out);
                return;
            }
            System.out.println("Unknown command " + name + " " + commandName);
        }
        System.out.println("Unknown command " + name);
    }
}

