/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Fuseable;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.InternalMonoOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;

final class MonoHasElement<T>
extends InternalMonoOperator<T, Boolean>
implements Fuseable {
    MonoHasElement(Mono<? extends T> source) {
        super(source);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super Boolean> actual) {
        return new HasElementSubscriber((CoreSubscriber<? super Boolean>)((CoreSubscriber<Boolean>)actual));
    }

    static final class HasElementSubscriber<T>
    extends Operators.BaseFluxToMonoOperator<T, Boolean> {
        boolean done;

        HasElementSubscriber(CoreSubscriber<? super Boolean> actual) {
            super(actual);
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            return super.scanUnsafe(key);
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.currentContext());
                return;
            }
            this.done = true;
            Operators.onDiscard(t, this.currentContext());
            this.actual.onNext(true);
            this.actual.onComplete();
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.currentContext());
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.completePossiblyEmpty();
        }

        @Override
        Boolean accumulatedValue() {
            return false;
        }
    }
}

