/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.mysqlbulkload;

import java.io.File;
import java.util.List;
import lombok.Generated;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;

@Action(id="MYSQL_BULK_LOAD", name="i18n::ActionMysqlBulkLoad.Name", description="i18n::ActionMysqlBulkLoad.Description", image="MysqlBulkLoad.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.BulkLoading", keywords={"i18n::ActionMysqlBulkLoad.keyword"}, documentationUrl="/workflow/actions/mysqlbulkload.html", classLoaderGroup="mysql-db", isIncludeJdbcDrivers=true)
public class ActionMysqlBulkLoad
extends ActionBase {
    private static final Class<?> PKG = ActionMysqlBulkLoad.class;
    @HopMetadataProperty(key="schemaname")
    private String schemaName = null;
    @HopMetadataProperty(key="tablename")
    private String tableName = null;
    @HopMetadataProperty(key="filename")
    private String fileName = null;
    @HopMetadataProperty(key="separator")
    private String separator = null;
    @HopMetadataProperty(key="enclosed")
    private String enclosed = null;
    @HopMetadataProperty(key="escaped")
    private String escaped = null;
    @HopMetadataProperty(key="linestarted")
    private String lineStarted = null;
    @HopMetadataProperty(key="lineterminated")
    private String lineTerminated = null;
    @HopMetadataProperty(key="ignorelines")
    private String ignoreLines = "0";
    @HopMetadataProperty(key="replacedata")
    private boolean replaceData = true;
    @HopMetadataProperty(key="listattribut")
    private String listAttribute = null;
    @HopMetadataProperty(key="localinfile")
    private boolean localInFile = true;
    @HopMetadataProperty(key="prorityvalue")
    public int prorityValue;
    @HopMetadataProperty(key="addfiletoresult")
    private boolean addFileToResult = false;
    @HopMetadataProperty(key="connection")
    private String connection = null;

    public ActionMysqlBulkLoad(String n) {
        super(n, "");
    }

    public ActionMysqlBulkLoad() {
        this("");
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public Result execute(Result previousResult, int nr) {
        Result result;
        block39: {
            Object ignoreNbrLignes = "";
            Object listOfColumn = "";
            String localExec = "";
            String priorityText = "";
            Object lineTerminatedby = "";
            Object fieldTerminatedby = "";
            result = previousResult;
            result.setResult(false);
            String vfsFilename = this.resolve(this.fileName);
            if (!Utils.isEmpty((CharSequence)vfsFilename)) {
                try {
                    FileObject fileObject = HopVfs.getFileObject((String)vfsFilename);
                    if (!(fileObject instanceof LocalFile)) {
                        throw new HopException("Only local files are supported at this time, file [" + vfsFilename + "] is not a local file.");
                    }
                    String realFilename = HopVfs.getFilename((FileObject)fileObject);
                    File file = new File(realFilename);
                    if (file.exists() && file.canRead() || !this.isLocalInFile()) {
                        if (this.isDetailed()) {
                            this.logDetailed("File [" + realFilename + "] exists.");
                        }
                        if (this.connection != null) {
                            DatabaseMeta databaseMeta = null;
                            try {
                                databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)this.getMetadataProvider(), (String)this.connection);
                            }
                            catch (Exception e) {
                                this.logError("Unable to load database :" + this.connection, e);
                            }
                            try (Database db = new Database((ILoggingObject)this, (IVariables)this, databaseMeta);){
                                db.connect();
                                String realSchemaname = this.resolve(this.schemaName);
                                Object realTablename = this.resolve(this.tableName);
                                if (db.checkTableExists(realSchemaname, (String)realTablename)) {
                                    if (this.isDetailed()) {
                                        this.logDetailed("Table [" + (String)realTablename + "] exists.");
                                    }
                                    if (this.schemaName != null) {
                                        realTablename = realSchemaname + "." + (String)realTablename;
                                    }
                                    String replaceIgnore = this.isReplaceData() ? "REPLACE" : "IGNORE";
                                    if (Const.toInt((String)this.getRealIgnorelines(), (int)0) > 0) {
                                        ignoreNbrLignes = "IGNORE " + this.getRealIgnorelines() + " LINES";
                                    }
                                    if (this.getRealListattribut() != null) {
                                        listOfColumn = "(" + this.mysqlString(this.getRealListattribut()) + ")";
                                    }
                                    if (this.isLocalInFile()) {
                                        localExec = "LOCAL";
                                    }
                                    if (this.prorityValue == 1) {
                                        priorityText = "LOW_PRIORITY";
                                    } else if (this.prorityValue == 2) {
                                        priorityText = "CONCURRENT";
                                    }
                                    if (this.getRealSeparator() != null || this.getRealEnclosed() != null || this.getRealEscaped() != null) {
                                        fieldTerminatedby = "FIELDS ";
                                        if (this.getRealSeparator() != null) {
                                            fieldTerminatedby = (String)fieldTerminatedby + "TERMINATED BY '" + Const.replace((String)this.getRealSeparator(), (String)"'", (String)"''") + "'";
                                        }
                                        if (this.getRealEnclosed() != null) {
                                            fieldTerminatedby = (String)fieldTerminatedby + " ENCLOSED BY '" + Const.replace((String)this.getRealEnclosed(), (String)"'", (String)"''") + "'";
                                        }
                                        if (this.getRealEscaped() != null) {
                                            fieldTerminatedby = (String)fieldTerminatedby + " ESCAPED BY '" + Const.replace((String)this.getRealEscaped(), (String)"'", (String)"''") + "'";
                                        }
                                    }
                                    if (this.getRealLinestarted() != null || this.getRealLineterminated() != null) {
                                        lineTerminatedby = "LINES ";
                                        if (this.getRealLinestarted() != null) {
                                            lineTerminatedby = (String)lineTerminatedby + "STARTING BY '" + Const.replace((String)this.getRealLinestarted(), (String)"'", (String)"''") + "'";
                                        }
                                        if (this.getRealLineterminated() != null) {
                                            lineTerminatedby = (String)lineTerminatedby + " TERMINATED BY '" + Const.replace((String)this.getRealLineterminated(), (String)"'", (String)"''") + "'";
                                        }
                                    }
                                    String sqlBulkLoad = "LOAD DATA " + priorityText + " " + localExec + " INFILE '" + realFilename.replace('\\', '/') + "' " + replaceIgnore + " INTO TABLE " + (String)realTablename + " " + (String)fieldTerminatedby + " " + (String)lineTerminatedby + " " + (String)ignoreNbrLignes + " " + (String)listOfColumn + ";";
                                    try {
                                        db.execStatement(sqlBulkLoad);
                                        if (this.isAddFileToResult()) {
                                            ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)realFilename), this.parentWorkflow.getWorkflowName(), this.toString());
                                            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                                        }
                                        result.setResult(true);
                                    }
                                    catch (HopDatabaseException je) {
                                        result.setNrErrors(1L);
                                        this.logError("An error occurred executing this action : " + je.getMessage());
                                    }
                                    catch (HopFileException e) {
                                        this.logError("An error occurred executing this action : " + e.getMessage());
                                        result.setNrErrors(1L);
                                    }
                                } else {
                                    result.setNrErrors(1L);
                                    if (this.isDetailed()) {
                                        this.logDetailed("Table [" + (String)realTablename + "] doesn't exist!");
                                    }
                                }
                                break block39;
                            }
                            catch (HopDatabaseException dbe) {
                                result.setNrErrors(1L);
                                this.logError("An error occurred executing this entry: " + dbe.getMessage());
                            }
                            break block39;
                        }
                        result.setNrErrors(1L);
                        this.logError(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Nodatabase.Label", (String[])new String[0]));
                        break block39;
                    }
                    result.setNrErrors(1L);
                    this.logError("File [" + realFilename + "] doesn't exist!");
                }
                catch (Exception e) {
                    result.setNrErrors(1L);
                    this.logError(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.UnexpectedError.Label", (String[])new String[0]), e);
                }
            } else {
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(PKG, (String)"ActionMysqlBulkLoad.Nofilename.Label", (String[])new String[0]));
            }
        }
        return result;
    }

    public String getRealEnclosed() {
        return this.resolve(this.getEnclosed());
    }

    public String getRealEscaped() {
        return this.resolve(this.getEscaped());
    }

    public String getRealLinestarted() {
        return this.resolve(this.getLineStarted());
    }

    public String getRealLineterminated() {
        return this.resolve(this.getLineTerminated());
    }

    public String getRealSeparator() {
        return this.resolve(this.getSeparator());
    }

    public String getRealIgnorelines() {
        return this.resolve(this.getIgnoreLines());
    }

    public String getRealListattribut() {
        return this.resolve(this.getListAttribute());
    }

    private String mysqlString(String listcolumns) {
        Object returnString = "";
        String[] split = listcolumns.split(",");
        for (int i = 0; i < split.length; ++i) {
            returnString = ((String)returnString).equals("") ? "`" + Const.trim((String)split[i]) + "`" : (String)returnString + ", `" + Const.trim((String)split[i]) + "`";
        }
        return returnString;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        ResourceReference reference = null;
        if (this.connection != null) {
            DatabaseMeta databaseMeta = null;
            try {
                databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)this.getMetadataProvider(), (String)this.connection);
            }
            catch (Exception e) {
                this.logError("Unable to load database :" + this.connection, e);
            }
            reference = new ResourceReference((IResourceHolder)this);
            references.add(reference);
            reference.getEntries().add(new ResourceEntry(databaseMeta.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(databaseMeta.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
        }
        if (this.fileName != null) {
            String realFilename = this.getRealFilename();
            if (reference == null) {
                reference = new ResourceReference((IResourceHolder)this);
                references.add(reference);
            }
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.FILE));
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileExistsValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, ctx);
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "tablename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public String getSeparator() {
        return this.separator;
    }

    @Generated
    public String getEnclosed() {
        return this.enclosed;
    }

    @Generated
    public String getEscaped() {
        return this.escaped;
    }

    @Generated
    public String getLineStarted() {
        return this.lineStarted;
    }

    @Generated
    public String getLineTerminated() {
        return this.lineTerminated;
    }

    @Generated
    public String getIgnoreLines() {
        return this.ignoreLines;
    }

    @Generated
    public boolean isReplaceData() {
        return this.replaceData;
    }

    @Generated
    public String getListAttribute() {
        return this.listAttribute;
    }

    @Generated
    public boolean isLocalInFile() {
        return this.localInFile;
    }

    @Generated
    public int getProrityValue() {
        return this.prorityValue;
    }

    @Generated
    public boolean isAddFileToResult() {
        return this.addFileToResult;
    }

    @Generated
    public String getConnection() {
        return this.connection;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Generated
    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Generated
    public void setEnclosed(String enclosed) {
        this.enclosed = enclosed;
    }

    @Generated
    public void setEscaped(String escaped) {
        this.escaped = escaped;
    }

    @Generated
    public void setLineStarted(String lineStarted) {
        this.lineStarted = lineStarted;
    }

    @Generated
    public void setLineTerminated(String lineTerminated) {
        this.lineTerminated = lineTerminated;
    }

    @Generated
    public void setIgnoreLines(String ignoreLines) {
        this.ignoreLines = ignoreLines;
    }

    @Generated
    public void setReplaceData(boolean replaceData) {
        this.replaceData = replaceData;
    }

    @Generated
    public void setListAttribute(String listAttribute) {
        this.listAttribute = listAttribute;
    }

    @Generated
    public void setLocalInFile(boolean localInFile) {
        this.localInFile = localInFile;
    }

    @Generated
    public void setProrityValue(int prorityValue) {
        this.prorityValue = prorityValue;
    }

    @Generated
    public void setAddFileToResult(boolean addFileToResult) {
        this.addFileToResult = addFileToResult;
    }

    @Generated
    public void setConnection(String connection) {
        this.connection = connection;
    }
}

