/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CreateDataflowView<@UnknownKeyFor ElemT, @UnknownKeyFor ViewT>
extends PTransform<PCollection<ElemT>, PCollection<ElemT>> {
    private final @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> view;
    private final @UnknownKeyFor @NonNull @Initialized boolean streaming;

    public static <ElemT, ViewT> @UnknownKeyFor @NonNull @Initialized CreateDataflowView<ElemT, ViewT> forBatch(@UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> view) {
        return new CreateDataflowView<ElemT, ViewT>(view, false);
    }

    public static <ElemT, ViewT> @UnknownKeyFor @NonNull @Initialized CreateDataflowView<ElemT, ViewT> forStreaming(@UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> view) {
        return new CreateDataflowView<ElemT, ViewT>(view, true);
    }

    private CreateDataflowView(@UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> view, @UnknownKeyFor @NonNull @Initialized boolean streaming) {
        this.view = view;
        this.streaming = streaming;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<ElemT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<ElemT> input) {
        if (this.streaming) {
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)input.getWindowingStrategy(), (PCollection.IsBounded)input.isBounded(), (Coder)input.getCoder());
        }
        return this.view.getPCollection();
    }

    public @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> getView() {
        return this.view;
    }
}

