/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.HttpEntityWrapper;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHttpEntityWrapper {
    TestHttpEntityWrapper() {
    }

    @Test
    void testBasics() throws Exception {
        StringEntity entity = new StringEntity("Message content", ContentType.TEXT_PLAIN, "blah", false);
        try (HttpEntityWrapper wrapped = new HttpEntityWrapper((HttpEntity)entity);){
            Assertions.assertEquals((long)entity.getContentLength(), (long)wrapped.getContentLength());
            Assertions.assertEquals((Object)entity.getContentType(), (Object)wrapped.getContentType());
            Assertions.assertEquals((Object)entity.getContentEncoding(), (Object)wrapped.getContentEncoding());
            Assertions.assertEquals((Object)entity.isChunked(), (Object)wrapped.isChunked());
            Assertions.assertEquals((Object)entity.isRepeatable(), (Object)wrapped.isRepeatable());
            Assertions.assertEquals((Object)entity.isStreaming(), (Object)wrapped.isStreaming());
            Assertions.assertNotNull((Object)wrapped.getContent());
        }
    }

    @Test
    void testIllegalConstructor() {
        Assertions.assertThrows(NullPointerException.class, () -> new HttpEntityWrapper(null));
    }

    @Test
    void testWriteTo() throws Exception {
        String s = "Message content";
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        StringEntity entity = new StringEntity("Message content");
        try (HttpEntityWrapper wrapped = new HttpEntityWrapper((HttpEntity)entity);){
            int i;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            wrapped.writeTo((OutputStream)out);
            byte[] bytes2 = out.toByteArray();
            Assertions.assertNotNull((Object)bytes2);
            Assertions.assertEquals((int)bytes.length, (int)bytes2.length);
            for (i = 0; i < bytes.length; ++i) {
                Assertions.assertEquals((byte)bytes[i], (byte)bytes2[i]);
            }
            out = new ByteArrayOutputStream();
            wrapped.writeTo((OutputStream)out);
            bytes2 = out.toByteArray();
            Assertions.assertNotNull((Object)bytes2);
            Assertions.assertEquals((int)bytes.length, (int)bytes2.length);
            for (i = 0; i < bytes.length; ++i) {
                Assertions.assertEquals((byte)bytes[i], (byte)bytes2[i]);
            }
            Assertions.assertThrows(NullPointerException.class, () -> wrapped.writeTo(null));
        }
    }

    @Test
    void testConsumeContent() throws Exception {
        String s = "Message content";
        StringEntity entity = new StringEntity("Message content");
        HttpEntityWrapper wrapped = new HttpEntityWrapper((HttpEntity)entity);
        EntityUtils.consume((HttpEntity)wrapped);
        Assertions.assertDoesNotThrow(() -> EntityUtils.consume((HttpEntity)wrapped));
    }
}

