/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.io.BHttpConnectionBase;
import org.apache.hc.core5.http.impl.io.ChunkedInputStream;
import org.apache.hc.core5.http.impl.io.ContentLengthInputStream;
import org.apache.hc.core5.http.impl.io.IdentityInputStream;
import org.apache.hc.core5.http.io.SessionInputBuffer;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

class TestBHttpConnectionBase {
    @Mock
    private Socket socket;
    private BHttpConnectionBase conn;

    TestBHttpConnectionBase() {
    }

    @BeforeEach
    void prepareMocks() {
        MockitoAnnotations.openMocks((Object)this);
        this.conn = new BHttpConnectionBase(Http1Config.DEFAULT, null, null);
    }

    @Test
    void testBasics() {
        Assertions.assertFalse((boolean)this.conn.isOpen());
        Assertions.assertNull((Object)this.conn.getLocalAddress());
        Assertions.assertNull((Object)this.conn.getRemoteAddress());
        Assertions.assertEquals((Object)"[Not bound]", (Object)this.conn.toString());
    }

    @Test
    void testSocketBind() throws Exception {
        InetAddress localAddress = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        int localPort = 8888;
        InetAddress remoteAddress = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        int remotePort = 80;
        InetSocketAddress localSockAddress = new InetSocketAddress(localAddress, 8888);
        InetSocketAddress remoteSockAddress = new InetSocketAddress(remoteAddress, 80);
        Mockito.when((Object)this.socket.getLocalSocketAddress()).thenReturn((Object)localSockAddress);
        Mockito.when((Object)this.socket.getRemoteSocketAddress()).thenReturn((Object)remoteSockAddress);
        this.conn.bind(this.socket);
        Assertions.assertEquals((Object)"127.0.0.1:8888<->10.0.0.2:80", (Object)this.conn.toString());
        Assertions.assertTrue((boolean)this.conn.isOpen());
        Assertions.assertEquals((Object)new InetSocketAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 1}), 8888), (Object)this.conn.getLocalAddress());
        Assertions.assertEquals((Object)new InetSocketAddress(InetAddress.getByAddress(new byte[]{10, 0, 0, 2}), 80), (Object)this.conn.getRemoteAddress());
    }

    @Test
    void testConnectionClose() throws Exception {
        OutputStream outStream = (OutputStream)Mockito.mock(OutputStream.class);
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        this.conn.outbuffer.write(0, outStream);
        Assertions.assertTrue((boolean)this.conn.isOpen());
        this.conn.close();
        Assertions.assertFalse((boolean)this.conn.isOpen());
        ((OutputStream)Mockito.verify((Object)outStream, (VerificationMode)Mockito.times((int)1))).write((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).close();
        this.conn.close();
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).close();
        ((OutputStream)Mockito.verify((Object)outStream, (VerificationMode)Mockito.times((int)1))).write((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
    }

    @Test
    void testConnectionShutdown() throws Exception {
        OutputStream outStream = (OutputStream)Mockito.mock(OutputStream.class);
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        this.conn.outbuffer.write(0, outStream);
        Assertions.assertTrue((boolean)this.conn.isOpen());
        this.conn.close(CloseMode.GRACEFUL);
        Assertions.assertFalse((boolean)this.conn.isOpen());
        ((OutputStream)Mockito.verify((Object)outStream, (VerificationMode)Mockito.never())).write((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.never())).shutdownInput();
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.never())).shutdownOutput();
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).close();
        this.conn.close();
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).close();
        this.conn.close(CloseMode.GRACEFUL);
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    void testCreateEntityLengthDelimited() throws Exception {
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        BasicClassicHttpResponse message = new BasicClassicHttpResponse(200, "OK");
        message.addHeader("Content-Length", (Object)"10");
        message.addHeader("Content-Type", (Object)"stuff");
        message.addHeader("Content-Encoding", (Object)"chunked");
        HttpEntity entity = this.conn.createIncomingEntity((HttpMessage)message, (SessionInputBuffer)this.conn.inBuffer, inStream, 10L);
        Assertions.assertNotNull((Object)entity);
        Assertions.assertFalse((boolean)entity.isChunked());
        Assertions.assertEquals((long)10L, (long)entity.getContentLength());
        Assertions.assertEquals((Object)"stuff", (Object)entity.getContentType());
        Assertions.assertEquals((Object)"chunked", (Object)entity.getContentEncoding());
        InputStream content = entity.getContent();
        Assertions.assertNotNull((Object)content);
        Assertions.assertInstanceOf(ContentLengthInputStream.class, (Object)content);
    }

    @Test
    void testCreateEntityInputChunked() throws Exception {
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        BasicClassicHttpResponse message = new BasicClassicHttpResponse(200, "OK");
        HttpEntity entity = this.conn.createIncomingEntity((HttpMessage)message, (SessionInputBuffer)this.conn.inBuffer, inStream, -1L);
        Assertions.assertNotNull((Object)entity);
        Assertions.assertTrue((boolean)entity.isChunked());
        Assertions.assertEquals((long)-1L, (long)entity.getContentLength());
        InputStream content = entity.getContent();
        Assertions.assertNotNull((Object)content);
        Assertions.assertInstanceOf(ChunkedInputStream.class, (Object)content);
    }

    @Test
    void testCreateEntityInputUndefined() throws Exception {
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        BasicClassicHttpResponse message = new BasicClassicHttpResponse(200, "OK");
        HttpEntity entity = this.conn.createIncomingEntity((HttpMessage)message, (SessionInputBuffer)this.conn.inBuffer, inStream, -9223372036854775807L);
        Assertions.assertNotNull((Object)entity);
        Assertions.assertFalse((boolean)entity.isChunked());
        Assertions.assertEquals((long)-1L, (long)entity.getContentLength());
        InputStream content = entity.getContent();
        Assertions.assertNotNull((Object)content);
        Assertions.assertInstanceOf(IdentityInputStream.class, (Object)content);
    }

    @Test
    void testSetSocketTimeout() throws Exception {
        this.conn.bind(this.socket);
        this.conn.setSocketTimeout(Timeout.ofMilliseconds((long)123L));
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).setSoTimeout(123);
    }

    @Test
    void testSetSocketTimeoutException() throws Exception {
        this.conn.bind(this.socket);
        ((Socket)Mockito.doThrow((Throwable[])new Throwable[]{new SocketException()}).when((Object)this.socket)).setSoTimeout(ArgumentMatchers.anyInt());
        this.conn.setSocketTimeout(Timeout.ofMilliseconds((long)123L));
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).setSoTimeout(123);
    }

    @Test
    void testGetSocketTimeout() throws Exception {
        Assertions.assertEquals((Object)Timeout.INFINITE, (Object)this.conn.getSocketTimeout());
        Mockito.when((Object)this.socket.getSoTimeout()).thenReturn((Object)345);
        this.conn.bind(this.socket);
        Assertions.assertEquals((Object)Timeout.ofMilliseconds((long)345L), (Object)this.conn.getSocketTimeout());
    }

    @Test
    void testGetSocketTimeoutException() throws Exception {
        Assertions.assertEquals((Object)Timeout.INFINITE, (Object)this.conn.getSocketTimeout());
        Mockito.when((Object)this.socket.getSoTimeout()).thenThrow(new Throwable[]{new SocketException()});
        this.conn.bind(this.socket);
        Assertions.assertEquals((Object)Timeout.INFINITE, (Object)this.conn.getSocketTimeout());
    }

    @Test
    void testAwaitInputInBuffer() throws Exception {
        ByteArrayInputStream inStream = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        this.conn.inBuffer.read((InputStream)inStream);
        Assertions.assertTrue((boolean)this.conn.awaitInput(Timeout.ofMilliseconds((long)432L)));
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.never())).setSoTimeout(ArgumentMatchers.anyInt());
    }

    @Test
    void testAwaitInputInSocket() throws Exception {
        ByteArrayInputStream inStream = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        Mockito.when((Object)this.socket.getSoTimeout()).thenReturn((Object)345);
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        Assertions.assertTrue((boolean)this.conn.awaitInput(Timeout.ofMilliseconds((long)432L)));
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).setSoTimeout(432);
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).setSoTimeout(345);
    }

    @Test
    void testAwaitInputNoData() throws Exception {
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        Mockito.when((Object)inStream.read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)-1);
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        Assertions.assertFalse((boolean)this.conn.awaitInput(Timeout.ofMilliseconds((long)432L)));
    }

    @Test
    void testStaleWhenClosed() throws Exception {
        OutputStream outStream = (OutputStream)Mockito.mock(OutputStream.class);
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        this.conn.close();
        Assertions.assertTrue((boolean)this.conn.isStale());
    }

    @Test
    void testNotStaleWhenHasData() throws Exception {
        ByteArrayInputStream inStream = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        Assertions.assertFalse((boolean)this.conn.isStale());
    }

    @Test
    void testStaleWhenEndOfStream() throws Exception {
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        Mockito.when((Object)inStream.read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)-1);
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        Assertions.assertTrue((boolean)this.conn.isStale());
    }

    @Test
    void testNotStaleWhenTimeout() throws Exception {
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        Mockito.when((Object)inStream.read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{new SocketTimeoutException()});
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        Assertions.assertFalse((boolean)this.conn.isStale());
    }

    @Test
    void testStaleWhenIOError() throws Exception {
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        Mockito.when((Object)inStream.read((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{new SocketException()});
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        Assertions.assertTrue((boolean)this.conn.isStale());
    }
}

